/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util.cert;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.jivesoftware.util.cert.CertificateIdentityMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SANCertificateIdentityMapping
implements CertificateIdentityMapping {
    private static final Logger Log = LoggerFactory.getLogger(SANCertificateIdentityMapping.class);
    public static final String OTHERNAME_XMPP_OID = "1.3.6.1.5.5.7.8.5";
    public static final String OTHERNAME_SRV_OID = "1.3.6.1.5.5.7.8.7";
    public static final String OTHERNAME_UPN_OID = "1.3.6.1.4.1.311.20.2.3";

    @Override
    public List<String> mapIdentity(X509Certificate certificate) {
        ArrayList<String> identities = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
            for (List<?> item : altNames) {
                String result;
                Integer type = (Integer)item.get(0);
                Object value = item.get(1);
                switch (type) {
                    case 0: {
                        result = this.parseOtherName((byte[])value);
                        break;
                    }
                    case 2: {
                        result = (String)value;
                        break;
                    }
                    case 6: {
                        result = (String)value;
                        break;
                    }
                    default: {
                        result = null;
                    }
                }
                if (result == null) continue;
                identities.add(result);
            }
        }
        catch (CertificateParsingException e) {
            Log.error("Error parsing SubjectAltName in certificate: " + certificate.getSubjectDN(), (Throwable)e);
        }
        return identities;
    }

    @Override
    public String name() {
        return "Subject Alternative Name Mapping";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseOtherName(byte[] item) {
        if (item == null) return null;
        if (item.length == 0) {
            return null;
        }
        try (ASN1InputStream decoder = new ASN1InputStream(item);){
            ASN1Primitive object = decoder.readObject();
            ASN1Sequence otherNameSeq = (ASN1Sequence)object;
            ASN1ObjectIdentifier typeId = (ASN1ObjectIdentifier)otherNameSeq.getObjectAt(0);
            ASN1TaggedObject taggedValue = (ASN1TaggedObject)otherNameSeq.getObjectAt(1);
            int tagNo = taggedValue.getTagNo();
            if (tagNo != 0) {
                throw new IllegalArgumentException("subjectAltName 'otherName' sequence's second object is expected to be a tagged value of which the tag number is 0. The tag number that was detected: " + tagNo);
            }
            ASN1Primitive value = taggedValue.getObject();
            switch (typeId.getId()) {
                case "1.3.6.1.5.5.7.8.7": {
                    String string = this.parseOtherNameDnsSrv(value);
                    return string;
                }
                case "1.3.6.1.5.5.7.8.5": {
                    String string = this.parseOtherNameXmppAddr(value);
                    return string;
                }
                case "1.3.6.1.4.1.311.20.2.3": {
                    String string = this.parseOtherNameUpn(value);
                    return string;
                }
            }
            String otherName = this.parseOtherName(typeId, value);
            if (otherName != null) {
                String string = otherName;
                return string;
            }
            Log.debug("Ignoring subjectAltName 'otherName' type-id '{}' that's neither id-on-xmppAddr nor id-on-dnsSRV.", (Object)typeId.getId());
            String string = null;
            return string;
        }
        catch (Exception e) {
            Log.warn("Unable to parse a byte array (of length {}) as a subjectAltName 'otherName'. It is ignored.", (Object)item.length, (Object)e);
            return null;
        }
    }

    protected String parseOtherName(ASN1ObjectIdentifier typeId, ASN1Primitive value) {
        return null;
    }

    protected String parseOtherNameDnsSrv(ASN1Primitive srvName) {
        String value = ((ASN1String)srvName).getString();
        if (value.toLowerCase().startsWith("_xmpp-server.")) {
            return value.substring("_xmpp-server.".length());
        }
        if (value.toLowerCase().startsWith("_xmpp-client.")) {
            return value.substring("_xmpp-client.".length());
        }
        Log.debug("srvName value '{}' of id-on-dnsSRV record is neither _xmpp-server nor _xmpp-client. It is being ignored.", (Object)value);
        return null;
    }

    protected String parseOtherNameXmppAddr(ASN1Primitive xmppAddr) {
        return ((ASN1String)xmppAddr).getString();
    }

    protected String parseOtherNameUpn(ASN1Primitive value) {
        ASN1TaggedObject taggedObject;
        ASN1Primitive objectPrimitive;
        String otherName = null;
        if (value instanceof ASN1TaggedObject && (objectPrimitive = (taggedObject = (ASN1TaggedObject)value).getObject()) instanceof ASN1String) {
            otherName = ((ASN1String)objectPrimitive).getString();
        }
        if (otherName == null) {
            Log.warn("UPN type unexpected, UPN extraction failed: " + value.getClass().getName() + ":" + value.toString());
        } else {
            Log.debug("UPN from certificate has value of: " + otherName);
        }
        return otherName;
    }
}

