/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class WebXmlUtils {
    private static final Logger Log = LoggerFactory.getLogger(WebXmlUtils.class);

    public static Document asDocument(File webXML) throws DocumentException {
        SAXReader saxReader = new SAXReader(false);
        try {
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            Log.warn("Error setting SAXReader feature", (Throwable)e);
        }
        return saxReader.read(webXML);
    }

    public static List<String> getServletNames(Document webXml) {
        return WebXmlUtils.getNames("servlet", webXml);
    }

    public static List<String> getFilterNames(Document webXml) {
        return WebXmlUtils.getNames("filter", webXml);
    }

    private static List<String> getNames(String type, Document webXml) {
        ArrayList<String> result = new ArrayList<String>();
        List elements = webXml.getRootElement().elements(type);
        for (Element element : elements) {
            String name = element.elementTextTrim(type + "-name");
            if (name == null || name.isEmpty()) continue;
            result.add(name);
        }
        return result;
    }

    public static String getServletClassName(Document webXml, String servletName) {
        return WebXmlUtils.getClassName("servlet", webXml, servletName);
    }

    public static String getFilterClassName(Document webXml, String filterName) {
        return WebXmlUtils.getClassName("filter", webXml, filterName);
    }

    private static String getClassName(String type, Document webXml, String typeName) {
        String className = null;
        List elements = webXml.getRootElement().elements(type);
        for (Element element : elements) {
            String name = element.elementTextTrim(type + "-name");
            if (!typeName.equals(name)) continue;
            className = element.elementTextTrim(type + "-class");
            break;
        }
        if (className == null || className.isEmpty()) {
            return null;
        }
        return className;
    }

    public static Map<String, String> getServletInitParams(Document webXml, String servletName) {
        return WebXmlUtils.getInitParams("servlet", webXml, servletName);
    }

    public static Map<String, String> getFilterInitParams(Document webXml, String filterName) {
        return WebXmlUtils.getInitParams("filter", webXml, filterName);
    }

    private static Map<String, String> getInitParams(String type, Document webXml, String typeName) {
        HashMap<String, String> result = new HashMap<String, String>();
        List elements = webXml.getRootElement().elements(type);
        for (Element element : elements) {
            String name = element.elementTextTrim(type + "-name");
            if (!typeName.equals(name)) continue;
            List initParamElements = element.elements("init-param");
            for (Element initParamElement : initParamElements) {
                String pName = initParamElement.elementTextTrim("param-name");
                String pValue = initParamElement.elementTextTrim("param-value");
                if (pName == null || pName.isEmpty()) {
                    Log.warn("Unable to add init-param that has no name");
                    continue;
                }
                result.put(pName, pValue);
            }
        }
        return result;
    }

    public static Set<String> getServletUrlPatterns(Document webXml, String servletName) {
        return WebXmlUtils.getUrlPatterns("servlet", webXml, servletName);
    }

    public static Set<String> getFilterUrlPatterns(Document webXml, String filterName) {
        return WebXmlUtils.getUrlPatterns("filter", webXml, filterName);
    }

    private static Set<String> getUrlPatterns(String type, Document webXml, String typeName) {
        HashSet<String> result = new HashSet<String>();
        List elements = webXml.getRootElement().elements(type + "-mapping");
        for (Element element : elements) {
            String name = element.elementTextTrim(type + "-name");
            if (!typeName.equals(name)) continue;
            List urlPatternElements = element.elements("url-pattern");
            for (Element urlPatternElement : urlPatternElements) {
                String urlPattern = urlPatternElement.getTextTrim();
                if (urlPattern == null) continue;
                result.add(urlPattern);
            }
            if (!"filter".equals(type)) break;
            List servletNameElements = element.elements("servlet-name");
            for (Element servletNameElement : servletNameElements) {
                String servletName = servletNameElement.getTextTrim();
                if (servletName == null) continue;
                result.addAll(WebXmlUtils.getUrlPatterns("servlet", webXml, servletName));
            }
        }
        return result;
    }
}

