/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.jivesoftware.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEngine {
    private static final Logger Log = LoggerFactory.getLogger(TaskEngine.class);
    private static TaskEngine instance = new TaskEngine();
    private Timer timer;
    private ExecutorService executor;
    private Map<TimerTask, TimerTaskWrapper> wrappedTasks = new ConcurrentHashMap<TimerTask, TimerTaskWrapper>();

    public static TaskEngine getInstance() {
        return instance;
    }

    private TaskEngine() {
        this.timer = new Timer("TaskEngine-timer", true);
        NamedThreadFactory threadFactory = new NamedThreadFactory("TaskEngine-pool-", true, 5, Thread.currentThread().getThreadGroup(), 0L);
        this.executor = Executors.newCachedThreadPool(threadFactory);
    }

    public Future<?> submit(Runnable task) {
        try {
            return this.executor.submit(task);
        }
        catch (Throwable t) {
            Log.warn("Failed to schedule task; will retry using caller's thread: {0}", (Object)t.getMessage());
            FutureTask<Object> result = new FutureTask<Object>(task, null);
            result.run();
            return result;
        }
    }

    public void schedule(TimerTask task, long delay) {
        this.timer.schedule((TimerTask)new TimerTaskWrapper(task), delay);
    }

    public void schedule(TimerTask task, Date time) {
        this.timer.schedule((TimerTask)new TimerTaskWrapper(task), time);
    }

    public void schedule(TimerTask task, long delay, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.schedule((TimerTask)taskWrapper, delay, period);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.schedule((TimerTask)taskWrapper, firstTime, period);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.scheduleAtFixedRate((TimerTask)taskWrapper, delay, period);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.scheduleAtFixedRate((TimerTask)taskWrapper, firstTime, period);
    }

    public void cancelScheduledTask(TimerTask task) {
        TimerTaskWrapper taskWrapper = this.wrappedTasks.remove(task);
        if (taskWrapper != null) {
            taskWrapper.cancel();
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class TimerTaskWrapper
    extends TimerTask {
        private TimerTask task;

        public TimerTaskWrapper(TimerTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                TaskEngine.this.submit(this.task);
            }
            catch (Throwable t) {
                Log.error("Failed to execute TimerTask", t);
            }
        }
    }
}

