/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base32;
import org.jivesoftware.util.Base64;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger Log = LoggerFactory.getLogger(StringUtils.class);
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    private static Base32 Base32Hex = new Base32(true);
    private static Map<String, MessageDigest> digests = new ConcurrentHashMap<String, MessageDigest>();
    private static Random randGen = new SecureRandom();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] zeroArray = "0000000000000000000000000000000000000000000000000000000000000000".toCharArray();

    private StringUtils() {
    }

    @Deprecated
    public static String replace(String string, String oldString, String newString) {
        return StringUtils.replace(string, oldString, newString, new int[1]);
    }

    public static String replaceIgnoreCase(String line, String oldString, String newString) {
        return StringUtils.replaceIgnoreCase(line, oldString, newString, new int[1]);
    }

    public static String replaceIgnoreCase(String line, String oldString, String newString, int[] count) {
        return StringUtils.replace(line, oldString, newString, true, count);
    }

    public static String replace(String line, String oldString, String newString, int[] count) {
        return StringUtils.replace(line, oldString, newString, false, count);
    }

    private static String replace(String line, String oldString, String newString, boolean ignoreCase, int[] count) {
        if (line == null) {
            return null;
        }
        String lcLine = ignoreCase ? line.toLowerCase() : line;
        String lcOldString = ignoreCase ? oldString.toLowerCase() : oldString;
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            int counter = 1;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuilder buf = new StringBuilder(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static String stripTags(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i + 3 < len && input[i + 1] == 'b' && input[i + 2] == 'r' && input[i + 3] == '>') {
                    i += 3;
                    continue;
                }
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                continue;
            }
            if (ch != '>') continue;
            last = i + 1;
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static String escapeHTMLTags(String in) {
        return StringUtils.escapeHTMLTags(in, true);
    }

    public static String escapeHTMLTags(String in, boolean includeLF) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '>') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(GT_ENCODE);
                continue;
            }
            if (ch != '\n' || !includeLF) continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append("<br>");
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static String hash(String data) {
        return StringUtils.hash(data, "MD5");
    }

    public static String hash(String data, String algorithm) {
        return StringUtils.hash(data.getBytes(StandardCharsets.UTF_8), algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(byte[] bytes, String algorithm) {
        String string = algorithm.intern();
        synchronized (string) {
            MessageDigest digest = digests.get(algorithm);
            if (digest == null) {
                try {
                    digest = MessageDigest.getInstance(algorithm);
                    digests.put(algorithm, digest);
                }
                catch (NoSuchAlgorithmException nsae) {
                    Log.error("Failed to load the " + algorithm + " MessageDigest. Jive will be unable to function normally.", (Throwable)nsae);
                    return null;
                }
            }
            digest.update(bytes);
            return StringUtils.encodeHex(digest.digest());
        }
    }

    public static String encodeHex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes).toLowerCase();
    }

    public static byte[] decodeHex(String hex) {
        return DatatypeConverter.parseHexBinary((String)hex);
    }

    public static String encodeBase64(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        return StringUtils.encodeBase64(bytes);
    }

    public static String encodeBase64(byte[] data) {
        return Base64.encodeBytes(data, 8);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decode(data);
    }

    public static String encodeBase32(String data) {
        byte[] bytes = data == null ? null : data.getBytes(StandardCharsets.UTF_8);
        return StringUtils.encodeBase32(bytes);
    }

    public static String encodeBase32(byte[] data) {
        return data == null ? null : Base32Hex.encodeAsString(data).toLowerCase();
    }

    public static byte[] decodeBase32(String data) {
        return data == null ? null : Base32Hex.decode(data.toUpperCase());
    }

    public static boolean isBase32(String data) {
        return data == null ? false : Base32Hex.isInAlphabet(data.toUpperCase());
    }

    public static String[] toLowerCaseWordArray(String text) {
        if (text == null || text.length() == 0) {
            return new String[0];
        }
        ArrayList<String> wordList = new ArrayList<String>();
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int start = 0;
        int end = boundary.next();
        while (end != -1) {
            String tmp = text.substring(start, end).trim();
            tmp = StringUtils.replace(tmp, "+", "");
            tmp = StringUtils.replace(tmp, "/", "");
            tmp = StringUtils.replace(tmp, "\\", "");
            tmp = StringUtils.replace(tmp, "#", "");
            tmp = StringUtils.replace(tmp, "*", "");
            tmp = StringUtils.replace(tmp, ")", "");
            tmp = StringUtils.replace(tmp, "(", "");
            if ((tmp = StringUtils.replace(tmp, "&", "")).length() > 0) {
                wordList.add(tmp);
            }
            start = end;
            end = boundary.next();
        }
        return wordList.toArray(new String[wordList.size()]);
    }

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(numbersAndLetters.length)];
        }
        return new String(randBuffer);
    }

    public static String chopAtWord(String string, int length) {
        int i;
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] charArray = string.toCharArray();
        int sLength = string.length();
        if (length < sLength) {
            sLength = length;
        }
        for (i = 0; i < sLength - 1; ++i) {
            if (charArray[i] == '\r' && charArray[i + 1] == '\n') {
                return string.substring(0, i + 1);
            }
            if (charArray[i] != '\n') continue;
            return string.substring(0, i);
        }
        if (charArray[sLength - 1] == '\n') {
            return string.substring(0, sLength - 1);
        }
        if (string.length() < length) {
            return string;
        }
        for (i = length - 1; i > 0; --i) {
            if (charArray[i] != ' ') continue;
            return string.substring(0, i).trim();
        }
        return string.substring(0, length);
    }

    public static String wordWrap(String input, int width, Locale locale) {
        if (input == null) {
            return "";
        }
        if (width < 5) {
            return input;
        }
        if (width >= input.length()) {
            return input;
        }
        if (locale == null) {
            locale = JiveGlobals.getLocale();
        }
        StringBuilder buf = new StringBuilder(input);
        boolean endOfLine = false;
        int lineStart = 0;
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) == '\n') {
                lineStart = i + 1;
                endOfLine = true;
            }
            if (i <= lineStart + width - 1) continue;
            if (!endOfLine) {
                int limit = i - lineStart - 1;
                BreakIterator breaks = BreakIterator.getLineInstance(locale);
                breaks.setText(buf.substring(lineStart, i));
                int end = breaks.last();
                if (end == limit + 1 && !Character.isWhitespace(buf.charAt(lineStart + end))) {
                    end = breaks.preceding(end - 1);
                }
                if (end != -1 && end == limit + 1) {
                    buf.replace(lineStart + end, lineStart + end + 1, "\n");
                    lineStart += end;
                    continue;
                }
                if (end != -1 && end != 0) {
                    buf.insert(lineStart + end, '\n');
                    lineStart = lineStart + end + 1;
                    continue;
                }
                buf.insert(i, '\n');
                lineStart = i + 1;
                continue;
            }
            buf.insert(i, '\n');
            lineStart = i + 1;
            endOfLine = false;
        }
        return buf.toString();
    }

    public static String escapeForSQL(String string) {
        int i;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        char[] input = string.toCharArray();
        int last = 0;
        int len = input.length;
        StringBuilder out = null;
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch != '\'') continue;
            if (out == null) {
                out = new StringBuilder(len + 2);
            }
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append('\'').append('\'');
        }
        if (out == null) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch != '\"') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(QUOTE_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static String unescapeFromXML(String string) {
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&quot;", "\"");
        return StringUtils.replace(string, "&amp;", "&");
    }

    public static String zeroPadString(String string, int length) {
        if (string == null || string.length() > length) {
            return string;
        }
        StringBuilder buf = new StringBuilder(length);
        buf.append(zeroArray, 0, length - string.length()).append(string);
        return buf.toString();
    }

    public static String dateToMillis(Date date) {
        return StringUtils.zeroPadString(Long.toString(date.getTime()), 15);
    }

    public static String getFullElapsedTime(long delta) {
        if (delta < 1000L) {
            return String.format("%d %s", delta, delta == 1L ? LocaleUtils.getLocalizedString("global.millisecond") : LocaleUtils.getLocalizedString("global.milliseconds"));
        }
        if (delta < 60000L) {
            long millis = delta % 1000L;
            long seconds = delta / 1000L;
            String secondsString = String.format("%d %s", seconds, seconds == 1L ? LocaleUtils.getLocalizedString("global.second") : LocaleUtils.getLocalizedString("global.seconds"));
            if (millis > 0L) {
                return secondsString + ", " + StringUtils.getFullElapsedTime(millis);
            }
            return secondsString;
        }
        if (delta < 3600000L) {
            long millis = delta % 60000L;
            long minutes = delta / 60000L;
            String minutesString = String.format("%d %s", minutes, minutes == 1L ? LocaleUtils.getLocalizedString("global.minute") : LocaleUtils.getLocalizedString("global.minutes"));
            if (millis > 0L) {
                return minutesString + ", " + StringUtils.getFullElapsedTime(millis);
            }
            return minutesString;
        }
        if (delta < 86400000L) {
            long millis = delta % 3600000L;
            long hours = delta / 3600000L;
            String daysString = String.format("%d %s", hours, hours == 1L ? LocaleUtils.getLocalizedString("global.hour") : LocaleUtils.getLocalizedString("global.hours"));
            if (millis > 0L) {
                return daysString + ", " + StringUtils.getFullElapsedTime(millis);
            }
            return daysString;
        }
        long millis = delta % 86400000L;
        long days = delta / 86400000L;
        String daysString = String.format("%d %s", days, days == 1L ? LocaleUtils.getLocalizedString("global.day") : LocaleUtils.getLocalizedString("global.days"));
        if (millis > 0L) {
            return daysString + ", " + StringUtils.getFullElapsedTime(millis);
        }
        return daysString;
    }

    public static String getElapsedTime(long delta) {
        if (delta < 60000L) {
            return LocaleUtils.getLocalizedString("global.less-minute");
        }
        if (delta < 3600000L) {
            long mins = delta / 60000L;
            StringBuilder sb = new StringBuilder();
            sb.append(mins).append(' ');
            sb.append(mins == 1L ? LocaleUtils.getLocalizedString("global.minute") : LocaleUtils.getLocalizedString("global.minutes"));
            return sb.toString();
        }
        if (delta < 86400000L) {
            long hours = delta / 3600000L;
            long mins = (delta -= hours * 3600000L) / 60000L;
            StringBuilder sb = new StringBuilder();
            sb.append(hours).append(' ');
            sb.append(hours == 1L ? LocaleUtils.getLocalizedString("global.hour") : LocaleUtils.getLocalizedString("global.hours"));
            sb.append(", ");
            sb.append(mins).append(' ');
            sb.append(mins == 1L ? LocaleUtils.getLocalizedString("global.minute") : LocaleUtils.getLocalizedString("global.minutes"));
            return sb.toString();
        }
        long days = delta / 86400000L;
        long hours = (delta -= days * 86400000L) / 3600000L;
        long mins = (delta -= hours * 3600000L) / 60000L;
        StringBuilder sb = new StringBuilder();
        sb.append(days).append(' ');
        sb.append(days == 1L ? LocaleUtils.getLocalizedString("global.day") : LocaleUtils.getLocalizedString("global.days"));
        sb.append(", ");
        sb.append(hours).append(' ');
        sb.append(hours == 1L ? LocaleUtils.getLocalizedString("global.hour") : LocaleUtils.getLocalizedString("global.hours"));
        sb.append(", ");
        sb.append(mins).append(' ');
        sb.append(mins == 1L ? LocaleUtils.getLocalizedString("global.minute") : LocaleUtils.getLocalizedString("global.minutes"));
        return sb.toString();
    }

    public static String getTimeFromLong(long diff) {
        String HOURS = "h";
        String MINUTES = "min";
        long MS_IN_A_DAY = 86400000L;
        long MS_IN_AN_HOUR = 3600000L;
        long MS_IN_A_MINUTE = 60000L;
        long MS_IN_A_SECOND = 1000L;
        long numHours = (diff %= 86400000L) / 3600000L;
        long numMinutes = (diff %= 3600000L) / 60000L;
        diff %= 60000L;
        diff %= 1000L;
        StringBuilder buf = new StringBuilder();
        if (numHours > 0L) {
            buf.append(numHours).append(' ').append("h").append(", ");
        }
        if (numMinutes > 0L) {
            buf.append(numMinutes).append(' ').append("min");
        }
        String result = buf.toString();
        if (numMinutes < 1L) {
            result = "< 1 minute";
        }
        return result;
    }

    public static String collectionToString(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String delim = "";
        for (String element : collection) {
            buf.append(delim);
            buf.append(element);
            delim = ",";
        }
        return buf.toString();
    }

    public static Collection<String> stringToCollection(String string) {
        if (string == null || string.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> collection = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(string, ",");
        while (tokens.hasMoreTokens()) {
            collection.add(tokens.nextToken().trim());
        }
        return collection;
    }

    public static boolean contains(String[] array, String item) {
        if (array == null || array.length == 0 || item == null) {
            return false;
        }
        for (String anArray : array) {
            if (!item.equals(anArray)) continue;
            return true;
        }
        return false;
    }

    public static String abbreviate(String str, int maxWidth) {
        if (null == str) {
            return null;
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        return str.substring(0, maxWidth) + "...";
    }

    public static boolean isValidEmailAddress(String address) {
        if (address == null) {
            return false;
        }
        if (!address.contains("@")) {
            return false;
        }
        try {
            InternetAddress.parse((String)address);
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    public static String validateDomainName(String domain) {
        if (domain == null || domain.trim().length() == 0) {
            throw new IllegalArgumentException("Domain name cannot be null or empty");
        }
        String result = IDN.toASCII(domain);
        if (result.equals(domain)) {
            IDN.toASCII(domain, 2);
        } else {
            Log.info(MessageFormat.format("Converted domain name: from '{0}' to '{1}'", domain, result));
        }
        return result;
    }

    public static String removeXSSCharacters(String input) {
        String[] xss = new String[]{"<", ">", "\"", "'", "%", ";", ")", "(", "&", "+", "-"};
        for (int i = 0; i < xss.length; ++i) {
            input = input.replace(xss[i], "");
        }
        return input;
    }

    @Deprecated
    public static byte[] getBytes(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String getString(byte[] input) {
        return new String(input, StandardCharsets.UTF_8);
    }
}

