/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEventDispatcher {
    private static final Logger Log = LoggerFactory.getLogger(PropertyEventDispatcher.class);
    private static Set<PropertyEventListener> listeners = new CopyOnWriteArraySet<PropertyEventListener>();

    private PropertyEventDispatcher() {
    }

    public static void addListener(PropertyEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(PropertyEventListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(String property, EventType eventType, Map<String, Object> params) {
        for (PropertyEventListener listener : listeners) {
            try {
                switch (eventType) {
                    case property_set: {
                        listener.propertySet(property, params);
                        break;
                    }
                    case property_deleted: {
                        listener.propertyDeleted(property, params);
                        break;
                    }
                    case xml_property_set: {
                        listener.xmlPropertySet(property, params);
                        break;
                    }
                    case xml_property_deleted: {
                        listener.xmlPropertyDeleted(property, params);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum EventType {
        property_set,
        property_deleted,
        xml_property_set,
        xml_property_deleted;

    }
}

