/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginClassLoader;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleUtils {
    private static final Logger Log = LoggerFactory.getLogger(LocaleUtils.class);
    private static final Map<Locale, String[][]> timeZoneLists = new ConcurrentHashMap<Locale, String[][]>();
    private static final String resourceBaseName = "openfire_i18n";
    private static String[] timeZoneIds = new String[]{"GMT", "Pacific/Apia", "HST", "AST", "America/Los_Angeles", "America/Phoenix", "America/Mazatlan", "America/Denver", "America/Belize", "America/Chicago", "America/Mexico_City", "America/Regina", "America/Bogota", "America/New_York", "America/Indianapolis", "America/Halifax", "America/Caracas", "America/Santiago", "America/St_Johns", "America/Sao_Paulo", "America/Buenos_Aires", "America/Godthab", "Atlantic/South_Georgia", "Atlantic/Azores", "Atlantic/Cape_Verde", "Africa/Casablanca", "Europe/Dublin", "Europe/Berlin", "Europe/Belgrade", "Europe/Paris", "Europe/Warsaw", "ECT", "Europe/Athens", "Europe/Bucharest", "Africa/Cairo", "Africa/Harare", "Europe/Helsinki", "Asia/Jerusalem", "Asia/Baghdad", "Asia/Kuwait", "Europe/Moscow", "Africa/Nairobi", "Asia/Tehran", "Asia/Muscat", "Asia/Baku", "Asia/Kabul", "Asia/Yekaterinburg", "Asia/Karachi", "Asia/Calcutta", "Asia/Katmandu", "Asia/Almaty", "Asia/Dhaka", "Asia/Colombo", "Asia/Rangoon", "Asia/Bangkok", "Asia/Krasnoyarsk", "Asia/Hong_Kong", "Asia/Irkutsk", "Asia/Kuala_Lumpur", "Australia/Perth", "Asia/Taipei", "Asia/Tokyo", "Asia/Seoul", "Asia/Yakutsk", "Australia/Adelaide", "Australia/Darwin", "Australia/Brisbane", "Australia/Sydney", "Pacific/Guam", "Australia/Hobart", "Asia/Vladivostok", "Pacific/Noumea", "Pacific/Auckland", "Pacific/Fiji", "Pacific/Tongatapu"};
    private static final Map<String, String> nameMap = new HashMap<String, String>();

    private LocaleUtils() {
    }

    public static Locale localeCodeToLocale(String localeCode) {
        Locale locale = null;
        if (localeCode != null) {
            String language = null;
            String country = null;
            String variant = null;
            StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
            if (tokenizer.hasMoreTokens()) {
                language = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    country = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        variant = tokenizer.nextToken();
                    }
                }
            }
            locale = new Locale(language, country != null ? country : "", variant != null ? variant : "");
        }
        return locale;
    }

    public static String[][] getTimeZoneList() {
        Locale jiveLocale = JiveGlobals.getLocale();
        String[][] timeZoneList = timeZoneLists.get(jiveLocale);
        if (timeZoneList == null) {
            String[] timeZoneIDs = timeZoneIds;
            timeZoneList = new String[timeZoneIDs.length][2];
            for (int i = 0; i < timeZoneList.length; ++i) {
                String zoneID;
                timeZoneList[i][0] = zoneID = timeZoneIDs[i];
                timeZoneList[i][1] = LocaleUtils.getTimeZoneName(zoneID, jiveLocale);
            }
            timeZoneLists.put(jiveLocale, timeZoneList);
        }
        return timeZoneList;
    }

    public static String getTimeZoneName(String zoneID, Locale locale) {
        TimeZone zone = TimeZone.getTimeZone(zoneID);
        StringBuilder buf = new StringBuilder();
        int offset = zone.getRawOffset();
        if (zone.inDaylightTime(new Date()) && zone.useDaylightTime()) {
            offset += 3600000;
        }
        buf.append('(');
        if (offset < 0) {
            buf.append("GMT-");
        } else {
            buf.append("GMT+");
        }
        offset = Math.abs(offset);
        int hours = offset / 3600000;
        int minutes = offset % 3600000 / 60000;
        buf.append(hours).append(':');
        if (minutes < 10) {
            buf.append('0').append(minutes);
        } else {
            buf.append(minutes);
        }
        buf.append(") ");
        if ("en".equals(locale.getLanguage())) {
            String name = nameMap.get(zoneID);
            if (name == null) {
                name = zoneID;
            }
            buf.append(name);
        } else {
            buf.append(zone.getDisplayName(true, 1, locale).replace('_', ' ').replace('/', ' '));
        }
        return buf.toString();
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale);
    }

    public static String getLocalizedString(String key) {
        Locale locale = JiveGlobals.getLocale();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(resourceBaseName, locale);
            return LocaleUtils.getLocalizedString(key, locale, null, bundle);
        }
        catch (MissingResourceException mre) {
            Log.error(mre.getMessage());
            return key;
        }
    }

    public static String getLocalizedString(String key, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(resourceBaseName, locale);
        return LocaleUtils.getLocalizedString(key, locale, null, bundle);
    }

    public static String getLocalizedString(String key, List<?> arguments) {
        Locale locale = JiveGlobals.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(resourceBaseName, locale);
        return LocaleUtils.getLocalizedString(key, locale, arguments, bundle);
    }

    public static String getLocalizedString(String key, String pluginName) {
        return LocaleUtils.getLocalizedString(key, pluginName, null);
    }

    public static String getLocalizedString(String key, String pluginName, List arguments) {
        return LocaleUtils.getLocalizedString(key, pluginName, arguments, null, false);
    }

    public static String getLocalizedString(String key, String pluginName, List<?> arguments, Locale locale, boolean fallback) {
        if (pluginName == null) {
            return LocaleUtils.getLocalizedString(key, arguments);
        }
        if (locale == null) {
            locale = JiveGlobals.getLocale();
        }
        String i18nFile = LocaleUtils.getI18nFile(pluginName);
        XMPPServer xmppServer = XMPPServer.getInstance();
        PluginManager pluginManager = xmppServer.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pluginName);
        if (plugin == null) {
            throw new NullPointerException("Plugin could not be located: " + pluginName);
        }
        PluginClassLoader pluginClassLoader = pluginManager.getPluginClassloader(plugin);
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(i18nFile, locale, pluginClassLoader);
            return LocaleUtils.getLocalizedString(key, locale, arguments, bundle);
        }
        catch (MissingResourceException mre) {
            Locale jivesLocale = JiveGlobals.getLocale();
            if (fallback && !jivesLocale.equals(locale)) {
                Log.info("Could not find the requested locale. Falling back to default locale.", (Throwable)mre);
                return LocaleUtils.getLocalizedString(key, pluginName, arguments, jivesLocale, false);
            }
            Log.error(mre.getMessage(), (Throwable)mre);
            return key;
        }
    }

    public static ResourceBundle getPluginResourceBundle(String pluginName) throws Exception {
        Locale locale = JiveGlobals.getLocale();
        String i18nFile = LocaleUtils.getI18nFile(pluginName);
        XMPPServer xmppServer = XMPPServer.getInstance();
        PluginManager pluginManager = xmppServer.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pluginName);
        if (plugin == null) {
            throw new NullPointerException("Plugin could not be located.");
        }
        PluginClassLoader pluginClassLoader = pluginManager.getPluginClassloader(plugin);
        return ResourceBundle.getBundle(i18nFile, locale, pluginClassLoader);
    }

    private static String getI18nFile(String pluginName) {
        return pluginName.replace('.', '_') + "_i18n";
    }

    public static String getLocalizedString(String key, Locale locale, List arguments, ResourceBundle bundle) {
        String value;
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (locale == null) {
            locale = JiveGlobals.getLocale();
        }
        try {
            value = bundle.getString(key);
            if (arguments != null) {
                MessageFormat messageFormat = new MessageFormat("");
                messageFormat.setLocale(bundle.getLocale());
                messageFormat.applyPattern(value);
                try {
                    Format[] formats = messageFormat.getFormats();
                    for (int i = 0; i < formats.length; ++i) {
                        Object val;
                        Format format = formats[i];
                        if (format == null) continue;
                        if (format instanceof DateFormat) {
                            if (arguments.size() <= i || !((val = arguments.get(i)) instanceof String)) continue;
                            DateFormat dateFmt = (DateFormat)format;
                            try {
                                val = dateFmt.parse((String)val);
                                arguments.set(i, val);
                            }
                            catch (ParseException e) {
                                Log.error(e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        if (!(format instanceof NumberFormat) || arguments.size() <= i || !((val = arguments.get(i)) instanceof String)) continue;
                        NumberFormat nbrFmt = (NumberFormat)format;
                        try {
                            val = nbrFmt.parse((String)val);
                            arguments.set(i, val);
                            continue;
                        }
                        catch (ParseException e) {
                            Log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    value = messageFormat.format(arguments.toArray());
                }
                catch (IllegalArgumentException e) {
                    Log.error("Unable to format resource string for key: " + key + ", argument type not supported");
                    value = "";
                }
            }
        }
        catch (MissingResourceException mre) {
            Log.warn("Missing resource for key: " + key + " in locale " + locale.toString());
            value = "";
        }
        return value;
    }

    public static String getLocalizedNumber(long number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String getLocalizedNumber(long number, Locale locale) {
        return NumberFormat.getInstance(locale).format(number);
    }

    public static String getLocalizedNumber(double number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String getLocalizedNumber(double number, Locale locale) {
        return NumberFormat.getInstance(locale).format(number);
    }

    static {
        nameMap.put(timeZoneIds[0], "International Date Line West");
        nameMap.put(timeZoneIds[1], "Midway Island, Samoa");
        nameMap.put(timeZoneIds[2], "Hawaii");
        nameMap.put(timeZoneIds[3], "Alaska");
        nameMap.put(timeZoneIds[4], "Pacific Time (US & Canada); Tijuana");
        nameMap.put(timeZoneIds[5], "Arizona");
        nameMap.put(timeZoneIds[6], "Chihuahua, La Pax, Mazatlan");
        nameMap.put(timeZoneIds[7], "Mountain Time (US & Canada)");
        nameMap.put(timeZoneIds[8], "Central America");
        nameMap.put(timeZoneIds[9], "Central Time (US & Canada)");
        nameMap.put(timeZoneIds[10], "Guadalajara, Mexico City, Monterrey");
        nameMap.put(timeZoneIds[11], "Saskatchewan");
        nameMap.put(timeZoneIds[12], "Bogota, Lima, Quito");
        nameMap.put(timeZoneIds[13], "Eastern Time (US & Canada)");
        nameMap.put(timeZoneIds[14], "Indiana (East)");
        nameMap.put(timeZoneIds[15], "Atlantic Time (Canada)");
        nameMap.put(timeZoneIds[16], "Caracas, La Paz");
        nameMap.put(timeZoneIds[17], "Santiago");
        nameMap.put(timeZoneIds[18], "Newfoundland");
        nameMap.put(timeZoneIds[19], "Brasilia");
        nameMap.put(timeZoneIds[20], "Buenos Aires, Georgetown");
        nameMap.put(timeZoneIds[21], "Greenland");
        nameMap.put(timeZoneIds[22], "Mid-Atlantic");
        nameMap.put(timeZoneIds[23], "Azores");
        nameMap.put(timeZoneIds[24], "Cape Verde Is.");
        nameMap.put(timeZoneIds[25], "Casablanca, Monrovia");
        nameMap.put(timeZoneIds[26], "Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London");
        nameMap.put(timeZoneIds[27], "Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna");
        nameMap.put(timeZoneIds[28], "Belgrade, Bratislava, Budapest, Ljubljana, Prague");
        nameMap.put(timeZoneIds[29], "Brussels, Copenhagen, Madrid, Paris");
        nameMap.put(timeZoneIds[30], "Sarajevo, Skopje, Warsaw, Zagreb");
        nameMap.put(timeZoneIds[31], "West Central Africa");
        nameMap.put(timeZoneIds[32], "Athens, Istanbul, Minsk");
        nameMap.put(timeZoneIds[33], "Bucharest");
        nameMap.put(timeZoneIds[34], "Cairo");
        nameMap.put(timeZoneIds[35], "Harare, Pretoria");
        nameMap.put(timeZoneIds[36], "Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius");
        nameMap.put(timeZoneIds[37], "Jerusalem");
        nameMap.put(timeZoneIds[38], "Baghdad");
        nameMap.put(timeZoneIds[39], "Kuwait, Riyadh");
        nameMap.put(timeZoneIds[40], "Moscow, St. Petersburg, Volgograd");
        nameMap.put(timeZoneIds[41], "Nairobi");
        nameMap.put(timeZoneIds[42], "Tehran");
        nameMap.put(timeZoneIds[43], "Abu Dhabi, Muscat");
        nameMap.put(timeZoneIds[44], "Baku, Tbilisi, Muscat");
        nameMap.put(timeZoneIds[45], "Kabul");
        nameMap.put(timeZoneIds[46], "Ekaterinburg");
        nameMap.put(timeZoneIds[47], "Islamabad, Karachi, Tashkent");
        nameMap.put(timeZoneIds[48], "Chennai, Kolkata, Mumbai, New Dehli");
        nameMap.put(timeZoneIds[49], "Kathmandu");
        nameMap.put(timeZoneIds[50], "Almaty, Novosibirsk");
        nameMap.put(timeZoneIds[51], "Astana, Dhaka");
        nameMap.put(timeZoneIds[52], "Sri Jayawardenepura");
        nameMap.put(timeZoneIds[53], "Rangoon");
        nameMap.put(timeZoneIds[54], "Bangkok, Hanoi, Jakarta");
        nameMap.put(timeZoneIds[55], "Krasnoyarsk");
        nameMap.put(timeZoneIds[56], "Beijing, Chongqing, Hong Kong, Urumqi");
        nameMap.put(timeZoneIds[57], "Irkutsk, Ulaan Bataar");
        nameMap.put(timeZoneIds[58], "Kuala Lumpur, Singapore");
        nameMap.put(timeZoneIds[59], "Perth");
        nameMap.put(timeZoneIds[60], "Taipei");
        nameMap.put(timeZoneIds[61], "Osaka, Sapporo, Tokyo");
        nameMap.put(timeZoneIds[62], "Seoul");
        nameMap.put(timeZoneIds[63], "Yakutsk");
        nameMap.put(timeZoneIds[64], "Adelaide");
        nameMap.put(timeZoneIds[65], "Darwin");
        nameMap.put(timeZoneIds[66], "Brisbane");
        nameMap.put(timeZoneIds[67], "Canberra, Melbourne, Sydney");
        nameMap.put(timeZoneIds[68], "Guam, Port Moresby");
        nameMap.put(timeZoneIds[69], "Hobart");
        nameMap.put(timeZoneIds[70], "Vladivostok");
        nameMap.put(timeZoneIds[71], "Magadan, Solomon Is., New Caledonia");
        nameMap.put(timeZoneIds[72], "Auckland, Wellington");
        nameMap.put(timeZoneIds[73], "Fiji, Kamchatka, Marshall Is.");
        nameMap.put(timeZoneIds[74], "Nuku'alofa");
    }
}

