/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

public class HTTPConnectionException
extends Exception {
    private int errorCode;

    public HTTPConnectionException(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        if (this.errorCode == 400) {
            return "400 Bad Request";
        }
        if (this.errorCode == 401) {
            return "401 Unauthorized";
        }
        if (this.errorCode == 402) {
            return "402 Payment Required";
        }
        if (this.errorCode == 403) {
            return "403 Forbidden";
        }
        if (this.errorCode == 404) {
            return "404 Not Found";
        }
        if (this.errorCode == 405) {
            return "405 Method Not Allowed";
        }
        if (this.errorCode == 406) {
            return "406 Not Acceptable";
        }
        if (this.errorCode == 407) {
            return "407 Proxy Authentication Required";
        }
        if (this.errorCode == 408) {
            return "408 Request Timeout";
        }
        if (this.errorCode == 409) {
            return "409 Conflict";
        }
        if (this.errorCode == 410) {
            return "410 Gone";
        }
        if (this.errorCode == 411) {
            return "411 Length Required";
        }
        if (this.errorCode == 412) {
            return "412 Precondition Failed";
        }
        if (this.errorCode == 413) {
            return "413 Request Entity Too Large";
        }
        if (this.errorCode == 414) {
            return "414 Request-URI Too Long";
        }
        if (this.errorCode == 415) {
            return "415 Unsupported Media Type";
        }
        if (this.errorCode == 416) {
            return "416 Requested Range Not Satisfiable";
        }
        if (this.errorCode == 418) {
            return "417 Expectation Failed";
        }
        return "Unknown HTTP error code: " + this.errorCode;
    }
}

