/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.Node;

public class ElementUtil {
    private ElementUtil() {
    }

    public static String getProperty(Element element, String name) {
        int i;
        String value = null;
        String[] propName = ElementUtil.parsePropertyName(name);
        String lastName = propName[propName.length - 1];
        String attName = null;
        int attributeIndex = lastName.indexOf(58);
        if (attributeIndex >= 0) {
            propName[propName.length - 1] = lastName.substring(0, attributeIndex);
            attName = lastName.substring(attributeIndex + 1);
        }
        int n = i = propName[0].equals(element.getName()) ? 1 : 0;
        while (i < propName.length && (element = element.element(propName[i])) != null) {
            ++i;
        }
        if (element != null) {
            value = attName == null ? element.getTextTrim() : element.attributeValue(attName);
        }
        return value;
    }

    public static boolean includesProperty(Element element, String name) {
        int i;
        String[] propName = ElementUtil.parsePropertyName(name);
        String lastName = propName[propName.length - 1];
        String attName = null;
        int attributeIndex = lastName.indexOf(58);
        if (attributeIndex >= 0) {
            propName[propName.length - 1] = lastName.substring(0, attributeIndex);
            attName = lastName.substring(attributeIndex + 1);
        }
        int n = i = propName[0].equals(element.getName()) ? 1 : 0;
        while (i < propName.length && (element = element.element(propName[i])) != null) {
            ++i;
        }
        if (element != null) {
            if (attName == null) {
                return true;
            }
            return element.attribute(attName) != null;
        }
        return false;
    }

    public String[] getProperties(Element element, String name) {
        int i;
        String[] propName = ElementUtil.parsePropertyName(name);
        int n = i = propName[0].equals(element.getName()) ? 1 : 0;
        while (i < propName.length - 1) {
            if ((element = element.element(propName[i])) == null) {
                return new String[0];
            }
            ++i;
        }
        Iterator iter = element.elementIterator(propName[propName.length - 1]);
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            props.add(e.getName());
        }
        String[] childrenNames = new String[props.size()];
        return props.toArray(childrenNames);
    }

    public static void setProperties(Element element, String name, String[] values) {
        int i;
        String[] propName = ElementUtil.parsePropertyName(name);
        ElementUtil.setProperty(element, name, values[0]);
        int n = i = propName[0].equals(element.getName()) ? 1 : 0;
        while (i < propName.length - 1) {
            if ((element = element.element(propName[i])) == null) {
                return;
            }
            ++i;
        }
        String childName = propName[propName.length - 1];
        Iterator iter = element.elementIterator(childName);
        while (iter.hasNext()) {
            ((Node)iter.next()).detach();
        }
        int j = 0;
        while (i < values.length) {
            if (values[j] != null) {
                element.addElement(childName).setText(values[j]);
            }
            ++i;
        }
    }

    public static String[] getChildrenProperties(Element element, String parent) {
        int i;
        String[] propName = ElementUtil.parsePropertyName(parent);
        int n = i = propName[0].equals(element.getName()) ? 1 : 0;
        while (i < propName.length) {
            if ((element = element.element(propName[i])) == null) {
                return new String[0];
            }
            ++i;
        }
        List children = element.elements();
        int childCount = children.size();
        String[] childrenNames = new String[childCount];
        int j = 0;
        while (i < childCount) {
            childrenNames[j] = ((Element)children.get(j)).getName();
            ++i;
        }
        return childrenNames;
    }

    public static String[] getRecursiveChildrenProperties(Element element, String parent) {
        String[] properties = ElementUtil.getChildrenProperties(element, parent);
        if (properties.length == 0) {
            return properties;
        }
        ArrayList<String> list = new ArrayList<String>(15);
        for (int i = 0; i < properties.length; ++i) {
            String propName = parent + "." + properties[i];
            list.add(propName);
            list.addAll(Arrays.asList(ElementUtil.getRecursiveChildrenProperties(element, propName)));
        }
        return list.toArray(new String[0]);
    }

    public static void setProperty(Element element, String name, String value) {
        String[] propName;
        int i;
        if (name == null || name.length() == 0) {
            return;
        }
        if (value == null) {
            value = "";
        }
        int n = i = (propName = ElementUtil.parsePropertyName(name))[0].equals(element.getName()) ? 1 : 0;
        while (i < propName.length - 1) {
            if (element.element(propName[i]) == null) {
                element.addElement(propName[i]);
            }
            element = element.element(propName[i]);
            ++i;
        }
        String lastName = propName[propName.length - 1];
        int attributeIndex = lastName.indexOf(58);
        if (attributeIndex >= 0) {
            String eleName = lastName.substring(0, attributeIndex);
            String attName = lastName.substring(attributeIndex + 1);
            if (element.element(eleName) == null) {
                element.addElement(eleName);
            }
            element.element(eleName).addAttribute(attName, value);
        } else {
            if (element.element(lastName) == null) {
                element.addElement(lastName);
            }
            element.element(lastName).setText(value);
        }
    }

    public static void deleteProperty(Element element, String name) {
        String[] propName = ElementUtil.parsePropertyName(name);
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return;
        }
        element.remove(element.element(propName[propName.length - 1]));
    }

    private static String[] parsePropertyName(String name) {
        ArrayList<String> propName = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            propName.add(tokenizer.nextToken());
        }
        return propName.toArray(new String[propName.size()]);
    }
}

