/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.InputStream;

public class ClassUtils {
    private static ClassUtils instance = new ClassUtils();

    public static Class forName(String className) throws ClassNotFoundException {
        return instance.loadClass(className);
    }

    public static InputStream getResourceAsStream(String name) {
        return instance.loadResource(name);
    }

    private ClassUtils() {
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class<?> theClass = null;
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                theClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                theClass = this.getClass().getClassLoader().loadClass(className);
            }
        }
        return theClass;
    }

    private InputStream loadResource(String name) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(name);
        }
        return in;
    }
}

