/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.websocket;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.TimerTask;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.XMPPPacketReader;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.SessionPacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.multiplex.UnknownStanzaException;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.websocket.StreamManagementPacketRouter;
import org.jivesoftware.openfire.websocket.WebSocketConnection;
import org.jivesoftware.openfire.websocket.XMPPPPacketReaderFactory;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.StreamError;

@WebSocket
public class XmppWebSocket {
    private static final String STREAM_HEADER = "open";
    private static final String STREAM_FOOTER = "close";
    private static final String FRAMING_NAMESPACE = "urn:ietf:params:xml:ns:xmpp-framing";
    private static Logger Log = LoggerFactory.getLogger(XmppWebSocket.class);
    private static GenericObjectPool<XMPPPacketReader> readerPool;
    private SessionPacketRouter router;
    private Session wsSession;
    private WebSocketConnection wsConnection;
    private LocalClientSession xmppSession;
    private boolean startedSASL = false;
    private SASLAuthentication.Status saslStatus;
    private TimerTask pingTask;

    public XmppWebSocket() {
        if (readerPool == null) {
            this.initializePool();
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.wsSession = session;
        this.wsConnection = new WebSocketConnection(this, session.getRemoteAddress());
        this.pingTask = new PingTask();
        TaskEngine.getInstance().schedule(this.pingTask, 60000L, 60000L);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.closeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onTextMethod(String stanza) {
        XMPPPacketReader reader = null;
        try {
            reader = (XMPPPacketReader)readerPool.borrowObject();
            Document doc = reader.read(new StringReader(stanza));
            if (this.xmppSession == null) {
                this.initiateSession(doc.getRootElement());
            } else {
                this.processStanza(doc.getRootElement());
            }
        }
        catch (Exception ex) {
            Log.error("Failed to process XMPP stanza", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                readerPool.returnObject((Object)reader);
            }
        }
    }

    @OnWebSocketError
    public void onError(Throwable error) {
        Log.error("Error detected; session: " + this.wsSession, error);
        this.closeStream(new StreamError(StreamError.Condition.internal_server_error));
        try {
            if (this.wsSession != null) {
                this.wsSession.disconnect();
            }
        }
        catch (Exception e) {
            Log.error("Error disconnecting websocket", (Throwable)e);
        }
    }

    boolean isWebSocketOpen() {
        return this.wsSession != null && this.wsSession.isOpen();
    }

    boolean isWebSocketSecure() {
        return this.wsSession != null && this.wsSession.isSecure();
    }

    void closeWebSocket() {
        if (this.isWebSocketOpen()) {
            this.wsSession.close();
        }
        this.wsSession = null;
    }

    void closeSession() {
        if (this.isWebSocketOpen()) {
            this.closeStream(null);
        }
        if (this.xmppSession != null) {
            if (!this.xmppSession.getStreamManager().getResume()) {
                this.xmppSession.close();
                SessionManager.getInstance().removeSession(this.xmppSession);
            }
            this.xmppSession = null;
        }
    }

    public void setXmppSession(LocalClientSession session) {
        this.xmppSession = session;
    }

    void deliver(String packet) {
        if (this.isWebSocketOpen()) {
            try {
                this.xmppSession.incrementServerPacketCount();
                this.wsSession.getRemote().sendStringByFuture(packet);
            }
            catch (Exception e) {
                Log.error("Packet delivery failed; session: " + this.wsSession, (Throwable)e);
                Log.warn("Failed to deliver packet:\n" + packet);
            }
        } else {
            Log.warn("Failed to deliver packet; socket is closed:\n" + packet);
        }
    }

    static boolean isCompressionEnabled() {
        return JiveGlobals.getProperty("xmpp.client.compression.policy", Connection.CompressionPolicy.optional.toString()).equalsIgnoreCase(Connection.CompressionPolicy.optional.toString());
    }

    private void processStanza(Element stanza) {
        try {
            String tag = stanza.getName();
            if (STREAM_FOOTER.equals(tag)) {
                this.xmppSession.getStreamManager().formalClose();
                this.closeStream(null);
            } else if ("auth".equals(tag)) {
                this.startedSASL = true;
                this.xmppSession.incrementClientPacketCount();
                this.saslStatus = SASLAuthentication.handle(this.xmppSession, stanza);
            } else if (this.startedSASL && "response".equals(tag) || "abort".equals(tag)) {
                this.xmppSession.incrementClientPacketCount();
                this.saslStatus = SASLAuthentication.handle(this.xmppSession, stanza);
            } else if (STREAM_HEADER.equals(tag)) {
                this.openStream(stanza.attributeValue(QName.get((String)"lang", (String)"http://www.w3.org/XML/1998/namespace"), "en"), stanza.attributeValue("from"));
                this.configureStream();
            } else if (SASLAuthentication.Status.authenticated.equals((Object)this.saslStatus)) {
                if (this.router == null) {
                    this.router = this.isStreamManagementAvailable() ? new StreamManagementPacketRouter(this.xmppSession) : new SessionPacketRouter(this.xmppSession);
                }
                this.router.route(stanza);
            } else {
                Log.warn("Not authorized: " + stanza.asXML());
                this.sendPacketError(stanza, PacketError.Condition.not_authorized);
            }
        }
        catch (UnknownStanzaException use) {
            Log.warn("Received invalid stanza: " + stanza.asXML());
            this.sendPacketError(stanza, PacketError.Condition.bad_request);
        }
        catch (Exception ex) {
            Log.error("Failed to process incoming stanza: " + stanza.asXML(), (Throwable)ex);
            this.closeStream(new StreamError(StreamError.Condition.internal_server_error));
        }
    }

    private void initiateSession(Element stanza) {
        String host = stanza.attributeValue("to");
        StreamError streamError = null;
        Locale language = Locale.forLanguageTag(stanza.attributeValue(QName.get((String)"lang", (String)"http://www.w3.org/XML/1998/namespace"), "en"));
        if (STREAM_FOOTER.equals(stanza.getName())) {
            Log.warn("Client closed stream before session was established");
        } else if (!STREAM_HEADER.equals(stanza.getName())) {
            streamError = new StreamError(StreamError.Condition.unsupported_stanza_type);
            Log.warn("Closing session due to incorrect stream header. Tag: " + stanza.getName());
        } else if (!FRAMING_NAMESPACE.equals(stanza.getNamespace().getURI())) {
            streamError = new StreamError(StreamError.Condition.invalid_namespace);
            Log.warn("Closing session due to invalid namespace in stream header. Namespace: " + stanza.getNamespace().getURI());
        } else if (!this.validateHost(host)) {
            streamError = new StreamError(StreamError.Condition.host_unknown);
            Log.warn("Closing session due to incorrect hostname in stream header. Host: " + host);
        } else {
            this.xmppSession = SessionManager.getInstance().createClientSession((Connection)this.wsConnection, language);
            this.xmppSession.setSessionData("ws", Boolean.TRUE);
        }
        if (this.xmppSession == null) {
            this.closeStream(streamError);
        } else {
            this.openStream(language.toLanguageTag(), stanza.attributeValue("from"));
            this.configureStream();
        }
    }

    private boolean validateHost(String host) {
        boolean result = true;
        if (JiveGlobals.getBooleanProperty("xmpp.client.validate.host", false)) {
            result = XMPPServer.getInstance().getServerInfo().getXMPPDomain().equals(host);
        }
        return result;
    }

    private void configureStream() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("<stream:features xmlns:stream='http://etherx.jabber.org/streams'>");
        if (this.saslStatus == null) {
            sb.append(SASLAuthentication.getSASLMechanisms(this.xmppSession));
            if (XMPPServer.getInstance().getIQRouter().supports("jabber:iq:auth")) {
                sb.append("<auth xmlns='http://jabber.org/features/iq-auth'/>");
            }
        } else if (this.saslStatus.equals((Object)SASLAuthentication.Status.authenticated)) {
            sb.append(String.format("<bind xmlns='%s'/>", "urn:ietf:params:xml:ns:xmpp-bind"));
            sb.append(String.format("<session xmlns='%s'><optional/></session>", "urn:ietf:params:xml:ns:xmpp-session"));
            if (this.isStreamManagementAvailable()) {
                sb.append(String.format("<sm xmlns='%s'/>", "urn:xmpp:sm:3"));
            }
        }
        sb.append("</stream:features>");
        this.deliver(sb.toString());
    }

    private void openStream(String lang, String jid) {
        this.xmppSession.incrementClientPacketCount();
        StringBuilder sb = new StringBuilder(250);
        sb.append("<open ");
        if (jid != null) {
            sb.append("to='").append(jid).append("' ");
        }
        sb.append("from='").append(XMPPServer.getInstance().getServerInfo().getXMPPDomain()).append("' ");
        sb.append("id='").append(this.xmppSession.getStreamID().toString()).append("' ");
        sb.append("xmlns='").append(FRAMING_NAMESPACE).append("' ");
        sb.append("xml:lang='").append(lang).append("' ");
        sb.append("version='1.0'/>");
        this.deliver(sb.toString());
    }

    private void closeStream(StreamError streamError) {
        if (this.isWebSocketOpen()) {
            if (streamError != null) {
                this.deliver(streamError.toXML());
            }
            StringBuilder sb = new StringBuilder(250);
            sb.append("<close ");
            sb.append("xmlns='").append(FRAMING_NAMESPACE).append("'");
            sb.append("/>");
            this.deliver(sb.toString());
            this.closeWebSocket();
        }
    }

    private void sendPacketError(Element stanza, PacketError.Condition condition) {
        Element reply = stanza.createCopy();
        reply.addAttribute("type", "error");
        reply.addAttribute("to", stanza.attributeValue("from"));
        reply.addAttribute("from", stanza.attributeValue("to"));
        reply.add(new PacketError(condition).getElement());
        this.deliver(reply.asXML());
    }

    private synchronized void initializePool() {
        if (readerPool == null) {
            readerPool = new GenericObjectPool((PooledObjectFactory)new XMPPPPacketReaderFactory());
            readerPool.setMaxTotal(-1);
            readerPool.setBlockWhenExhausted(false);
            readerPool.setTestOnReturn(true);
            readerPool.setTimeBetweenEvictionRunsMillis(60000L);
        }
    }

    private boolean isStreamManagementAvailable() {
        return JiveGlobals.getBooleanProperty("stream.management.active", true);
    }

    private final class PingTask
    extends TimerTask {
        private boolean lastPingFailed = false;

        private PingTask() {
        }

        @Override
        public void run() {
            if (!XmppWebSocket.this.isWebSocketOpen()) {
                TaskEngine.getInstance().cancelScheduledTask(XmppWebSocket.this.pingTask);
            } else {
                long idleTime = System.currentTimeMillis() - 60000L;
                if (XmppWebSocket.this.xmppSession.getLastActiveDate().getTime() >= idleTime) {
                    return;
                }
                try {
                    XmppWebSocket.this.wsSession.getRemote().sendPing(null);
                    this.lastPingFailed = false;
                }
                catch (IOException ioe) {
                    Log.error("Failed to ping remote peer: " + XmppWebSocket.this.wsSession, (Throwable)ioe);
                    if (this.lastPingFailed) {
                        XmppWebSocket.this.closeSession();
                        TaskEngine.getInstance().cancelScheduledTask(XmppWebSocket.this.pingTask);
                    }
                    this.lastPingFailed = true;
                }
            }
        }
    }
}

