/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.webdav;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.util.Base64;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class WebDAVLiteServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(WebDAVLiteServlet.class);
    private static String WEBDAV_SUBDIR = "mucFiles";

    private File getFileReference(String service, String room, String file) {
        return new File(JiveGlobals.getHomeDirectory(), WEBDAV_SUBDIR + File.separator + service + File.separator + room + (file != null ? File.separator + file : ""));
    }

    private Boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String auth = request.getHeader("Authorization");
        try {
            int i;
            if (auth == null || !request.getAuthType().equals("BASIC")) {
                throw new Exception("No authorization or improper authorization provided.");
            }
            String decoded = new String(Base64.decode(auth = auth.substring(auth.indexOf(" "))));
            String username = decoded.substring(0, i = decoded.indexOf(":"));
            if (!username.contains("@")) {
                throw new Exception("Not a valid JID.");
            }
            JID jid = new JID(username);
            if (XMPPServer.getInstance().isLocal(jid)) {
                String password = decoded.substring(i + 1, decoded.length());
                if (AuthFactory.authenticate(username, password) == null) {
                    throw new Exception("Authentication failed.");
                }
            } else {
                throw new Exception("Not a local account.");
            }
            return true;
        }
        catch (Exception e) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"Openfire WebDAV\"");
            response.sendError(401);
            return false;
        }
    }

    private Boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, String service, String room) throws ServletException, IOException {
        String auth = request.getHeader("Authorization");
        try {
            int i;
            if (auth == null || !request.getAuthType().equals("BASIC")) {
                throw new Exception("No authorization or improper authorization provided.");
            }
            String decoded = new String(Base64.decode(auth = auth.substring(auth.indexOf(" "))));
            String username = decoded.substring(0, i = decoded.indexOf(":"));
            if (!username.contains("@")) {
                throw new Exception("Not a valid JID.");
            }
            JID bareJID = new JID(username).asBareJID();
            XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(service).getChatRoom(room).getOccupantsByBareJID(bareJID);
            return true;
        }
        catch (Exception e) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"Openfire WebDAV\"");
            response.sendError(403);
            return false;
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        File webdavDir = new File(JiveGlobals.getHomeDirectory(), WEBDAV_SUBDIR);
        if (!webdavDir.exists()) {
            webdavDir.mkdirs();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthenticated(request, response).booleanValue()) {
            return;
        }
        String path = request.getPathInfo();
        Log.debug("WebDAVLiteServlet: GET with path = " + path);
        if (path == null || !path.startsWith("/rooms/")) {
            response.sendError(404);
            return;
        }
        String[] pathPcs = path.split("/");
        if (pathPcs.length < 4 || pathPcs.length > 5) {
            response.sendError(404);
            return;
        }
        String service = pathPcs[2];
        String room = pathPcs[3];
        if (!this.isAuthorized(request, response, service, room).booleanValue()) {
            return;
        }
        if (pathPcs.length == 5) {
            String filename = pathPcs[4];
            File file = this.getFileReference(service, room, filename);
            Log.debug("WebDAVListServlet: File path = " + file.getAbsolutePath());
            Log.debug("WebDAVListServlet: Service = " + service + ", room = " + room + ", file = " + filename);
            if (file.exists()) {
                response.setStatus(200);
                response.setContentType("application/octet-stream");
                response.setContentLength((int)file.length());
                FileInputStream fileStream = new FileInputStream(file);
                byte[] byteArray = new byte[(int)file.length()];
                new DataInputStream(fileStream).readFully(byteArray);
                fileStream.close();
                response.getOutputStream().write(byteArray);
            } else {
                response.sendError(404);
            }
        } else {
            response.setStatus(200);
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            String content = "Files available for " + room + "@" + service + ":\n";
            File fileDir = this.getFileReference(service, room, null);
            Log.debug("WebDAVListServlet: File path = " + fileDir.getAbsolutePath());
            if (fileDir.exists()) {
                File[] files;
                for (File file : files = fileDir.listFiles()) {
                    content = content + file.getName() + "\n";
                }
            }
            response.getOutputStream().write(content.getBytes());
            Log.debug("WebDAVListServlet: Service = " + service + ", room = " + room);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthenticated(request, response).booleanValue()) {
            return;
        }
        String path = request.getPathInfo();
        Log.debug("WebDAVLiteServlet: PUT with path = " + path);
        if (request.getContentLength() <= 0) {
            response.sendError(400);
            return;
        }
        if (path == null || !path.startsWith("/rooms/")) {
            response.sendError(400);
            return;
        }
        String[] pathPcs = path.split("/");
        if (pathPcs.length != 5) {
            response.sendError(400);
            return;
        }
        String service = pathPcs[2];
        String room = pathPcs[3];
        String filename = pathPcs[4];
        if (!this.isAuthorized(request, response, service, room).booleanValue()) {
            return;
        }
        Log.debug("WebDAVListServlet: Service = " + service + ", room = " + room + ", file = " + filename);
        File file = this.getFileReference(service, room, filename);
        Boolean overwriteFile = file.exists();
        FileOutputStream fileStream = new FileOutputStream(file, false);
        ServletInputStream inputStream = request.getInputStream();
        byte[] byteArray = new byte[request.getContentLength()];
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = inputStream.read(byteArray, bytesRead, request.getContentLength());
        }
        fileStream.write(byteArray);
        fileStream.close();
        inputStream.close();
        if (overwriteFile.booleanValue()) {
            response.setStatus(204);
            response.setHeader("Location", request.getRequestURI());
        } else {
            response.setStatus(201);
            response.setHeader("Location", request.getRequestURI());
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthenticated(request, response).booleanValue()) {
            return;
        }
        String path = request.getPathInfo();
        Log.debug("WebDAVLiteServlet: DELETE with path = " + path);
        if (path == null || !path.startsWith("/rooms/")) {
            response.sendError(404);
            return;
        }
        String[] pathPcs = path.split("/");
        if (pathPcs.length != 5) {
            response.sendError(404);
            return;
        }
        String service = pathPcs[2];
        String room = pathPcs[3];
        String filename = pathPcs[4];
        if (!this.isAuthorized(request, response, service, room).booleanValue()) {
            return;
        }
        Log.debug("WebDAVListServlet: Service = " + service + ", room = " + room + ", file = " + filename);
        File file = this.getFileReference(service, room, filename);
        if (file.exists()) {
            file.delete();
            response.setStatus(204);
        } else {
            response.setStatus(404);
        }
    }
}

