/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user.property;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.user.property.UserPropertyProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUserPropertyProvider
implements UserPropertyProvider {
    private static final Logger Log = LoggerFactory.getLogger(JDBCUserPropertyProvider.class);
    private String loadPropertySQL;
    private String loadPropertiesSQL;
    private String connectionString;
    private boolean useConnectionProvider;

    public JDBCUserPropertyProvider() {
        JiveGlobals.migrateProperty("jdbcUserPropertyProvider.driver");
        JiveGlobals.migrateProperty("jdbcUserPropertyProvider.connectionString");
        JiveGlobals.migrateProperty("jdbcUserPropertyProvider.loadPropertySQL");
        JiveGlobals.migrateProperty("jdbcUserPropertyProvider.loadPropertiesSQL");
        this.useConnectionProvider = JiveGlobals.getBooleanProperty("jdbcUserProvider.useConnectionProvider");
        if (!this.useConnectionProvider) {
            String jdbcDriver = JiveGlobals.getProperty("jdbcUserPropertyProvider.driver");
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                Log.error("Unable to load JDBC driver: " + jdbcDriver, (Throwable)e);
                return;
            }
            this.connectionString = JiveGlobals.getProperty("jdbcProvider.connectionString");
        }
        this.loadPropertySQL = JiveGlobals.getProperty("jdbcUserPropertyProvider.loadPropertySQL");
        this.loadPropertiesSQL = JiveGlobals.getProperty("jdbcUserPropertyProvider.loadPropertiesSQL");
    }

    private Connection getConnection() throws SQLException {
        if (this.useConnectionProvider) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }

    @Override
    public Map<String, String> loadProperties(String username) throws UnsupportedOperationException {
        HashMap<String, String> hashMap;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.loadPropertiesSQL);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            HashMap<String, String> result = new HashMap<String, String>();
            while (rs.next()) {
                String propName = rs.getString(1);
                String propValue = rs.getString(2);
                result.put(propName, propValue);
            }
            hashMap = result;
        }
        catch (Exception e) {
            try {
                throw new UnsupportedOperationException(e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return hashMap;
    }

    @Override
    public String loadProperty(String username, String propName) {
        String string;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block5: {
            con = null;
            pstmt = null;
            rs = null;
            con = this.getConnection();
            pstmt = con.prepareStatement(this.loadPropertySQL);
            pstmt.setString(1, username);
            pstmt.setString(2, propName);
            rs = pstmt.executeQuery();
            HashMap result = new HashMap();
            if (!rs.next()) break block5;
            String string2 = rs.getString(1);
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception e) {
            try {
                throw new UnsupportedOperationException(e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return string;
    }

    @Override
    public void insertProperty(String username, String propName, String propValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateProperty(String username, String propName, String propValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteProperty(String username, String propName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

