/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;

public class UserCollection
extends AbstractCollection<User> {
    private String[] elements;

    public UserCollection(String[] elements) {
        this.elements = elements;
    }

    @Override
    public Iterator<User> iterator() {
        return new UserIterator();
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    private class UserIterator
    implements Iterator<User> {
        private int currentIndex = -1;
        private User nextElement = null;

        private UserIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex + 1 >= UserCollection.this.elements.length && this.nextElement == null) {
                return false;
            }
            if (this.nextElement == null) {
                this.nextElement = this.getNextElement();
                if (this.nextElement == null) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public User next() throws NoSuchElementException {
            User element;
            if (this.nextElement != null) {
                element = this.nextElement;
                this.nextElement = null;
            } else {
                element = this.getNextElement();
                if (element == null) {
                    throw new NoSuchElementException();
                }
            }
            return element;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private User getNextElement() {
            while (this.currentIndex + 1 < UserCollection.this.elements.length) {
                ++this.currentIndex;
                User element = null;
                try {
                    element = UserManager.getInstance().getUser(UserCollection.this.elements[this.currentIndex]);
                }
                catch (UserNotFoundException userNotFoundException) {
                    // empty catch block
                }
                if (element == null) continue;
                return element;
            }
            return null;
        }
    }
}

