/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.PresenceEventListener;
import org.xmpp.packet.JID;
import org.xmpp.packet.Presence;

public class PresenceEventDispatcher {
    private static List<PresenceEventListener> listeners = new CopyOnWriteArrayList<PresenceEventListener>();

    public static void addListener(PresenceEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(PresenceEventListener listener) {
        listeners.remove(listener);
    }

    public static void availableSession(ClientSession session, Presence presence) {
        if (!listeners.isEmpty()) {
            for (PresenceEventListener listener : listeners) {
                listener.availableSession(session, presence);
            }
        }
    }

    public static void unavailableSession(ClientSession session, Presence presence) {
        if (!listeners.isEmpty()) {
            for (PresenceEventListener listener : listeners) {
                listener.unavailableSession(session, presence);
            }
        }
    }

    public static void presenceChanged(ClientSession session, Presence presence) {
        if (!listeners.isEmpty()) {
            for (PresenceEventListener listener : listeners) {
                listener.presenceChanged(session, presence);
            }
        }
    }

    public static void subscribedToPresence(JID subscriberJID, JID authorizerJID) {
        if (!listeners.isEmpty()) {
            for (PresenceEventListener listener : listeners) {
                listener.subscribedToPresence(subscriberJID, authorizerJID);
            }
        }
    }

    public static void unsubscribedToPresence(JID unsubscriberJID, JID recipientJID) {
        if (!listeners.isEmpty()) {
            for (PresenceEventListener listener : listeners) {
                listener.unsubscribedToPresence(unsubscriberJID, recipientJID);
            }
        }
    }
}

