/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.Collection;
import java.util.Date;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserMultiProvider;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.openfire.user.UserProviderMapper;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;

public class MappedUserProvider
extends UserMultiProvider {
    public static final String PROPERTY_MAPPER_CLASSNAME = "mappedUserProvider.mapper.className";
    protected final UserProviderMapper mapper;

    public MappedUserProvider() {
        JiveGlobals.migrateProperty(PROPERTY_MAPPER_CLASSNAME);
        String mapperClass = JiveGlobals.getProperty(PROPERTY_MAPPER_CLASSNAME);
        if (mapperClass == null) {
            throw new IllegalStateException("A mapper must be specified via openfire.xml or the system properties.");
        }
        try {
            Class c = ClassUtils.forName(mapperClass);
            this.mapper = (UserProviderMapper)c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create new instance of UserProviderMapper class: " + mapperClass, e);
        }
    }

    @Override
    public Collection<UserProvider> getUserProviders() {
        return this.mapper.getUserProviders();
    }

    @Override
    public UserProvider getUserProvider(String username) {
        return this.mapper.getUserProvider(username);
    }

    @Override
    public User loadUser(String username) throws UserNotFoundException {
        UserProvider userProvider;
        try {
            userProvider = this.getUserProvider(username);
        }
        catch (RuntimeException e) {
            throw new UserNotFoundException("Unable to identify user provider for username " + username, e);
        }
        return userProvider.loadUser(username);
    }

    @Override
    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        return this.getUserProvider(username).createUser(username, password, name, email);
    }

    @Override
    public void deleteUser(String username) {
        this.getUserProvider(username).deleteUser(username);
    }

    @Override
    public void setName(String username, String name) throws UserNotFoundException {
        this.getUserProvider(username).setName(username, name);
    }

    @Override
    public void setEmail(String username, String email) throws UserNotFoundException {
        this.getUserProvider(username).setEmail(username, email);
    }

    @Override
    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        this.getUserProvider(username).setCreationDate(username, creationDate);
    }

    @Override
    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        this.getUserProvider(username).setModificationDate(username, modificationDate);
    }
}

