/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserCollection;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class JDBCUserProvider
implements UserProvider {
    private static final Logger Log = LoggerFactory.getLogger(JDBCUserProvider.class);
    private String connectionString;
    private String loadUserSQL;
    private String userCountSQL;
    private String allUsersSQL;
    private String searchSQL;
    private String usernameField;
    private String nameField;
    private String emailField;
    private boolean useConnectionProvider;
    private static final boolean IS_READ_ONLY = true;

    public JDBCUserProvider() {
        JiveGlobals.migrateProperty("jdbcProvider.driver");
        JiveGlobals.migrateProperty("jdbcProvider.connectionString");
        JiveGlobals.migrateProperty("jdbcUserProvider.loadUserSQL");
        JiveGlobals.migrateProperty("jdbcUserProvider.userCountSQL");
        JiveGlobals.migrateProperty("jdbcUserProvider.allUsersSQL");
        JiveGlobals.migrateProperty("jdbcUserProvider.searchSQL");
        JiveGlobals.migrateProperty("jdbcUserProvider.usernameField");
        JiveGlobals.migrateProperty("jdbcUserProvider.nameField");
        JiveGlobals.migrateProperty("jdbcUserProvider.emailField");
        this.useConnectionProvider = JiveGlobals.getBooleanProperty("jdbcUserProvider.useConnectionProvider");
        if (!this.useConnectionProvider) {
            String jdbcDriver = JiveGlobals.getProperty("jdbcProvider.driver");
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                Log.error("Unable to load JDBC driver: " + jdbcDriver, (Throwable)e);
                return;
            }
            this.connectionString = JiveGlobals.getProperty("jdbcProvider.connectionString");
        }
        this.loadUserSQL = JiveGlobals.getProperty("jdbcUserProvider.loadUserSQL");
        this.userCountSQL = JiveGlobals.getProperty("jdbcUserProvider.userCountSQL");
        this.allUsersSQL = JiveGlobals.getProperty("jdbcUserProvider.allUsersSQL");
        this.searchSQL = JiveGlobals.getProperty("jdbcUserProvider.searchSQL");
        this.usernameField = JiveGlobals.getProperty("jdbcUserProvider.usernameField");
        this.nameField = JiveGlobals.getProperty("jdbcUserProvider.nameField");
        this.emailField = JiveGlobals.getProperty("jdbcUserProvider.emailField");
    }

    @Override
    public User loadUser(String username) throws UserNotFoundException {
        User user;
        if (username.contains("@")) {
            if (!XMPPServer.getInstance().isLocal(new JID(username))) {
                throw new UserNotFoundException("Cannot load user of remote server: " + username);
            }
            username = username.substring(0, username.lastIndexOf("@"));
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.loadUserSQL);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new UserNotFoundException();
            }
            String name = rs.getString(1);
            String email = rs.getString(2);
            user = new User(username, name, email, new Date(), new Date());
        }
        catch (Exception e) {
            try {
                throw new UserNotFoundException(e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return user;
    }

    @Override
    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteUser(String username) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        int count;
        block4: {
            count = 0;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = this.getConnection();
                pstmt = con.prepareStatement(this.userCountSQL);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return count;
    }

    @Override
    public Collection<User> getUsers() {
        Collection<String> usernames = this.getUsernames(0, Integer.MAX_VALUE);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    @Override
    public Collection<String> getUsernames() {
        return this.getUsernames(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getUsernames(int startIndex, int numResults) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        ArrayList<String> usernames;
        block8: {
            usernames = new ArrayList<String>(500);
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = this.getConnection();
                if (startIndex == 0 && numResults == Integer.MAX_VALUE) {
                    pstmt = con.prepareStatement(this.allUsersSQL);
                    DbConnectionManager.setFetchSize(pstmt, 500);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        usernames.add(rs.getString(1));
                    }
                } else {
                    pstmt = DbConnectionManager.createScrollablePreparedStatement(con, this.allUsersSQL);
                    DbConnectionManager.limitRowsAndFetchSize(pstmt, startIndex, numResults);
                    rs = pstmt.executeQuery();
                    DbConnectionManager.scrollResultSet(rs, startIndex);
                    for (int count = 0; rs.next() && count < numResults; ++count) {
                        usernames.add(rs.getString(1));
                    }
                }
                if (!Log.isDebugEnabled()) break block8;
                Log.debug("Results: " + usernames.size());
                this.LogResults(usernames);
            }
            catch (SQLException e) {
                try {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return usernames;
    }

    @Override
    public Collection<User> getUsers(int startIndex, int numResults) {
        Collection<String> usernames = this.getUsernames(startIndex, numResults);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    @Override
    public void setName(String username, String name) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmail(String username, String email) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getSearchFields() throws UnsupportedOperationException {
        if (this.searchSQL == null) {
            throw new UnsupportedOperationException();
        }
        return new LinkedHashSet<String>(Arrays.asList("Username", "Name", "Email"));
    }

    @Override
    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        return this.findUsers(fields, query, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        if (this.searchSQL == null) {
            throw new UnsupportedOperationException();
        }
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.getSearchFields().containsAll(fields)) {
            throw new IllegalArgumentException("Search fields " + fields + " are not valid.");
        }
        if (query == null || "".equals(query)) {
            return Collections.emptyList();
        }
        query = "%" + query.replace('*', '%') + "%";
        if (query.endsWith("%%")) {
            query = query.substring(0, query.length() - 1);
        }
        ArrayList<String> usernames = new ArrayList<String>(50);
        Connection con = null;
        PreparedStatement pstmt = null;
        int queries = 0;
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder(90);
            sql.append(this.searchSQL);
            boolean first = true;
            if (fields.contains("Username")) {
                sql.append(' ');
                sql.append(this.usernameField);
                sql.append(" LIKE ?");
                ++queries;
                first = false;
            }
            if (fields.contains("Name")) {
                if (!first) {
                    sql.append(" AND");
                }
                sql.append(' ');
                sql.append(this.nameField);
                sql.append(" LIKE ?");
                ++queries;
                first = false;
            }
            if (fields.contains("Email")) {
                if (!first) {
                    sql.append(" AND");
                }
                sql.append(' ');
                sql.append(this.emailField);
                sql.append(" LIKE ?");
                ++queries;
            }
            con = this.getConnection();
            if (startIndex == 0 && numResults == Integer.MAX_VALUE) {
                pstmt = con.prepareStatement(sql.toString());
                for (int i = 1; i <= queries; ++i) {
                    pstmt.setString(i, query);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    usernames.add(rs.getString(1));
                }
            } else {
                pstmt = DbConnectionManager.createScrollablePreparedStatement(con, sql.toString());
                DbConnectionManager.limitRowsAndFetchSize(pstmt, startIndex, numResults);
                for (int i = 1; i <= queries; ++i) {
                    pstmt.setString(i, query);
                }
                rs = pstmt.executeQuery();
                DbConnectionManager.scrollResultSet(rs, startIndex);
                for (int count = 0; rs.next() && count < numResults; ++count) {
                    usernames.add(rs.getString(1));
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Results: " + usernames.size());
                this.LogResults(usernames);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return false;
    }

    @Override
    public boolean isEmailRequired() {
        return false;
    }

    private void LogResults(List<String> listElements) {
        String callingMethod = Thread.currentThread().getStackTrace()[3].getMethodName();
        StringBuilder sb = new StringBuilder(256);
        int count = 0;
        for (String element : listElements) {
            if (count > 20) {
                Log.debug(callingMethod + " results: " + sb.toString());
                sb.delete(0, sb.length());
                count = 0;
            }
            sb.append(element).append(',');
            ++count;
        }
        sb.append('.');
        Log.debug(callingMethod + " results: " + sb.toString());
    }

    private Connection getConnection() throws SQLException {
        if (this.useConnectionProvider) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }
}

