/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserMultiProvider;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridUserProvider
extends UserMultiProvider {
    private static final Logger Log = LoggerFactory.getLogger(HybridUserProvider.class);
    private final List<UserProvider> userProviders = new ArrayList<UserProvider>();

    public HybridUserProvider() {
        UserProvider tertiary;
        UserProvider secondary;
        JiveGlobals.migrateProperty("hybridUserProvider.primaryProvider.className");
        JiveGlobals.migrateProperty("hybridUserProvider.secondaryProvider.className");
        JiveGlobals.migrateProperty("hybridUserProvider.tertiaryProvider.className");
        UserProvider primary = HybridUserProvider.instantiate("hybridUserProvider.primaryProvider.className");
        if (primary != null) {
            this.userProviders.add(primary);
        }
        if ((secondary = HybridUserProvider.instantiate("hybridUserProvider.secondaryProvider.className")) != null) {
            this.userProviders.add(secondary);
        }
        if ((tertiary = HybridUserProvider.instantiate("hybridUserProvider.tertiaryProvider.className")) != null) {
            this.userProviders.add(tertiary);
        }
        if (this.userProviders.isEmpty()) {
            Log.error("At least one UserProvider must be specified via openfire.xml or the system properties!");
        }
    }

    protected List<UserProvider> getUserProviders() {
        return this.userProviders;
    }

    @Override
    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        for (UserProvider provider : this.getUserProviders()) {
            if (provider.isReadOnly()) continue;
            return provider.createUser(username, password, name, email);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteUser(String username) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        for (UserProvider provider : this.getUserProviders()) {
            if (provider.isReadOnly()) continue;
            provider.deleteUser(username);
        }
    }

    @Override
    public UserProvider getUserProvider(String username) {
        UserProvider nonReadOnly = null;
        for (UserProvider provider : this.getUserProviders()) {
            try {
                provider.loadUser(username);
                return provider;
            }
            catch (UserNotFoundException unfe) {
                if (Log.isDebugEnabled()) {
                    Log.debug("User {} not found by UserProvider {}", (Object)username, (Object)provider.getClass().getName());
                }
                if (nonReadOnly != null || provider.isReadOnly()) continue;
                nonReadOnly = provider;
            }
        }
        if (nonReadOnly == null) {
            throw new UnsupportedOperationException();
        }
        return nonReadOnly;
    }

    @Override
    public User loadUser(String username) throws UserNotFoundException {
        for (UserProvider provider : this.userProviders) {
            try {
                return provider.loadUser(username);
            }
            catch (UserNotFoundException unfe) {
                if (!Log.isDebugEnabled()) continue;
                Log.debug("User {} not found by UserProvider {}", (Object)username, (Object)provider.getClass().getName());
            }
        }
        throw new UserNotFoundException();
    }

    @Override
    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        this.getUserProvider(username).setCreationDate(username, creationDate);
    }

    @Override
    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        this.getUserProvider(username).setCreationDate(username, modificationDate);
    }

    @Override
    public void setName(String username, String name) throws UserNotFoundException {
        this.getUserProvider(username).setEmail(username, name);
    }

    @Override
    public void setEmail(String username, String email) throws UserNotFoundException {
        this.getUserProvider(username).setEmail(username, email);
    }
}

