/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.update;

import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.update.DownloadStatus;
import org.jivesoftware.openfire.update.Update;
import org.jivesoftware.openfire.update.UpdateManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDownloadManager {
    private static final Logger Log = LoggerFactory.getLogger(PluginDownloadManager.class);

    public Update downloadPlugin(String url) {
        UpdateManager updateManager = XMPPServer.getInstance().getUpdateManager();
        updateManager.downloadPlugin(url);
        Update returnUpdate = null;
        for (Update update : updateManager.getPluginUpdates()) {
            if (!update.getURL().equals(url)) continue;
            returnUpdate = update;
            break;
        }
        return returnUpdate;
    }

    public DownloadStatus installPlugin(String url, int hashCode) {
        UpdateManager updateManager = XMPPServer.getInstance().getUpdateManager();
        boolean worked = updateManager.downloadPlugin(url);
        DownloadStatus status = new DownloadStatus();
        status.setHashCode(hashCode);
        status.setSuccessfull(worked);
        status.setUrl(url);
        return status;
    }

    public boolean updatePluginsList() {
        UpdateManager updateManager = XMPPServer.getInstance().getUpdateManager();
        try {
            updateManager.checkForServerUpdate(true);
            updateManager.checkForPluginsUpdates(true);
            JiveGlobals.setProperty("update.lastCheck", String.valueOf(System.currentTimeMillis()));
            return true;
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

