/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.stats.Statistic;

public class StatisticsManager {
    private static StatisticsManager instance = new StatisticsManager();
    private final Map<String, Statistic> statistics = new ConcurrentHashMap<String, Statistic>();
    private final Map<String, List<String>> multiStatGroups = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, String> keyToGroupMap = new ConcurrentHashMap<String, String>();

    public static StatisticsManager getInstance() {
        return instance;
    }

    private StatisticsManager() {
    }

    public void addStatistic(String statKey, Statistic definition) {
        this.statistics.put(statKey, definition);
    }

    public Statistic getStatistic(String statKey) {
        return this.statistics.get(statKey);
    }

    public void addMultiStatistic(String statKey, String groupName, Statistic statistic) {
        this.addStatistic(statKey, statistic);
        List<String> group = this.multiStatGroups.get(groupName);
        if (group == null) {
            group = new ArrayList<String>();
            this.multiStatGroups.put(groupName, group);
        }
        group.add(statKey);
        this.keyToGroupMap.put(statKey, groupName);
    }

    public List<String> getStatGroup(String statGroup) {
        return this.multiStatGroups.get(statGroup);
    }

    public String getMultistatGroup(String statKey) {
        return this.keyToGroupMap.get(statKey);
    }

    public Set<Map.Entry<String, Statistic>> getAllStatistics() {
        return this.statistics.entrySet();
    }

    public void removeStatistic(String statKey) {
        this.statistics.remove(statKey);
    }
}

