/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.transport.TransportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class PacketTransporterImpl
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(PacketTransporterImpl.class);
    private TransportHandler transportHandler;
    private PacketDeliverer deliverer;
    private XMPPServer xmppServer;

    public PacketTransporterImpl() {
        super("XMPP Packet Transporter");
    }

    public TransportHandler getTransportHandler() {
        return this.transportHandler;
    }

    public void deliver(Packet packet) throws UnauthorizedException, PacketException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (this.xmppServer != null && this.xmppServer.isLocal(packet.getTo())) {
            this.deliverer.deliver(packet);
        } else if (this.transportHandler != null) {
            this.transportHandler.process(packet);
        } else {
            Log.warn("Could not deliver message: no deliverer available " + packet.toString());
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.xmppServer = server;
        this.deliverer = server.getPacketDeliverer();
        this.transportHandler = server.getTransportHandler();
    }
}

