/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.ServerPort;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.keystore.CertificateStoreConfiguration;
import org.jivesoftware.openfire.spi.ConnectionAcceptor;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.openfire.spi.EncryptionArtifactFactory;
import org.jivesoftware.openfire.spi.LegacyConnectionAcceptor;
import org.jivesoftware.openfire.spi.MINAConnectionAcceptor;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionListener {
    private Logger Log;
    private final ConnectionType type;
    private final int defaultPort;
    private final InetAddress bindAddress;
    private CertificateStoreConfiguration identityStoreConfiguration;
    private CertificateStoreConfiguration trustStoreConfiguration;
    private final String tcpPortPropertyName;
    private final String isEnabledPropertyName;
    private final String maxPoolSizePropertyName;
    private final String maxReadBufferPropertyName;
    private final String tlsPolicyPropertyName;
    private final String compressionPolicyPropertyName;
    private final String clientAuthPolicyPropertyName;
    private ConnectionAcceptor connectionAcceptor;

    ConnectionListener getConnectionListener(ConnectionType type) {
        ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        return connectionManager.getListener(type, this.getTLSPolicy().equals((Object)Connection.TLSPolicy.legacyMode));
    }

    public ConnectionListener(ConnectionType type, String tcpPortPropertyName, int defaultPort, String isEnabledPropertyName, String maxPoolSizePropertyName, String maxReadBufferPropertyName, String tlsPolicyPropertyName, String clientAuthPolicyPropertyName, InetAddress bindAddress, CertificateStoreConfiguration identityStoreConfiguration, CertificateStoreConfiguration trustStoreConfiguration, String compressionPolicyPropertyName) {
        this.type = type;
        this.tcpPortPropertyName = tcpPortPropertyName;
        this.defaultPort = defaultPort;
        this.isEnabledPropertyName = isEnabledPropertyName;
        this.maxPoolSizePropertyName = maxPoolSizePropertyName;
        this.maxReadBufferPropertyName = maxReadBufferPropertyName;
        this.tlsPolicyPropertyName = tlsPolicyPropertyName;
        this.clientAuthPolicyPropertyName = clientAuthPolicyPropertyName;
        this.bindAddress = bindAddress;
        this.identityStoreConfiguration = identityStoreConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
        this.compressionPolicyPropertyName = compressionPolicyPropertyName;
        String name = this.getType().toString().toLowerCase() + (this.getTLSPolicy().equals((Object)Connection.TLSPolicy.legacyMode) ? "-legacyMode" : "");
        this.Log = LoggerFactory.getLogger((String)(ConnectionListener.class.getName() + "[" + name + "]"));
    }

    public boolean isEnabled() {
        if (this.isEnabledPropertyName == null) {
            return true;
        }
        return JiveGlobals.getBooleanProperty(this.isEnabledPropertyName, true);
    }

    public synchronized void enable(boolean enable) {
        boolean isRunning;
        if (this.isEnabledPropertyName == null && !enable) {
            throw new IllegalArgumentException("This listener cannot be disabled!");
        }
        boolean bl = isRunning = this.connectionAcceptor != null;
        if (enable == isRunning) {
            this.Log.debug("Ignoring enable({}): listener already in this state.", (Object)enable);
            return;
        }
        JiveGlobals.setProperty(this.isEnabledPropertyName, Boolean.toString(enable));
        this.restart();
    }

    public synchronized void start() {
        switch (this.getType()) {
            case BOSH_C2S: 
            case WEBADMIN: {
                this.Log.debug("Not starting a (MINA-based) connection acceptor, as connections of type " + (Object)((Object)this.getType()) + " depend on another IO technology.");
                return;
            }
        }
        if (!this.isEnabled()) {
            this.Log.debug("Not starting: disabled by configuration.");
            return;
        }
        if (this.connectionAcceptor != null) {
            if (!this.connectionAcceptor.isIdle()) {
                this.Log.warn("Unable to start: it appears to have already been started (and it is currently serving connections)! To restart, first stop this listener explicitly.");
                return;
            }
            this.Log.warn("Stopping (in order to restart) an instance that has already been started, but is idle. This start would have failed if the listener was not idle. The implementation should have called stop() or restart() first, to ensure a clean restart!");
            this.connectionAcceptor.stop();
        }
        this.Log.debug("Starting...");
        this.connectionAcceptor = this.getType() == ConnectionType.SOCKET_S2S ? new LegacyConnectionAcceptor(this.generateConnectionConfiguration()) : new MINAConnectionAcceptor(this.generateConnectionConfiguration());
        this.connectionAcceptor.start();
        this.Log.info("Started.");
    }

    public ConnectionConfiguration generateConnectionConfiguration() {
        int defaultMaxPoolSize = 16;
        int maxThreadPoolSize = this.maxPoolSizePropertyName == null ? 16 : JiveGlobals.getIntProperty(this.maxPoolSizePropertyName, 16);
        int maxBufferSize = this.maxReadBufferPropertyName != null ? JiveGlobals.getIntProperty(this.maxReadBufferPropertyName, 0xA00000) : -1;
        return new ConnectionConfiguration(this.getType(), this.isEnabled(), maxThreadPoolSize, maxBufferSize, this.getClientAuth(), this.getBindAddress(), this.getPort(), this.getTLSPolicy(), this.identityStoreConfiguration, this.trustStoreConfiguration, this.acceptSelfSignedCertificates(), this.verifyCertificateValidity(), this.getEncryptionProtocols(), this.getEncryptionCipherSuites(), this.getCompressionPolicy());
    }

    protected synchronized void stop() {
        if (this.connectionAcceptor == null) {
            this.Log.debug("Not stopping: it hasn't been started.");
            return;
        }
        this.Log.debug("Stopping...");
        try {
            this.connectionAcceptor.stop();
        }
        finally {
            this.connectionAcceptor = null;
        }
        this.Log.info("Stopped.");
    }

    public synchronized void restart() {
        this.Log.debug("Restarting...");
        try {
            if (this.connectionAcceptor != null) {
                this.stop();
            }
        }
        finally {
            this.start();
        }
        this.Log.info("Done restarting...");
    }

    public synchronized void reloadConfiguration() {
        if (this.connectionAcceptor == null) {
            return;
        }
        this.Log.debug("Reconfiguring...");
        this.connectionAcceptor.reconfigure(this.generateConnectionConfiguration());
        this.Log.info("Reconfigured.");
    }

    public NioSocketAcceptor getSocketAcceptor() {
        if (this.connectionAcceptor == null || !(this.connectionAcceptor instanceof MINAConnectionAcceptor)) {
            return null;
        }
        return ((MINAConnectionAcceptor)this.connectionAcceptor).getSocketAcceptor();
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public int getPort() {
        if (this.tcpPortPropertyName != null) {
            return JiveGlobals.getIntProperty(this.tcpPortPropertyName, this.defaultPort);
        }
        return this.defaultPort;
    }

    public void setPort(int port) {
        long oldPort = this.getPort();
        if ((long)port == oldPort) {
            this.Log.debug("Ignoring port change request (to '{}'): listener already in this state.", (Object)port);
            return;
        }
        this.Log.debug("Changing port from '{}' to '{}'.", (Object)oldPort, (Object)port);
        if (this.tcpPortPropertyName != null) {
            JiveGlobals.setProperty(this.tcpPortPropertyName, String.valueOf(port));
        }
        this.restart();
    }

    public Connection.ClientAuth getClientAuth() {
        Connection.ClientAuth clientAuth;
        if (this.clientAuthPolicyPropertyName == null) {
            clientAuth = Connection.ClientAuth.disabled;
        } else {
            String value = JiveGlobals.getProperty(this.clientAuthPolicyPropertyName, Connection.ClientAuth.disabled.name());
            try {
                clientAuth = Connection.ClientAuth.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                this.Log.error("Error parsing property value of '{}' into a valid ClientAUth. Offending value: '{}'.", new Object[]{value, this.clientAuthPolicyPropertyName, e});
                clientAuth = Connection.ClientAuth.disabled;
            }
        }
        return clientAuth;
    }

    public void setClientAuth(Connection.ClientAuth clientAuth) {
        Connection.ClientAuth oldValue = this.getClientAuth();
        if (oldValue.equals((Object)clientAuth)) {
            this.Log.debug("Ignoring client auth configuration change request (to '{}'): listener already in this state.", (Object)clientAuth);
            return;
        }
        this.Log.debug("Changing client auth configuration from '{}' to '{}'.", (Object)oldValue, (Object)clientAuth);
        JiveGlobals.setProperty(this.clientAuthPolicyPropertyName, clientAuth.toString());
        this.restart();
    }

    private Connection.TLSPolicy getHardcodedTLSPolicy() {
        try {
            return Connection.TLSPolicy.valueOf(this.tlsPolicyPropertyName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public Connection.TLSPolicy getTLSPolicy() {
        Connection.TLSPolicy tlsPolicy;
        Connection.TLSPolicy hardcoded = this.getHardcodedTLSPolicy();
        if (hardcoded != null) {
            return hardcoded;
        }
        String policyName = JiveGlobals.getProperty(this.tlsPolicyPropertyName, Connection.TLSPolicy.optional.toString());
        try {
            tlsPolicy = Connection.TLSPolicy.valueOf(policyName);
        }
        catch (IllegalArgumentException e) {
            this.Log.error("Error parsing property value of '{}' into a valid TLS_POLICY. Offending value: '{}'.", new Object[]{policyName, this.tlsPolicyPropertyName, e});
            tlsPolicy = Connection.TLSPolicy.optional;
        }
        return tlsPolicy;
    }

    public void setTLSPolicy(Connection.TLSPolicy policy) {
        Connection.TLSPolicy oldPolicy = this.getTLSPolicy();
        if (oldPolicy.equals((Object)policy)) {
            this.Log.debug("Ignoring TLS Policy change request (to '{}'): listener already in this state.", (Object)policy);
            return;
        }
        Connection.TLSPolicy hardcoded = this.getHardcodedTLSPolicy();
        if (hardcoded != null) {
            throw new IllegalArgumentException("The TLS Policy for this listener is hardcoded (to '" + (Object)((Object)hardcoded) + "'). It cannot be changed.");
        }
        if (Connection.TLSPolicy.legacyMode.equals((Object)policy)) {
            this.Log.warn("Ignoring TLS Policy change request (to '{}'): You cannot reconfigure an existing connection (from '{}') into legacy mode!", (Object)policy, (Object)oldPolicy);
            return;
        }
        if (Connection.TLSPolicy.legacyMode.equals((Object)oldPolicy)) {
            this.Log.warn("Ignoring TLS Policy change request (to '{}'): You cannot reconfigure an existing connection that is in legacy mode!", (Object)policy);
            return;
        }
        this.Log.debug("Changing TLS Policy from '{}' to '{}'.", (Object)oldPolicy, (Object)policy);
        JiveGlobals.setProperty(this.tlsPolicyPropertyName, policy.toString());
        this.restart();
    }

    public Connection.CompressionPolicy getCompressionPolicy() {
        Connection.CompressionPolicy defaultPolicy;
        switch (this.getType()) {
            case COMPONENT: 
            case CONNECTION_MANAGER: 
            case SOCKET_S2S: {
                defaultPolicy = Connection.CompressionPolicy.disabled;
                break;
            }
            default: {
                defaultPolicy = Connection.CompressionPolicy.optional;
            }
        }
        if (this.compressionPolicyPropertyName == null) {
            return defaultPolicy;
        }
        String policyName = JiveGlobals.getProperty(this.compressionPolicyPropertyName, defaultPolicy.toString());
        try {
            return Connection.CompressionPolicy.valueOf(policyName);
        }
        catch (IllegalArgumentException e) {
            this.Log.error("Error parsing property value of '{}' into a valid Compression Policy. Offending value: '{}'.", new Object[]{this.tlsPolicyPropertyName, policyName, e});
            return defaultPolicy;
        }
    }

    public void setCompressionPolicy(Connection.CompressionPolicy policy) {
        Connection.CompressionPolicy oldPolicy = this.getCompressionPolicy();
        if (oldPolicy.equals((Object)policy)) {
            this.Log.debug("Ignoring Compression Policy change request (to '{}'): listener already in this state.", (Object)policy);
            return;
        }
        this.Log.debug("Changing Compression Policy from '{}' to '{}'.", (Object)oldPolicy, (Object)policy);
        JiveGlobals.setProperty(this.compressionPolicyPropertyName, policy.toString());
        this.restart();
    }

    public CertificateStoreConfiguration getIdentityStoreConfiguration() {
        return this.identityStoreConfiguration;
    }

    public void setIdentityStoreConfiguration(CertificateStoreConfiguration configuration) {
        if (this.identityStoreConfiguration.equals(configuration)) {
            this.Log.debug("Ignoring identity store configuration change request (to '{}'): listener already in this state.", (Object)configuration);
            return;
        }
        this.Log.debug("Changing identity store configuration  from '{}' to '{}'.", (Object)this.identityStoreConfiguration, (Object)configuration);
        this.identityStoreConfiguration = configuration;
        this.restart();
    }

    public CertificateStoreConfiguration getTrustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public void setTrustStoreConfiguration(CertificateStoreConfiguration configuration) {
        if (this.trustStoreConfiguration.equals(configuration)) {
            this.Log.debug("Ignoring trust store configuration change request (to '{}'): listener already in this state.", (Object)configuration);
            return;
        }
        this.Log.debug("Changing trust store configuration  from '{}' to '{}'.", (Object)this.trustStoreConfiguration, (Object)configuration);
        this.trustStoreConfiguration = configuration;
        this.restart();
    }

    public boolean acceptSelfSignedCertificates() {
        String propertyName = this.type.getPrefix() + "certificate.accept-selfsigned";
        boolean defaultValue = false;
        if (this.type.getFallback() == null) {
            return JiveGlobals.getBooleanProperty(propertyName, false);
        }
        return JiveGlobals.getBooleanProperty(propertyName, this.getConnectionListener(this.type.getFallback()).acceptSelfSignedCertificates());
    }

    public void setAcceptSelfSignedCertificates(boolean accept) {
        boolean oldValue = this.verifyCertificateValidity();
        JiveGlobals.setProperty(this.type.getPrefix() + "certificate.accept-selfsigned", Boolean.toString(accept));
        if (oldValue == accept) {
            this.Log.debug("Ignoring self-signed certificate acceptance policy change request (to '{}'): listener already in this state.", (Object)accept);
            return;
        }
        this.Log.debug("Changing self-signed certificate acceptance policy from '{}' to '{}'.", (Object)oldValue, (Object)accept);
        this.restart();
    }

    public boolean verifyCertificateValidity() {
        String propertyName = this.type.getPrefix() + "certificate.verify.validity";
        boolean defaultValue = true;
        if (this.type.getFallback() == null) {
            return JiveGlobals.getBooleanProperty(propertyName, true);
        }
        return JiveGlobals.getBooleanProperty(propertyName, this.getConnectionListener(this.type.getFallback()).acceptSelfSignedCertificates());
    }

    public void setVerifyCertificateValidity(boolean verify) {
        boolean oldValue = this.verifyCertificateValidity();
        JiveGlobals.setProperty(this.type.getPrefix() + "certificate.verify.validity", Boolean.toString(verify));
        if (oldValue == verify) {
            this.Log.debug("Ignoring certificate validity verification configuration change request (to '{}'): listener already in this state.", (Object)verify);
            return;
        }
        this.Log.debug("Changing certificate validity verification configuration from '{}' to '{}'.", (Object)oldValue, (Object)verify);
        this.restart();
    }

    public Set<String> getEncryptionProtocols() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String csv = this.getEncryptionProtocolsCommaSeparated();
        if (csv.isEmpty()) {
            try {
                result.addAll(EncryptionArtifactFactory.getDefaultProtocols());
            }
            catch (Exception ex) {
                this.Log.error("An error occurred while obtaining the default encryption protocol setting.", (Throwable)ex);
            }
        } else {
            result.addAll(Arrays.asList(csv.split("\\s*,\\s*")));
        }
        try {
            result.retainAll(EncryptionArtifactFactory.getSupportedProtocols());
        }
        catch (Exception ex) {
            this.Log.error("An error occurred while obtaining the supported encryption protocols.", (Throwable)ex);
        }
        return result;
    }

    protected String getEncryptionProtocolsCommaSeparated() {
        String propertyName = this.type.getPrefix() + "protocols";
        String defaultValue = "";
        if (this.type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, "").trim();
        }
        return JiveGlobals.getProperty(propertyName, this.getConnectionListener(this.type.getFallback()).getEncryptionProtocolsCommaSeparated()).trim();
    }

    public void setEncryptionProtocols(Set<String> protocols) {
        if (protocols == null) {
            this.setEncryptionProtocols(new String[0]);
        } else {
            this.setEncryptionProtocols(protocols.toArray(new String[protocols.size()]));
        }
    }

    public void setEncryptionProtocols(String[] protocols) {
        if (protocols == null) {
            protocols = new String[]{};
        }
        String oldValue = this.getEncryptionProtocolsCommaSeparated();
        StringBuilder csv = new StringBuilder();
        for (String protocol : protocols) {
            csv.append(protocol);
            csv.append(',');
        }
        String newValue = csv.length() > 0 ? csv.substring(0, csv.length() - 1) : "";
        JiveGlobals.setProperty(this.type.getPrefix() + "protocols", newValue);
        if (oldValue.equals(newValue)) {
            this.Log.debug("Ignoring protocol configuration change request (to '{}'): listener already in this state.", (Object)newValue);
            return;
        }
        this.Log.debug("Changing protocol configuration from '{}' to '{}'.", (Object)oldValue, (Object)newValue);
        this.restart();
    }

    public Set<String> getEncryptionCipherSuites() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String csv = this.getEncryptionCipherSuitesCommaSeparated();
        if (csv.isEmpty()) {
            try {
                result.addAll(EncryptionArtifactFactory.getDefaultCipherSuites());
            }
            catch (Exception ex) {
                this.Log.error("An error occurred while obtaining the default encryption cipher suite setting.", (Throwable)ex);
            }
        } else {
            result.addAll(Arrays.asList(csv.split("\\s*,\\s*")));
        }
        try {
            result.retainAll(EncryptionArtifactFactory.getSupportedCipherSuites());
        }
        catch (Exception ex) {
            this.Log.warn("An error occurred while obtaining the supported encryption cipher suites.", (Throwable)ex);
        }
        return result;
    }

    protected String getEncryptionCipherSuitesCommaSeparated() {
        String propertyName = this.type.getPrefix() + "ciphersuites";
        String defaultValue = "";
        if (this.type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, "");
        }
        return JiveGlobals.getProperty(propertyName, this.getConnectionListener(this.type.getFallback()).getEncryptionCipherSuitesCommaSeparated());
    }

    public void setEncryptionCipherSuites(Set<String> cipherSuites) {
        if (cipherSuites == null) {
            this.setEncryptionCipherSuites(new String[0]);
        } else {
            this.setEncryptionCipherSuites(cipherSuites.toArray(new String[cipherSuites.size()]));
        }
    }

    public void setEncryptionCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null) {
            cipherSuites = new String[]{};
        }
        String oldValue = this.getEncryptionCipherSuitesCommaSeparated();
        StringBuilder csv = new StringBuilder();
        for (String cipherSuite : cipherSuites) {
            csv.append(cipherSuite);
            csv.append(',');
        }
        String newValue = csv.length() > 0 ? csv.substring(0, csv.length() - 1) : "";
        JiveGlobals.setProperty(this.type.getPrefix() + "ciphersuites", newValue);
        if (oldValue.equals(newValue)) {
            this.Log.debug("Ignoring cipher suite configuration change request (to '{}'): listener already in this state.", (Object)newValue);
            return;
        }
        this.Log.debug("Changing cipher suite configuration from '{}' to '{}'.", (Object)oldValue, (Object)newValue);
        this.restart();
    }

    @Deprecated
    public ServerPort getServerPort() {
        if (this.connectionAcceptor == null) {
            return null;
        }
        int port = this.getPort();
        String name = this.getBindAddress().getHostName();
        String address = this.getBindAddress().getHostAddress();
        boolean isSecure = this.getTLSPolicy() != Connection.TLSPolicy.disabled;
        String algorithm = null;
        switch (this.type) {
            case SOCKET_C2S: {
                return new ServerPort(port, name, address, isSecure, algorithm, ServerPort.Type.client);
            }
            case SOCKET_S2S: {
                return new ServerPort(port, name, address, isSecure, algorithm, ServerPort.Type.server);
            }
            case COMPONENT: {
                return new ServerPort(port, name, address, isSecure, algorithm, ServerPort.Type.component);
            }
            case CONNECTION_MANAGER: {
                return new ServerPort(port, name, address, isSecure, algorithm, ServerPort.Type.connectionManager);
            }
        }
        throw new IllegalStateException("Unrecognized type: " + (Object)((Object)this.type));
    }

    public String toString() {
        String name = this.getType().toString().toLowerCase() + (this.getTLSPolicy().equals((Object)Connection.TLSPolicy.legacyMode) ? "-legacyMode" : "");
        return "ConnectionListener{name=" + name + '}';
    }
}

