/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.lang.StringEscapeUtils;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.StreamIDFactory;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;

public class BasicStreamIDFactory
implements StreamIDFactory {
    private static final int MAX_STRING_SIZE = 10;
    Random random = new SecureRandom();

    @Override
    public StreamID createStreamID() {
        return new BasicStreamID(new BigInteger(50, this.random).toString(36));
    }

    public static StreamID createStreamID(String name) {
        return new BasicStreamID(name);
    }

    private static class BasicStreamID
    implements StreamID,
    Cacheable {
        String id;

        public BasicStreamID(String id) {
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("Argument 'id' cannot be null.");
            }
            this.id = StringEscapeUtils.escapeXml((String)id);
        }

        @Override
        public String getID() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.id.equals(((BasicStreamID)o).id);
        }

        @Override
        public int getCachedSize() throws CannotCalculateSizeException {
            int size = 0;
            size += CacheSizes.sizeOfObject();
            return size += CacheSizes.sizeOfString(this.id);
        }
    }
}

