/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSession;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.net.SocketConnection;
import org.jivesoftware.openfire.net.TLSStreamHandler;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.streammanagement.StreamManager;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public abstract class LocalSession
implements Session {
    private static final Logger Log = LoggerFactory.getLogger(LocalSession.class);
    protected static String CHARSET = "UTF-8";
    private JID address;
    private StreamID streamID;
    protected int status = 1;
    protected Connection conn;
    protected SessionManager sessionManager;
    private String serverName;
    private long startDate = System.currentTimeMillis();
    private long lastActiveDate;
    private long clientPacketCount = 0L;
    private long serverPacketCount = 0L;
    private final Map<String, Object> sessionData = new HashMap<String, Object>();
    protected final StreamManager streamManager;
    private final Locale language;

    public LocalSession(String serverName, Connection connection, StreamID streamID, Locale language) {
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        this.conn = connection;
        this.streamID = streamID;
        this.serverName = serverName;
        String id = streamID.getID();
        this.address = new JID(null, serverName, id, true);
        this.sessionManager = SessionManager.getInstance();
        this.streamManager = new StreamManager(this);
        this.language = language;
    }

    public boolean isDetached() {
        return this.conn == null;
    }

    public void setDetached() {
        this.sessionManager.addDetached(this);
        this.conn = null;
    }

    public void reattach(Connection connection, long h) {
        Connection temp = this.conn;
        this.conn = null;
        if (temp != null && !temp.isClosed()) {
            temp.close();
        }
        this.conn = connection;
        this.conn.reinit(this);
        this.status = 3;
        this.sessionManager.removeDetached(this);
        this.streamManager.onResume(new JID(null, this.serverName, null, true), h);
    }

    @Override
    public JID getAddress() {
        return this.address;
    }

    public void setAddress(JID address) {
        this.address = address;
    }

    public Connection getConnection() {
        if (this.conn == null) {
            try {
                this.conn.isClosed();
            }
            catch (NullPointerException e) {
                Log.error("Attempt to read connection of detached session: ", (Throwable)e);
            }
        }
        return this.conn;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        if (status == -1 && this.streamManager.getResume()) {
            Log.debug("Suppressing close.");
            return;
        }
        this.status = status;
    }

    @Override
    public StreamID getStreamID() {
        return this.streamID;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.startDate);
    }

    @Override
    public Date getLastActiveDate() {
        return new Date(this.lastActiveDate);
    }

    public void incrementClientPacketCount() {
        ++this.clientPacketCount;
        this.lastActiveDate = System.currentTimeMillis();
        this.streamManager.incrementServerProcessedStanzas();
    }

    public void incrementServerPacketCount() {
        ++this.serverPacketCount;
        this.lastActiveDate = System.currentTimeMillis();
    }

    @Override
    public long getNumClientPackets() {
        return this.clientPacketCount;
    }

    @Override
    public long getNumServerPackets() {
        return this.serverPacketCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionData(String key, Object value) {
        Map<String, Object> map = this.sessionData;
        synchronized (map) {
            this.sessionData.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionData(String key) {
        Map<String, Object> map = this.sessionData;
        synchronized (map) {
            return this.sessionData.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionData(String key) {
        Map<String, Object> map = this.sessionData;
        synchronized (map) {
            this.sessionData.remove(key);
        }
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    public void process(Packet packet) {
        IQ iq;
        if (this.canProcess(packet)) {
            try {
                InterceptorManager.getInstance().invokeInterceptors(packet, this, false, false);
                this.deliver(packet);
                InterceptorManager.getInstance().invokeInterceptors(packet, this, false, true);
            }
            catch (PacketRejectedException packetRejectedException) {
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
        } else if (packet instanceof Message) {
            Message message = (Message)packet;
            Message result = message.createCopy();
            result.setTo(message.getFrom());
            result.setError(PacketError.Condition.service_unavailable);
            XMPPServer.getInstance().getRoutingTable().routePacket(message.getFrom(), (Packet)result, true);
        } else if (packet instanceof IQ && ((iq = (IQ)packet).getType() == IQ.Type.get || iq.getType() == IQ.Type.set)) {
            IQ result = IQ.createResultIQ((IQ)iq);
            result.setError(PacketError.Condition.service_unavailable);
            XMPPServer.getInstance().getRoutingTable().routePacket(iq.getFrom(), (Packet)result, true);
        }
    }

    abstract boolean canProcess(Packet var1);

    abstract void deliver(Packet var1) throws UnauthorizedException;

    @Override
    public void deliverRawText(String text) {
        this.conn.deliverRawText(text);
    }

    public abstract String getAvailableStreamFeatures();

    @Override
    public void close() {
        if (this.conn == null) {
            return;
        }
        this.conn.close();
    }

    @Override
    public boolean validate() {
        return this.conn.validate();
    }

    @Override
    public boolean isSecure() {
        return this.conn.isSecure();
    }

    @Override
    public Certificate[] getPeerCertificates() {
        return this.conn.getPeerCertificates();
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    @Override
    public String getHostAddress() throws UnknownHostException {
        if (this.conn == null) {
            throw new UnknownHostException("Detached session");
        }
        return this.conn.getHostAddress();
    }

    @Override
    public String getHostName() throws UnknownHostException {
        if (this.conn == null) {
            throw new UnknownHostException("Detached session");
        }
        return this.conn.getHostName();
    }

    public String toString() {
        return super.toString() + " status: " + this.status + " address: " + this.address + " id: " + this.streamID;
    }

    protected static int[] decodeVersion(String version) {
        int[] answer = new int[]{0, 0};
        String[] versionString = version.split("\\.");
        answer[0] = Integer.parseInt(versionString[0]);
        answer[1] = Integer.parseInt(versionString[1]);
        return answer;
    }

    public boolean isUsingSelfSignedCertificate() {
        return this.conn.isUsingSelfSignedCertificate();
    }

    @Override
    public String getCipherSuiteName() {
        SSLSession ssl;
        TLSStreamHandler t;
        SocketConnection s = (SocketConnection)this.getConnection();
        if (s != null && (t = s.getTLSStreamHandler()) != null && (ssl = t.getSSLSession()) != null) {
            return ssl.getCipherSuite();
        }
        return "NONE";
    }

    @Override
    public final Locale getLanguage() {
        return this.language;
    }
}

