/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingServerSocketReader {
    private static final Logger Log = LoggerFactory.getLogger(OutgoingServerSocketReader.class);
    private OutgoingServerSession session;
    private boolean open = true;
    private XMPPPacketReader reader = null;
    private BlockingQueue<Element> elements = new LinkedBlockingQueue<Element>(10000);

    public OutgoingServerSocketReader(XMPPPacketReader reader) {
        this.reader = reader;
        this.init();
    }

    public OutgoingServerSession getSession() {
        return this.session;
    }

    public void setSession(OutgoingServerSession session) {
        this.session = session;
    }

    public Element getElement(long timeout, TimeUnit unit) throws InterruptedException {
        return this.elements.poll(timeout, unit);
    }

    private void init() {
        Thread thread = new Thread("Outgoing Server Reader"){

            @Override
            public void run() {
                while (OutgoingServerSocketReader.this.open) {
                    String message;
                    try {
                        Element doc = OutgoingServerSocketReader.this.reader.parseDocument().getRootElement();
                        if (doc == null) {
                            OutgoingServerSocketReader.this.closeSession();
                            continue;
                        }
                        OutgoingServerSocketReader.this.elements.add(doc);
                    }
                    catch (IOException e) {
                        message = "Finishing Outgoing Server Reader. ";
                        message = OutgoingServerSocketReader.this.session != null ? message + "Closing session: " + OutgoingServerSocketReader.this.session.toString() : message + "No session to close.";
                        Log.debug("OutgoingServerSocketReader: " + message, (Throwable)e);
                        OutgoingServerSocketReader.this.closeSession();
                    }
                    catch (Exception e) {
                        message = "Finishing Outgoing Server Reader. ";
                        message = OutgoingServerSocketReader.this.session != null ? message + "Closing session: " + OutgoingServerSocketReader.this.session.toString() : message + "No session to close.";
                        Log.error(message, (Throwable)e);
                        OutgoingServerSocketReader.this.closeSession();
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private void closeSession() {
        this.open = false;
        if (this.session != null) {
            this.session.close();
        }
    }
}

