/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sasl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jivesoftware.openfire.sasl.AnonymousSaslServer;
import org.jivesoftware.openfire.sasl.ExternalClientSaslServer;
import org.jivesoftware.openfire.sasl.ExternalServerSaslServer;
import org.jivesoftware.openfire.sasl.JiveSharedSecretSaslServer;
import org.jivesoftware.openfire.sasl.SaslServerPlainImpl;
import org.jivesoftware.openfire.sasl.ScramSha1SaslServer;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerFactoryImpl
implements SaslServerFactory {
    private static final Logger Log = LoggerFactory.getLogger(SaslServerFactoryImpl.class);
    private final Set<Mechanism> allMechanisms = new HashSet<Mechanism>();

    public SaslServerFactoryImpl() {
        this.allMechanisms.add(new Mechanism("ANONYMOUS", true, true));
        this.allMechanisms.add(new Mechanism("PLAIN", false, true));
        this.allMechanisms.add(new Mechanism("SCRAM-SHA-1", false, false));
        this.allMechanisms.add(new Mechanism("JIVE-SHAREDSECRET", true, false));
        this.allMechanisms.add(new Mechanism("EXTERNAL", false, false));
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (!Arrays.asList(this.getMechanismNames(props)).contains(mechanism)) {
            Log.debug("This implementation is unable to create a SaslServer instance for the {} mechanism using the provided properties.", (Object)mechanism);
            return null;
        }
        switch (mechanism.toUpperCase()) {
            case "PLAIN": {
                if (cbh == null) {
                    Log.debug("Unable to instantiate {} SaslServer: A callbackHandler with support for Password, Name, and AuthorizeCallback required.", (Object)mechanism);
                    return null;
                }
                return new SaslServerPlainImpl(protocol, serverName, props, cbh);
            }
            case "SCRAM-SHA-1": {
                return new ScramSha1SaslServer();
            }
            case "ANONYMOUS": {
                if (!props.containsKey(LocalSession.class.getCanonicalName())) {
                    Log.debug("Unable to instantiate {} SaslServer: Provided properties do not contain a LocalSession instance.", (Object)mechanism);
                    return null;
                }
                LocalSession session = (LocalSession)props.get(LocalSession.class.getCanonicalName());
                return new AnonymousSaslServer(session);
            }
            case "EXTERNAL": {
                if (!props.containsKey(LocalSession.class.getCanonicalName())) {
                    Log.debug("Unable to instantiate {} SaslServer: Provided properties do not contain a LocalSession instance.", (Object)mechanism);
                    return null;
                }
                Object session = props.get(LocalSession.class.getCanonicalName());
                if (session instanceof LocalClientSession) {
                    return new ExternalClientSaslServer((LocalClientSession)session);
                }
                if (session instanceof LocalIncomingServerSession) {
                    return new ExternalServerSaslServer((LocalIncomingServerSession)session);
                }
                Log.debug("Unable to instantiate {} Sasl Server: Provided properties contains neither LocalClientSession nor LocalIncomingServerSession instance.", (Object)mechanism);
                return null;
            }
            case "JIVE-SHAREDSECRET": {
                return new JiveSharedSecretSaslServer();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        HashSet<String> result = new HashSet<String>();
        for (Mechanism mechanism : this.allMechanisms) {
            if (props != null && (mechanism.allowsAnonymous && props.containsKey("javax.security.sasl.policy.noanonymous") && Boolean.parseBoolean((String)props.get("javax.security.sasl.policy.noanonymous")) || mechanism.isPlaintext && props.containsKey("javax.security.sasl.policy.noplaintext") && Boolean.parseBoolean((String)props.get("javax.security.sasl.policy.noplaintext")))) continue;
            result.add(mechanism.name);
        }
        return result.toArray(new String[result.size()]);
    }

    private static class Mechanism {
        final String name;
        final boolean allowsAnonymous;
        final boolean isPlaintext;

        private Mechanism(String name, boolean allowsAnonymous, boolean isPlaintext) {
            this.name = name;
            this.allowsAnonymous = allowsAnonymous;
            this.isPlaintext = isPlaintext;
        }
    }
}

