/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sasl;

import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;

public class JiveSharedSecretSaslServer
implements SaslServer {
    public static final String NAME = "JIVE-SHAREDSECRET";
    private boolean complete = false;

    @Override
    public String getMechanismName() {
        return NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication exchange already completed.");
        }
        if (response == null || response.length == 0) {
            return new byte[0];
        }
        this.complete = true;
        StringTokenizer tokens = new StringTokenizer(new String(response, StandardCharsets.UTF_8), "\u0000");
        tokens.nextToken();
        String secretDigest = tokens.nextToken();
        if (JiveSharedSecretSaslServer.authenticateSharedSecret(secretDigest)) {
            return null;
        }
        throw new SaslException("Authentication failed");
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        if (propName.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.complete = false;
    }

    public static boolean authenticateSharedSecret(String digest) {
        if (!JiveSharedSecretSaslServer.isSharedSecretAllowed()) {
            return false;
        }
        return StringUtils.hash(JiveSharedSecretSaslServer.getSharedSecret()).equals(digest);
    }

    public static boolean isSharedSecretAllowed() {
        return JiveGlobals.getBooleanProperty("xmpp.auth.sharedSecretEnabled");
    }

    public static String getSharedSecret() {
        if (!JiveSharedSecretSaslServer.isSharedSecretAllowed()) {
            return null;
        }
        String sharedSecret = JiveGlobals.getProperty("xmpp.auth.sharedSecret");
        if (sharedSecret == null) {
            sharedSecret = StringUtils.randomString(8);
            JiveGlobals.setProperty("xmpp.auth.sharedSecret", sharedSecret);
        }
        return sharedSecret;
    }

    public static void setSharedSecretAllowed(boolean sharedSecretAllowed) {
        JiveGlobals.setProperty("xmpp.auth.sharedSecretEnabled", sharedSecretAllowed ? "true" : "false");
    }
}

