/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.roster;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterEventListener;
import org.jivesoftware.openfire.roster.RosterItem;

public class RosterEventDispatcher {
    private static List<RosterEventListener> listeners = new CopyOnWriteArrayList<RosterEventListener>();

    public static void addListener(RosterEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(RosterEventListener listener) {
        listeners.remove(listener);
    }

    public static void rosterLoaded(Roster roster) {
        if (!listeners.isEmpty()) {
            for (RosterEventListener listener : listeners) {
                listener.rosterLoaded(roster);
            }
        }
    }

    public static boolean addingContact(Roster roster, RosterItem item, boolean persistent) {
        boolean answer = persistent;
        if (!listeners.isEmpty()) {
            for (RosterEventListener listener : listeners) {
                if (listener.addingContact(roster, item, persistent)) continue;
                answer = false;
            }
        }
        return answer;
    }

    public static void contactAdded(Roster roster, RosterItem item) {
        if (!listeners.isEmpty()) {
            for (RosterEventListener listener : listeners) {
                listener.contactAdded(roster, item);
            }
        }
    }

    public static void contactUpdated(Roster roster, RosterItem item) {
        if (!listeners.isEmpty()) {
            for (RosterEventListener listener : listeners) {
                listener.contactUpdated(roster, item);
            }
        }
    }

    public static void contactDeleted(Roster roster, RosterItem item) {
        if (!listeners.isEmpty()) {
            for (RosterEventListener listener : listeners) {
                listener.contactDeleted(roster, item);
            }
        }
    }
}

