/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.roster;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.SequenceManager;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterItemProvider;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class DefaultRosterItemProvider
implements RosterItemProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultRosterItemProvider.class);
    private static final String CREATE_ROSTER_ITEM = "INSERT INTO ofRoster (username, rosterID, jid, sub, ask, recv, nick) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_ROSTER_ITEM = "UPDATE ofRoster SET sub=?, ask=?, recv=?, nick=? WHERE rosterID=?";
    private static final String DELETE_ROSTER_ITEM_GROUPS = "DELETE FROM ofRosterGroups WHERE rosterID=?";
    private static final String CREATE_ROSTER_ITEM_GROUPS = "INSERT INTO ofRosterGroups (rosterID, rank, groupName) VALUES (?, ?, ?)";
    private static final String DELETE_ROSTER_ITEM = "DELETE FROM ofRoster WHERE rosterID=?";
    private static final String LOAD_USERNAMES = "SELECT DISTINCT username from ofRoster WHERE jid=?";
    private static final String COUNT_ROSTER_ITEMS = "SELECT COUNT(rosterID) FROM ofRoster WHERE username=?";
    private static final String LOAD_ROSTER = "SELECT jid, rosterID, sub, ask, recv, nick FROM ofRoster WHERE username=?";
    private static final String LOAD_ROSTER_ITEM_GROUPS = "SELECT ofRosterGroups.rosterID,groupName FROM ofRosterGroups INNER JOIN ofRoster ON ofRosterGroups.rosterID = ofRoster.rosterID WHERE username=? ORDER BY ofRosterGroups.rosterID, rank";

    @Override
    public RosterItem createItem(String username, RosterItem item) throws UserAlreadyExistsException {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            long rosterID = SequenceManager.nextID(18);
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(CREATE_ROSTER_ITEM);
            pstmt.setString(1, username);
            pstmt.setLong(2, rosterID);
            pstmt.setString(3, item.getJid().toBareJID());
            pstmt.setInt(4, item.getSubStatus().getValue());
            pstmt.setInt(5, item.getAskStatus().getValue());
            pstmt.setInt(6, item.getRecvStatus().getValue());
            pstmt.setString(7, item.getNickname());
            pstmt.executeUpdate();
            item.setID(rosterID);
            this.insertGroups(rosterID, item.getGroups().iterator(), con);
        }
        catch (SQLException e) {
            try {
                Log.warn("Error trying to insert a new row in ofRoster", (Throwable)e);
                throw new UserAlreadyExistsException(item.getJid().toBareJID());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateItem(String username, RosterItem item) throws UserNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        long rosterID = item.getID();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_ROSTER_ITEM);
            pstmt.setInt(1, item.getSubStatus().getValue());
            pstmt.setInt(2, item.getAskStatus().getValue());
            pstmt.setInt(3, item.getRecvStatus().getValue());
            pstmt.setString(4, item.getNickname());
            pstmt.setLong(5, rosterID);
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_ROSTER_ITEM_GROUPS);
            pstmt.setLong(1, rosterID);
            pstmt.executeUpdate();
            this.insertGroups(rosterID, item.getGroups().iterator(), con);
        }
        catch (SQLException e) {
            try {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(String username, long rosterItemID) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_ROSTER_ITEM_GROUPS);
            pstmt.setLong(1, rosterItemID);
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_ROSTER_ITEM);
            pstmt.setLong(1, rosterItemID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getUsernames(String jid) {
        ArrayList<String> answer = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_USERNAMES);
            pstmt.setString(1, jid);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                answer.add(rs.getString(1));
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return answer.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemCount(String username) {
        int count = 0;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(COUNT_ROSTER_ITEMS);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RosterItem> getItems(String username) {
        LinkedList<RosterItem> itemList = new LinkedList<RosterItem>();
        HashMap<Long, RosterItem> itemsByID = new HashMap<Long, RosterItem>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_ROSTER);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RosterItem item = new RosterItem(rs.getLong(2), new JID(rs.getString(1)), RosterItem.SubType.getTypeFromInt(rs.getInt(3)), RosterItem.AskType.getTypeFromInt(rs.getInt(4)), RosterItem.RecvType.getTypeFromInt(rs.getInt(5)), rs.getString(6), null);
                itemList.add(item);
                itemsByID.put(item.getID(), item);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = null;
            if (!itemList.isEmpty()) {
                pstmt = con.prepareStatement(LOAD_ROSTER_ITEM_GROUPS);
                pstmt.setString(1, username);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ((RosterItem)itemsByID.get(rs.getLong(1))).getGroups().add(rs.getString(2));
                }
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return itemList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGroups(long rosterID, Iterator<String> iter, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(CREATE_ROSTER_ITEM_GROUPS);
            pstmt.setLong(1, rosterID);
            int i = 0;
            while (iter.hasNext()) {
                pstmt.setInt(2, i);
                String groupName = iter.next();
                pstmt.setString(3, groupName);
                try {
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                ++i;
            }
        }
        finally {
            DbConnectionManager.closeStatement(pstmt);
        }
    }
}

