/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.models;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class PresenceAccess
extends AccessModel {
    private static final Logger Log = LoggerFactory.getLogger(PresenceAccess.class);

    PresenceAccess() {
    }

    @Override
    public boolean canSubscribe(Node node, JID owner, JID subscriber) {
        if (node.isAdmin(owner)) {
            return true;
        }
        XMPPServer server = XMPPServer.getInstance();
        for (JID nodeOwner : node.getOwners()) {
            if (nodeOwner.equals((Object)owner)) {
                return true;
            }
            if (server.isLocal(nodeOwner)) {
                try {
                    Roster roster = server.getRosterManager().getRoster(nodeOwner.getNode());
                    RosterItem item = roster.getRosterItem(owner);
                    return item != null && (RosterItem.SUB_BOTH == item.getSubStatus() || RosterItem.SUB_FROM == item.getSubStatus());
                }
                catch (UserNotFoundException userNotFoundException) {
                    continue;
                }
            }
            Log.warn("Node with access model Presence has a remote user as owner: " + node.getNodeID());
        }
        return false;
    }

    @Override
    public boolean canAccessItems(Node node, JID owner, JID subscriber) {
        return this.canSubscribe(node, owner, subscriber);
    }

    @Override
    public String getName() {
        return "presence";
    }

    @Override
    public PacketError.Condition getSubsriptionError() {
        return PacketError.Condition.not_authorized;
    }

    @Override
    public Element getSubsriptionErrorDetail() {
        return DocumentHelper.createElement((QName)QName.get((String)"presence-subscription-required", (String)"http://jabber.org/protocol/pubsub#errors"));
    }

    @Override
    public boolean isAuthorizationRequired() {
        return false;
    }
}

