/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.cluster.NodeTask;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;

public abstract class SubscriptionTask
extends NodeTask {
    private String subId;
    private JID owner;
    private JID subJid;
    private NodeSubscription.State state;
    private transient NodeSubscription subscription;

    public SubscriptionTask() {
    }

    public SubscriptionTask(NodeSubscription subscription) {
        super(subscription.getNode());
        this.subId = subscription.getID();
        this.state = subscription.getState();
        this.owner = subscription.getOwner();
        this.subJid = subscription.getJID();
    }

    public String getSubscriptionId() {
        return this.subId;
    }

    public JID getOwner() {
        return this.owner;
    }

    public JID getSubscriberJid() {
        return this.subJid;
    }

    public NodeSubscription.State getState() {
        return this.state;
    }

    public NodeSubscription getSubscription() {
        if (this.subscription == null) {
            this.subscription = new NodeSubscription(this.getNode(), this.owner, this.subJid, this.state, this.subId);
        }
        return this.subscription;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.subId);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.owner);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.subJid);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((Object)this.state));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.subId = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.owner = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.subJid = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.state = (NodeSubscription.State)((Object)ExternalizableUtil.getInstance().readSerializable(in));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [(service=" + this.serviceId + "), (nodeId=" + this.nodeId + "), (owner=" + this.owner + "),(subscriber=" + this.subJid + "),(state=" + (Object)((Object)this.state) + "),(id=" + this.subId + ")]";
    }
}

