/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.cluster;

import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.cluster.SubscriptionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewSubscriptionTask
extends SubscriptionTask {
    private static final Logger log = LoggerFactory.getLogger(NewSubscriptionTask.class);

    public NewSubscriptionTask() {
    }

    public NewSubscriptionTask(NodeSubscription subscription) {
        super(subscription);
    }

    @Override
    public void run() {
        log.debug("[TASK] New subscription : {}", (Object)this.toString());
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        if (node.getAffiliate(this.getOwner()) == null) {
            NodeAffiliate affiliate = new NodeAffiliate(node, this.getOwner());
            affiliate.setAffiliation(NodeAffiliate.Affiliation.none);
            node.addAffiliate(affiliate);
        }
        node.addSubscription(this.getSubscription());
        if (node.isPresenceBasedDelivery() && node.getSubscriptions(this.getSubscription().getOwner()).size() == 1 && this.getSubscription().getPresenceStates().isEmpty()) {
            this.getService().presenceSubscriptionRequired(this.getNode(), this.getOwner());
        }
    }
}

