/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommandManager;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.DiscoServerItem;
import org.jivesoftware.openfire.disco.IQDiscoInfoHandler;
import org.jivesoftware.openfire.disco.IQDiscoItemsHandler;
import org.jivesoftware.openfire.disco.ServerItemsProvider;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.PendingSubscriptionsCommand;
import org.jivesoftware.openfire.pubsub.PubSubEngine;
import org.jivesoftware.openfire.pubsub.PubSubPersistenceManager;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.pubsub.models.PublisherModel;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class PubSubModule
extends BasicModule
implements ServerItemsProvider,
DiscoInfoProvider,
DiscoItemsProvider,
RoutableChannelHandler,
PubSubService,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(PubSubModule.class);
    private String serviceName = null;
    private CollectionNode rootCollectionNode = null;
    private Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Map<String, String>> barePresences = new ConcurrentHashMap<String, Map<String, String>>();
    private AdHocCommandManager manager;
    private boolean nodeCreationRestricted = false;
    private boolean multipleSubscriptionsEnabled = true;
    private Collection<String> allowedToCreate = new CopyOnWriteArrayList<String>();
    private Collection<String> sysadmins = new CopyOnWriteArrayList<String>();
    private PacketRouter router = null;
    private RoutingTable routingTable = null;
    private IQDiscoInfoHandler iqDiscoInfoHandler = null;
    private IQDiscoItemsHandler iqDiscoItemsHandler = null;
    private DefaultNodeConfiguration leafDefaultConfiguration;
    private DefaultNodeConfiguration collectionDefaultConfiguration;
    private PubSubEngine engine = null;
    private boolean serviceEnabled = true;

    public PubSubModule() {
        super("Publish Subscribe Service");
        this.manager = new AdHocCommandManager();
        this.manager.addCommand(new PendingSubscriptionsCommand(this));
    }

    @Override
    public void process(Packet packet) {
        block7: {
            try {
                if (packet instanceof IQ) {
                    if (!this.engine.process((PubSubService)this, (IQ)packet)) {
                        this.process((IQ)packet);
                    }
                } else if (packet instanceof Presence) {
                    this.engine.process((PubSubService)this, (Presence)packet);
                } else {
                    this.engine.process((PubSubService)this, (Message)packet);
                }
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                if (!(packet instanceof IQ)) break block7;
                IQ reply = IQ.createResultIQ((IQ)((IQ)packet));
                reply.setError(PacketError.Condition.internal_server_error);
                this.send((Packet)reply);
            }
        }
    }

    private void sendServiceUnavailablePacket(IQ iq) {
        this.engine.sendErrorPacket(iq, PacketError.Condition.service_unavailable, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    private void process(IQ iq) {
        if (IQ.Type.error == iq.getType()) {
            return;
        }
        Element childElement = iq.getChildElement();
        String namespace = null;
        if (childElement != null) {
            namespace = childElement.getNamespaceURI();
        }
        if ("http://jabber.org/protocol/disco#info".equals(namespace)) {
            if (this.iqDiscoInfoHandler != null) {
                IQ reply = this.iqDiscoInfoHandler.handleIQ(iq);
                this.router.route(reply);
                return;
            }
            this.sendServiceUnavailablePacket(iq);
            return;
        }
        if (!"http://jabber.org/protocol/disco#items".equals(namespace)) {
            this.sendServiceUnavailablePacket(iq);
            return;
        }
        if (this.iqDiscoItemsHandler != null) {
            IQ reply = this.iqDiscoItemsHandler.handleIQ(iq);
            this.router.route(reply);
            return;
        }
        this.sendServiceUnavailablePacket(iq);
    }

    @Override
    public String getServiceID() {
        return "pubsub";
    }

    @Override
    public boolean canCreateNode(JID creator) {
        return !this.isNodeCreationRestricted() || this.isServiceAdmin(creator);
    }

    @Override
    public boolean isServiceAdmin(JID user) {
        return this.sysadmins.contains(user.toBareJID()) || this.allowedToCreate.contains(user.toBareJID()) || InternalComponentManager.getInstance().hasComponent(user);
    }

    @Override
    public boolean isInstantNodeSupported() {
        return true;
    }

    @Override
    public boolean isCollectionNodesSupported() {
        return true;
    }

    @Override
    public CollectionNode getRootCollectionNode() {
        return this.rootCollectionNode;
    }

    @Override
    public DefaultNodeConfiguration getDefaultNodeConfiguration(boolean leafType) {
        if (leafType) {
            return this.leafDefaultConfiguration;
        }
        return this.collectionDefaultConfiguration;
    }

    @Override
    public Collection<String> getShowPresences(JID subscriber) {
        return PubSubEngine.getShowPresences(this, subscriber);
    }

    @Override
    public void presenceSubscriptionNotRequired(Node node, JID user) {
        PubSubEngine.presenceSubscriptionNotRequired(this, node, user);
    }

    @Override
    public void presenceSubscriptionRequired(Node node, JID user) {
        PubSubEngine.presenceSubscriptionRequired(this, node, user);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceDomain() {
        return this.serviceName + "." + XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    @Override
    public JID getAddress() {
        return new JID(null, this.getServiceDomain(), null);
    }

    public Collection<String> getUsersAllowedToCreate() {
        return this.allowedToCreate;
    }

    public Collection<String> getSysadmins() {
        return this.sysadmins;
    }

    public void setSysadmins(Collection<String> userJIDs) {
        this.sysadmins.clear();
        for (String JID2 : userJIDs) {
            this.sysadmins.add(JID2.trim().toLowerCase());
        }
        this.updateSysadminProperty();
    }

    public void addSysadmin(String userJID) {
        this.sysadmins.add(userJID.trim().toLowerCase());
        this.updateSysadminProperty();
    }

    public void removeSysadmin(String userJID) {
        this.sysadmins.remove(userJID.trim().toLowerCase());
        this.updateSysadminProperty();
    }

    private void updateSysadminProperty() {
        String[] jids = new String[this.sysadmins.size()];
        jids = this.sysadmins.toArray(jids);
        JiveGlobals.setProperty("xmpp.pubsub.sysadmin.jid", PubSubModule.fromArray(jids));
    }

    public boolean isNodeCreationRestricted() {
        return this.nodeCreationRestricted;
    }

    @Override
    public boolean isMultipleSubscriptionsEnabled() {
        return this.multipleSubscriptionsEnabled;
    }

    public void setNodeCreationRestricted(boolean nodeCreationRestricted) {
        this.nodeCreationRestricted = nodeCreationRestricted;
        JiveGlobals.setProperty("xmpp.pubsub.create.anyone", Boolean.toString(nodeCreationRestricted));
    }

    public void setUserAllowedToCreate(Collection<String> userJIDs) {
        this.allowedToCreate.clear();
        for (String JID2 : userJIDs) {
            this.allowedToCreate.add(JID2.trim().toLowerCase());
        }
        this.updateUserAllowedToCreateProperty();
    }

    public void addUserAllowedToCreate(String userJID) {
        this.allowedToCreate.add(userJID.trim().toLowerCase());
        this.updateUserAllowedToCreateProperty();
    }

    public void removeUserAllowedToCreate(String userJID) {
        this.allowedToCreate.remove(userJID.trim().toLowerCase());
        this.updateUserAllowedToCreateProperty();
    }

    private void updateUserAllowedToCreateProperty() {
        String[] jids = new String[this.allowedToCreate.size()];
        jids = this.allowedToCreate.toArray(jids);
        JiveGlobals.setProperty("xmpp.pubsub.create.jid", PubSubModule.fromArray(jids));
    }

    @Override
    public void initialize(XMPPServer server) {
        String[] jids;
        String property;
        super.initialize(server);
        JiveGlobals.migrateProperty("xmpp.pubsub.enabled");
        JiveGlobals.migrateProperty("xmpp.pubsub.service");
        JiveGlobals.migrateProperty("xmpp.pubsub.root.nodeID");
        JiveGlobals.migrateProperty("xmpp.pubsub.root.creator");
        JiveGlobals.migrateProperty("xmpp.pubsub.multiple-subscriptions");
        PropertyEventDispatcher.addListener(this);
        this.setIQDiscoItemsHandler(XMPPServer.getInstance().getIQDiscoItemsHandler());
        this.setIQDiscoInfoHandler(XMPPServer.getInstance().getIQDiscoInfoHandler());
        this.serviceEnabled = JiveGlobals.getBooleanProperty("xmpp.pubsub.enabled", true);
        this.serviceName = JiveGlobals.getProperty("xmpp.pubsub.service");
        if (this.serviceName == null) {
            this.serviceName = "pubsub";
        }
        if ((property = JiveGlobals.getProperty("xmpp.pubsub.sysadmin.jid")) != null && !property.isEmpty()) {
            for (String jid : jids = property.split(",")) {
                this.sysadmins.add(jid.trim().toLowerCase());
            }
        }
        this.nodeCreationRestricted = JiveGlobals.getBooleanProperty("xmpp.pubsub.create.anyone", false);
        property = JiveGlobals.getProperty("xmpp.pubsub.create.jid");
        if (property != null && !property.isEmpty()) {
            for (String jid : jids = property.split(",")) {
                this.allowedToCreate.add(jid.trim().toLowerCase());
            }
        }
        this.multipleSubscriptionsEnabled = JiveGlobals.getBooleanProperty("xmpp.pubsub.multiple-subscriptions", true);
        this.routingTable = server.getRoutingTable();
        this.router = server.getPacketRouter();
        this.engine = new PubSubEngine(this.router);
        this.leafDefaultConfiguration = PubSubPersistenceManager.loadDefaultConfiguration(this, true);
        if (this.leafDefaultConfiguration == null) {
            this.leafDefaultConfiguration = new DefaultNodeConfiguration(true);
            this.leafDefaultConfiguration.setAccessModel(AccessModel.open);
            this.leafDefaultConfiguration.setPublisherModel(PublisherModel.publishers);
            this.leafDefaultConfiguration.setDeliverPayloads(true);
            this.leafDefaultConfiguration.setLanguage("English");
            this.leafDefaultConfiguration.setMaxPayloadSize(5120);
            this.leafDefaultConfiguration.setNotifyConfigChanges(true);
            this.leafDefaultConfiguration.setNotifyDelete(true);
            this.leafDefaultConfiguration.setNotifyRetract(true);
            this.leafDefaultConfiguration.setPersistPublishedItems(false);
            this.leafDefaultConfiguration.setMaxPublishedItems(1);
            this.leafDefaultConfiguration.setPresenceBasedDelivery(false);
            this.leafDefaultConfiguration.setSendItemSubscribe(true);
            this.leafDefaultConfiguration.setSubscriptionEnabled(true);
            this.leafDefaultConfiguration.setReplyPolicy(null);
            PubSubPersistenceManager.createDefaultConfiguration(this, this.leafDefaultConfiguration);
        }
        this.collectionDefaultConfiguration = PubSubPersistenceManager.loadDefaultConfiguration(this, false);
        if (this.collectionDefaultConfiguration == null) {
            this.collectionDefaultConfiguration = new DefaultNodeConfiguration(false);
            this.collectionDefaultConfiguration.setAccessModel(AccessModel.open);
            this.collectionDefaultConfiguration.setPublisherModel(PublisherModel.publishers);
            this.collectionDefaultConfiguration.setDeliverPayloads(false);
            this.collectionDefaultConfiguration.setLanguage("English");
            this.collectionDefaultConfiguration.setNotifyConfigChanges(true);
            this.collectionDefaultConfiguration.setNotifyDelete(true);
            this.collectionDefaultConfiguration.setNotifyRetract(true);
            this.collectionDefaultConfiguration.setPresenceBasedDelivery(false);
            this.collectionDefaultConfiguration.setSubscriptionEnabled(true);
            this.collectionDefaultConfiguration.setReplyPolicy(null);
            this.collectionDefaultConfiguration.setAssociationPolicy(CollectionNode.LeafNodeAssociationPolicy.all);
            this.collectionDefaultConfiguration.setMaxLeafNodes(-1);
            PubSubPersistenceManager.createDefaultConfiguration(this, this.collectionDefaultConfiguration);
        }
        PubSubPersistenceManager.loadNodes(this);
        String rootNodeID = JiveGlobals.getProperty("xmpp.pubsub.root.nodeID", "");
        if (this.nodes.isEmpty()) {
            String creator = JiveGlobals.getProperty("xmpp.pubsub.root.creator");
            JID creatorJID = creator != null ? new JID(creator) : new JID(server.getServerInfo().getXMPPDomain());
            this.rootCollectionNode = new CollectionNode(this, null, rootNodeID, creatorJID);
            this.rootCollectionNode.addOwner(creatorJID);
            this.rootCollectionNode.saveToDB();
        } else {
            this.rootCollectionNode = (CollectionNode)this.getNode(rootNodeID);
        }
    }

    @Override
    public void start() {
        if (!this.isServiceEnabled()) {
            return;
        }
        super.start();
        this.routingTable.addComponentRoute(this.getAddress(), this);
        this.engine.start(this);
        ArrayList<String> params = new ArrayList<String>();
        params.clear();
        params.add(this.getServiceDomain());
        Log.info(LocaleUtils.getLocalizedString("startup.starting.pubsub", params));
    }

    @Override
    public void stop() {
        super.stop();
        this.routingTable.removeComponentRoute(this.getAddress());
        this.engine.shutdown(this);
    }

    public void setIQDiscoItemsHandler(IQDiscoItemsHandler iqDiscoItemsHandler) {
        this.iqDiscoItemsHandler = iqDiscoItemsHandler;
    }

    public void setIQDiscoInfoHandler(IQDiscoInfoHandler iqDiscoInfoHandler) {
        this.iqDiscoInfoHandler = iqDiscoInfoHandler;
    }

    private void enableService(boolean enabled) {
        if (this.serviceEnabled == enabled) {
            return;
        }
        if (!enabled) {
            if (this.iqDiscoItemsHandler != null) {
                this.iqDiscoItemsHandler.removeServerItemsProvider(this);
            }
            this.stop();
        }
        this.serviceEnabled = enabled;
        if (enabled) {
            this.start();
            if (this.iqDiscoItemsHandler != null) {
                this.iqDiscoItemsHandler.addServerItemsProvider(this);
            }
        }
    }

    public void setServiceEnabled(boolean enabled) {
        this.enableService(enabled);
        JiveGlobals.setProperty("xmpp.pubsub.enabled", Boolean.toString(enabled));
    }

    public boolean isServiceEnabled() {
        return this.serviceEnabled;
    }

    public void markedAsSeniorClusterMember() {
    }

    @Override
    public Iterator<DiscoServerItem> getItems() {
        if (!this.isServiceEnabled()) {
            return null;
        }
        ArrayList<DiscoServerItem> items = new ArrayList<DiscoServerItem>();
        DiscoServerItem item = new DiscoServerItem(new JID(this.getServiceDomain()), "Publish-Subscribe service", null, null, this, this);
        items.add(item);
        return items.iterator();
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        Node pubNode;
        ArrayList<Element> identities = new ArrayList<Element>();
        if (name == null && node == null) {
            Element identity = DocumentHelper.createElement((String)"identity");
            identity.addAttribute("category", "pubsub");
            identity.addAttribute("name", "Publish-Subscribe service");
            identity.addAttribute("type", "service");
            identities.add(identity);
        } else if (name == null && this.canDiscoverNode(pubNode = this.getNode(node))) {
            Element identity = DocumentHelper.createElement((String)"identity");
            identity.addAttribute("category", "pubsub");
            identity.addAttribute("type", pubNode.isCollectionNode() ? "collection" : "leaf");
            identities.add(identity);
        }
        return identities.iterator();
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        Node pubNode;
        ArrayList<String> features = new ArrayList<String>();
        if (name == null && node == null) {
            features.add("http://jabber.org/protocol/pubsub");
            String modelName = this.getDefaultNodeConfiguration(true).getAccessModel().getName();
            features.add("http://jabber.org/protocol/pubsub#access-" + modelName);
            if (this.isCollectionNodesSupported()) {
                features.add("http://jabber.org/protocol/pubsub#collections");
            }
            features.add("http://jabber.org/protocol/pubsub#config-node");
            features.add("http://jabber.org/protocol/pubsub#create-and-configure");
            features.add("http://jabber.org/protocol/pubsub#create-nodes");
            features.add("http://jabber.org/protocol/pubsub#delete-nodes");
            features.add("http://jabber.org/protocol/pubsub#get-pending");
            if (this.isInstantNodeSupported()) {
                features.add("http://jabber.org/protocol/pubsub#instant-nodes");
            }
            features.add("http://jabber.org/protocol/pubsub#item-ids");
            features.add("http://jabber.org/protocol/pubsub#meta-data");
            features.add("http://jabber.org/protocol/pubsub#modify-affiliations");
            features.add("http://jabber.org/protocol/pubsub#manage-subscriptions");
            features.add("http://jabber.org/protocol/pubsub#multi-subscribe");
            features.add("http://jabber.org/protocol/pubsub#outcast-affiliation");
            features.add("http://jabber.org/protocol/pubsub#persistent-items");
            features.add("http://jabber.org/protocol/pubsub#presence-notifications");
            features.add("http://jabber.org/protocol/pubsub#publish");
            features.add("http://jabber.org/protocol/pubsub#publisher-affiliation");
            features.add("http://jabber.org/protocol/pubsub#purge-nodes");
            features.add("http://jabber.org/protocol/pubsub#retract-items");
            features.add("http://jabber.org/protocol/pubsub#retrieve-affiliations");
            features.add("http://jabber.org/protocol/pubsub#retrieve-default");
            features.add("http://jabber.org/protocol/pubsub#retrieve-items");
            features.add("http://jabber.org/protocol/pubsub#retrieve-subscriptions");
            features.add("http://jabber.org/protocol/pubsub#subscribe");
            features.add("http://jabber.org/protocol/pubsub#subscription-options");
        } else if (name == null && this.canDiscoverNode(pubNode = this.getNode(node))) {
            features.add("http://jabber.org/protocol/pubsub");
        }
        return features.iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        Node pubNode;
        if (name == null && node != null && this.canDiscoverNode(pubNode = this.getNode(node))) {
            return pubNode.getMetadataForm();
        }
        return null;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        if (!this.isServiceEnabled()) {
            return false;
        }
        if (name == null && node == null) {
            return true;
        }
        if (name == null) {
            return this.hasNode(node);
        }
        return false;
    }

    @Override
    public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
        if (!this.isServiceEnabled()) {
            return null;
        }
        ArrayList<DiscoItem> answer = new ArrayList<DiscoItem>();
        String serviceDomain = this.getServiceDomain();
        if (name == null && node == null) {
            for (Node pubNode : this.rootCollectionNode.getNodes()) {
                if (!this.canDiscoverNode(pubNode)) continue;
                DiscoItem item = new DiscoItem(new JID(serviceDomain), pubNode.getName(), pubNode.getNodeID(), null);
                answer.add(item);
            }
        } else if (name == null) {
            Node pubNode = this.getNode(node);
            if (pubNode != null && this.canDiscoverNode(pubNode)) {
                if (pubNode.isCollectionNode()) {
                    for (Node nestedNode : pubNode.getNodes()) {
                        if (!this.canDiscoverNode(nestedNode)) continue;
                        DiscoItem item = new DiscoItem(new JID(serviceDomain), nestedNode.getName(), nestedNode.getNodeID(), null);
                        answer.add(item);
                    }
                } else {
                    for (PublishedItem publishedItem : pubNode.getPublishedItems()) {
                        answer.add(new DiscoItem(new JID(serviceDomain), publishedItem.getID(), null, null));
                    }
                }
            } else {
                return null;
            }
        }
        return answer.iterator();
    }

    @Override
    public void broadcast(Node node, Message message, Collection<JID> jids) {
        message.setFrom(this.getAddress());
        for (JID jid : jids) {
            message.setTo(jid);
            message.setID(StringUtils.randomString(8));
            this.router.route(message);
        }
    }

    @Override
    public void send(Packet packet) {
        this.router.route(packet);
    }

    @Override
    public void sendNotification(Node node, Message message, JID jid) {
        message.setFrom(this.getAddress());
        message.setTo(jid);
        message.setID(StringUtils.randomString(8));
        this.router.route(message);
    }

    @Override
    public Node getNode(String nodeID) {
        return this.nodes.get(nodeID);
    }

    @Override
    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    private boolean hasNode(String nodeID) {
        return this.getNode(nodeID) != null;
    }

    @Override
    public void addNode(Node node) {
        this.nodes.put(node.getNodeID(), node);
    }

    @Override
    public void removeNode(String nodeID) {
        this.nodes.remove(nodeID);
    }

    private boolean canDiscoverNode(Node pubNode) {
        return true;
    }

    private static String fromArray(String[] array) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]);
            if (i == array.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public Map<String, Map<String, String>> getBarePresences() {
        return this.barePresences;
    }

    @Override
    public AdHocCommandManager getManager() {
        return this.manager;
    }

    @Override
    public void propertySet(String property, Map<String, Object> params) {
        if (property.equals("xmpp.pubsub.enabled")) {
            boolean enabled = Boolean.parseBoolean((String)params.get("value"));
            this.enableService(enabled);
        }
    }

    @Override
    public void propertyDeleted(String property, Map<String, Object> params) {
        if (property.equals("xmpp.pubsub.enabled")) {
            this.enableService(true);
        }
    }

    @Override
    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    @Override
    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }
}

