/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.nio;

import org.apache.mina.core.session.IoSession;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.net.ServerStanzaHandler;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.nio.ConnectionHandler;
import org.jivesoftware.openfire.nio.NIOConnection;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.util.JiveGlobals;

public class ServerConnectionHandler
extends ConnectionHandler {
    public ServerConnectionHandler(ConnectionConfiguration configuration) {
        super(configuration);
    }

    @Override
    NIOConnection createNIOConnection(IoSession session) {
        return new NIOConnection(session, XMPPServer.getInstance().getPacketDeliverer(), this.configuration);
    }

    @Override
    StanzaHandler createStanzaHandler(NIOConnection connection) {
        return new ServerStanzaHandler(XMPPServer.getInstance().getPacketRouter(), connection);
    }

    @Override
    int getMaxIdleTime() {
        return JiveGlobals.getIntProperty("xmpp.server.idle", 360000) / 1000;
    }
}

