/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.AuthorizationManager;
import org.jivesoftware.openfire.sasl.VerifyPasswordCallback;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMPPCallbackHandler
implements CallbackHandler {
    private static final Logger Log = LoggerFactory.getLogger(XMPPCallbackHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String name = null;
        for (Callback callback : callbacks) {
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
                continue;
            }
            if (callback instanceof NameCallback) {
                name = ((NameCallback)callback).getName();
                if (name != null) continue;
                name = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                try {
                    ((PasswordCallback)callback).setPassword(AuthFactory.getPassword(name).toCharArray());
                    continue;
                }
                catch (UnsupportedOperationException | UserNotFoundException e) {
                    throw new IOException(e.toString());
                }
            }
            if (callback instanceof VerifyPasswordCallback) {
                VerifyPasswordCallback vpcb = (VerifyPasswordCallback)callback;
                try {
                    AuthToken at = AuthFactory.authenticate(name, new String(vpcb.getPassword()));
                    vpcb.setVerified(at != null);
                }
                catch (Exception e) {
                    vpcb.setVerified(false);
                }
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback authCallback = (AuthorizeCallback)callback;
                String principal = authCallback.getAuthenticationID();
                String username = authCallback.getAuthorizationID();
                if (username != null && username.contains("@")) {
                    username = username.substring(0, username.lastIndexOf("@"));
                }
                if (principal.equals(username)) {
                    username = AuthorizationManager.map(principal);
                    if (Log.isDebugEnabled()) {
                        // empty if block
                    }
                }
                if (AuthorizationManager.authorize(username, principal)) {
                    if (Log.isDebugEnabled()) {
                        // empty if block
                    }
                    authCallback.setAuthorized(true);
                    authCallback.setAuthorizedID(username);
                    continue;
                }
                if (Log.isDebugEnabled()) {
                    // empty if block
                }
                authCallback.setAuthorized(false);
                continue;
            }
            if (Log.isDebugEnabled()) {
                // empty if block
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }
}

