/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.net.TLSStatus;
import org.jivesoftware.openfire.net.TLSWrapper;

public class TLSStreamReader {
    private TLSWrapper wrapper;
    private ReadableByteChannel rbc;
    private ByteBuffer inNetBB;
    private ByteBuffer inAppBB;
    private TLSStatus lastStatus;

    public TLSStreamReader(TLSWrapper tlsWrapper, Socket socket) throws IOException {
        this.wrapper = tlsWrapper;
        this.rbc = socket.getChannel() != null ? ServerTrafficCounter.wrapReadableChannel(socket.getChannel()) : Channels.newChannel(ServerTrafficCounter.wrapInputStream(socket.getInputStream()));
        this.inNetBB = ByteBuffer.allocate(this.wrapper.getNetBuffSize());
        this.inAppBB = ByteBuffer.allocate(this.wrapper.getAppBuffSize());
    }

    private void doRead() throws IOException {
        int cnt = this.rbc.read(this.inNetBB);
        if (cnt > 0) {
            this.inAppBB = this.decrypt(this.inNetBB, this.inAppBB);
            if (this.lastStatus == TLSStatus.OK) {
                this.inAppBB.flip();
            } else {
                this.doRead();
            }
        } else if (cnt == -1) {
            this.inAppBB.flip();
            this.rbc.close();
        }
    }

    private ByteBuffer decrypt(ByteBuffer input, ByteBuffer output) throws IOException {
        ByteBuffer out = output;
        input.flip();
        do {
            out = this.wrapper.unwrap(input, out);
            this.lastStatus = this.wrapper.getStatus();
        } while ((this.lastStatus == TLSStatus.NEED_READ || this.lastStatus == TLSStatus.OK) && input.hasRemaining());
        if (input.hasRemaining()) {
            input.compact();
        } else {
            input.clear();
        }
        return out;
    }

    public InputStream getInputStream() {
        return this.createInputStream();
    }

    private InputStream createInputStream() {
        return new InputStream(){

            @Override
            public synchronized int read() throws IOException {
                TLSStreamReader.this.doRead();
                if (!TLSStreamReader.this.inAppBB.hasRemaining()) {
                    return -1;
                }
                return TLSStreamReader.this.inAppBB.get();
            }

            @Override
            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                if (TLSStreamReader.this.inAppBB.position() == 0) {
                    TLSStreamReader.this.doRead();
                } else {
                    TLSStreamReader.this.inAppBB.flip();
                }
                len = Math.min(len, TLSStreamReader.this.inAppBB.remaining());
                if (len == 0) {
                    return -1;
                }
                TLSStreamReader.this.inAppBB.get(bytes, off, len);
                if (TLSStreamReader.this.inAppBB.hasRemaining()) {
                    TLSStreamReader.this.inAppBB.compact();
                } else {
                    TLSStreamReader.this.inAppBB.clear();
                }
                return len;
            }
        };
    }
}

