/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.io.StringReader;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.StreamIDFactory;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.http.FlashCrossDomainServlet;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.BasicStreamIDFactory;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;
import org.xmpp.packet.StreamError;

public abstract class StanzaHandler {
    private static final Logger Log = LoggerFactory.getLogger(StanzaHandler.class);
    private static final StreamIDFactory STREAM_ID_FACTORY = new BasicStreamIDFactory();
    protected static String CHARSET = "UTF-8";
    protected Connection connection;
    private boolean sessionCreated = false;
    private boolean startedTLS = false;
    private boolean startedSASL = false;
    private SASLAuthentication.Status saslStatus;
    private boolean waitingCompressionACK = false;
    protected LocalSession session;
    private PacketRouter router;

    public StanzaHandler(PacketRouter router, Connection connection) {
        this.router = router;
        this.connection = connection;
    }

    @Deprecated
    public StanzaHandler(PacketRouter router, String serverName, Connection connection) {
        this.router = router;
        this.connection = connection;
    }

    public void setSession(LocalSession session) {
        this.session = session;
    }

    public void process(String stanza, XMPPPacketReader reader) throws Exception {
        boolean initialStream;
        boolean bl = initialStream = stanza.startsWith("<stream:stream") || stanza.startsWith("<flash:stream");
        if (!this.sessionCreated || initialStream) {
            if (!initialStream) {
                if (stanza.startsWith("<policy-file-request/>")) {
                    String crossDomainText = FlashCrossDomainServlet.CROSS_DOMAIN_TEXT + XMPPServer.getInstance().getConnectionManager().getClientListenerPort() + FlashCrossDomainServlet.CROSS_DOMAIN_END_TEXT + '\u0000';
                    this.connection.deliverRawText(crossDomainText);
                    return;
                }
                return;
            }
            if (!this.sessionCreated) {
                this.sessionCreated = true;
                MXParser parser = reader.getXPPParser();
                parser.setInput(new StringReader(stanza));
                this.createSession((XmlPullParser)parser);
            } else if (this.startedTLS) {
                this.startedTLS = false;
                this.tlsNegotiated();
            } else if (this.startedSASL && this.saslStatus == SASLAuthentication.Status.authenticated) {
                this.startedSASL = false;
                this.saslSuccessful();
            } else if (this.waitingCompressionACK) {
                this.waitingCompressionACK = false;
                this.compressionSuccessful();
            }
            return;
        }
        if (stanza.equals("</stream:stream>")) {
            if (this.session != null) {
                this.session.getStreamManager().formalClose();
                this.session.close();
            }
            return;
        }
        if (stanza.startsWith("<?xml")) {
            return;
        }
        Element doc = reader.read(new StringReader(stanza)).getRootElement();
        if (doc == null) {
            return;
        }
        String tag = doc.getName();
        if ("starttls".equals(tag)) {
            if (this.negotiateTLS()) {
                this.startedTLS = true;
            } else {
                this.connection.close();
                this.session = null;
            }
        } else if ("auth".equals(tag)) {
            this.startedSASL = true;
            this.saslStatus = SASLAuthentication.handle(this.session, doc);
        } else if (this.startedSASL && "response".equals(tag) || "abort".equals(tag)) {
            this.saslStatus = SASLAuthentication.handle(this.session, doc);
        } else if ("compress".equals(tag)) {
            if (this.compressClient(doc)) {
                this.waitingCompressionACK = true;
            }
        } else if (this.isStreamManagementStanza(doc)) {
            this.session.getStreamManager().process(doc);
        } else {
            this.process(doc);
        }
    }

    private void process(Element doc) throws UnauthorizedException {
        if (doc == null) {
            return;
        }
        if (this.connection.getTlsPolicy() == Connection.TLSPolicy.required && !this.connection.isSecure()) {
            this.closeNeverSecuredConnection();
            return;
        }
        String tag = doc.getName();
        if ("message".equals(tag)) {
            Message packet;
            try {
                packet = new Message(doc, !this.validateJIDs());
            }
            catch (IllegalArgumentException e) {
                Log.debug("Rejecting packet. JID malformed", (Throwable)e);
                Message reply = new Message();
                reply.setID(doc.attributeValue("id"));
                reply.setTo(this.session.getAddress());
                reply.getElement().addAttribute("from", doc.attributeValue("to"));
                reply.setError(PacketError.Condition.jid_malformed);
                this.session.process((Packet)reply);
                return;
            }
            this.processMessage(packet);
        } else if ("presence".equals(tag)) {
            Presence packet;
            try {
                packet = new Presence(doc, !this.validateJIDs());
            }
            catch (IllegalArgumentException e) {
                Log.debug("Rejecting packet. JID malformed", (Throwable)e);
                Presence reply = new Presence();
                reply.setID(doc.attributeValue("id"));
                reply.setTo(this.session.getAddress());
                reply.getElement().addAttribute("from", doc.attributeValue("to"));
                reply.setError(PacketError.Condition.jid_malformed);
                this.session.process((Packet)reply);
                return;
            }
            try {
                packet.getType();
            }
            catch (IllegalArgumentException e) {
                Log.warn("Invalid presence type", (Throwable)e);
                packet.setType(null);
            }
            try {
                packet.getShow();
            }
            catch (IllegalArgumentException e) {
                Log.debug("Invalid presence show for -" + packet.toXML(), (Throwable)e);
                packet.setShow(null);
            }
            if (this.session.getStatus() == -1 && packet.isAvailable()) {
                Log.warn("Ignoring available presence packet of closed session: " + packet);
                return;
            }
            this.processPresence(packet);
        } else if ("iq".equals(tag)) {
            IQ packet;
            try {
                packet = this.getIQ(doc);
            }
            catch (IllegalArgumentException e) {
                Log.debug("Rejecting packet. JID malformed", (Throwable)e);
                IQ reply = new IQ();
                if (!doc.elements().isEmpty()) {
                    reply.setChildElement(((Element)doc.elements().get(0)).createCopy());
                }
                reply.setID(doc.attributeValue("id"));
                reply.setTo(this.session.getAddress());
                if (doc.attributeValue("to") != null) {
                    reply.getElement().addAttribute("from", doc.attributeValue("to"));
                }
                reply.setError(PacketError.Condition.jid_malformed);
                this.session.process((Packet)reply);
                return;
            }
            if (packet.getID() == null && JiveGlobals.getBooleanProperty("xmpp.server.validation.enabled", false)) {
                StreamError error = new StreamError(StreamError.Condition.invalid_xml);
                this.session.deliverRawText(error.toXML());
                this.session.close();
                return;
            }
            this.processIQ(packet);
        } else if (!this.processUnknowPacket(doc)) {
            Log.warn(LocaleUtils.getLocalizedString("admin.error.packet.tag") + doc.asXML());
            this.session.close();
        }
    }

    private IQ getIQ(Element doc) {
        Element query = doc.element("query");
        if (query != null && "jabber:iq:roster".equals(query.getNamespaceURI())) {
            return new Roster(doc);
        }
        return new IQ(doc, !this.validateJIDs());
    }

    protected void processIQ(IQ packet) throws UnauthorizedException {
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    protected void processPresence(Presence packet) throws UnauthorizedException {
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    protected void processMessage(Message packet) throws UnauthorizedException {
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    abstract boolean processUnknowPacket(Element var1) throws UnauthorizedException;

    private boolean negotiateTLS() {
        if (this.connection.getTlsPolicy() == Connection.TLSPolicy.disabled) {
            StreamError error = new StreamError(StreamError.Condition.not_authorized);
            this.connection.deliverRawText(error.toXML());
            this.connection.close();
            Log.warn("TLS requested by initiator when TLS was never offered by server. Closing connection : " + this.connection);
            return false;
        }
        try {
            this.startTLS();
        }
        catch (Exception e) {
            Log.error("Error while negotiating TLS", (Throwable)e);
            this.connection.deliverRawText("<failure xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.connection.close();
            return false;
        }
        return true;
    }

    abstract void startTLS() throws Exception;

    private void tlsNegotiated() {
        StringBuilder sb = new StringBuilder(620);
        sb.append(this.getStreamHeader());
        sb.append("<stream:features>");
        sb.append(SASLAuthentication.getSASLMechanisms(this.session));
        String specificFeatures = this.session.getAvailableStreamFeatures();
        if (specificFeatures != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        this.connection.deliverRawText(sb.toString());
    }

    private void saslSuccessful() {
        StringBuilder sb = new StringBuilder(420);
        sb.append(this.getStreamHeader());
        sb.append("<stream:features>");
        String specificFeatures = this.session.getAvailableStreamFeatures();
        if (specificFeatures != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        this.connection.deliverRawText(sb.toString());
    }

    private boolean compressClient(Element doc) {
        String error = null;
        if (this.connection.getCompressionPolicy() == Connection.CompressionPolicy.disabled) {
            error = "<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/></failure>";
            Log.warn("Client requested compression while compression is disabled. Closing connection : " + this.connection);
        } else if (this.connection.isCompressed()) {
            error = "<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/></failure>";
            Log.warn("Client requested compression and connection is already compressed. Closing connection : " + this.connection);
        } else {
            String method = doc.elementText("method");
            if (!"zlib".equals(method)) {
                error = "<failure xmlns='http://jabber.org/protocol/compress'><unsupported-method/></failure>";
                Log.warn("Requested compression method is not supported: " + method + ". Closing connection : " + this.connection);
            }
        }
        if (error != null) {
            this.connection.deliverRawText(error);
            return false;
        }
        this.connection.addCompression();
        this.connection.deliverRawText("<compressed xmlns='http://jabber.org/protocol/compress'/>");
        this.connection.startCompression();
        return true;
    }

    private void compressionSuccessful() {
        String specificFeatures;
        StringBuilder sb = new StringBuilder(340);
        sb.append(this.getStreamHeader());
        sb.append("<stream:features>");
        if (this.session.getStatus() != 3) {
            sb.append(SASLAuthentication.getSASLMechanisms(this.session));
        }
        if ((specificFeatures = this.session.getAvailableStreamFeatures()) != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        this.connection.deliverRawText(sb.toString());
    }

    private boolean isStreamManagementStanza(Element stanza) {
        return "urn:xmpp:sm:2".equals(stanza.getNamespace().getStringValue()) || "urn:xmpp:sm:3".equals(stanza.getNamespace().getStringValue());
    }

    private String getStreamHeader() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("<?xml version='1.0' encoding='");
        sb.append(CHARSET);
        sb.append("'?>");
        if (this.connection.isFlashClient()) {
            sb.append("<flash:stream xmlns:flash=\"http://www.jabber.com/streams/flash\" ");
        } else {
            sb.append("<stream:stream ");
        }
        sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"");
        sb.append(this.getNamespace());
        sb.append("\" from=\"");
        sb.append(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
        sb.append("\" id=\"");
        sb.append(this.session.getStreamID());
        sb.append("\" xml:lang=\"");
        sb.append(this.session.getLanguage().toLanguageTag());
        sb.append("\" version=\"");
        sb.append(1).append('.').append(0);
        sb.append("\">");
        return sb.toString();
    }

    void closeNeverSecuredConnection() {
        StreamError error = new StreamError(StreamError.Condition.not_authorized);
        this.connection.deliverRawText(error.toXML());
        this.connection.close();
        Log.warn("TLS was required by the server and connection was never secured. Closing connection : " + this.connection);
    }

    protected void createSession(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        while (eventType != 2) {
            eventType = xpp.next();
        }
        String serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        String host = xpp.getAttributeValue("", "to");
        StreamError streamError = null;
        if (this.validateHost() && this.isHostUnknown(host)) {
            streamError = new StreamError(StreamError.Condition.host_unknown);
            Log.warn("Closing session due to incorrect hostname in stream header. Host: " + host + ". Connection: " + this.connection);
        } else if (!"http://etherx.jabber.org/streams".equals(xpp.getNamespace()) && !"http://www.jabber.com/streams/flash".equals(xpp.getNamespace())) {
            streamError = new StreamError(StreamError.Condition.invalid_namespace);
            Log.warn("Closing session due to invalid namespace in stream header. Namespace: " + xpp.getNamespace() + ". Connection: " + this.connection);
        } else if (!this.createSession(xpp.getNamespace(null), serverName, xpp, this.connection)) {
            streamError = new StreamError(StreamError.Condition.invalid_namespace);
            Log.warn("Closing session due to invalid namespace in stream header. Prefix: " + xpp.getNamespace(null) + ". Connection: " + this.connection);
        }
        if (streamError != null) {
            StringBuilder sb = new StringBuilder(250);
            if (host == null) {
                host = serverName;
            }
            sb.append("<?xml version='1.0' encoding='");
            sb.append(CHARSET);
            sb.append("'?>");
            sb.append("<stream:stream ");
            sb.append("from=\"").append(host).append("\" ");
            sb.append("id=\"").append(STREAM_ID_FACTORY.createStreamID()).append("\" ");
            sb.append("xmlns=\"").append(xpp.getNamespace(null)).append("\" ");
            sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" ");
            sb.append("version=\"1.0\">");
            sb.append(streamError.toXML());
            this.connection.deliverRawText(sb.toString());
            this.connection.close();
        }
    }

    private boolean isHostUnknown(String host) {
        if (host == null) {
            return false;
        }
        return !XMPPServer.getInstance().getServerInfo().getXMPPDomain().equals(host);
    }

    public JID getAddress() {
        if (this.session == null) {
            return null;
        }
        return this.session.getAddress();
    }

    abstract String getNamespace();

    abstract boolean validateHost();

    abstract boolean validateJIDs();

    abstract boolean createSession(String var1, String var2, XmlPullParser var3, Connection var4) throws XmlPullParserException;
}

