/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.util.Date;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StalledSessionsFilter
extends IoFilterAdapter {
    private static final Logger Log = LoggerFactory.getLogger(StalledSessionsFilter.class);
    private static final int bytesCap = JiveGlobals.getIntProperty("session.stalled.cap", 0x500000);

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        long pendingBytes;
        if (!session.isClosing() && (pendingBytes = session.getScheduledWriteBytes()) > (long)bytesCap) {
            long writeTime = session.getLastWriteTime();
            int pendingRequests = session.getScheduledWriteMessages();
            Log.debug("About to kill session with pendingBytes: " + pendingBytes + " pendingWrites: " + pendingRequests + " lastWrite: " + new Date(writeTime) + "session: " + session);
            session.close(false);
            throw new IOException("Closing session that seems to be stalled. Preventing OOM");
        }
        super.filterWrite(nextFilter, session, writeRequest);
    }
}

