/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.openfire.stats.StatisticsManager;
import org.jivesoftware.util.LocaleUtils;

public class ServerTrafficCounter {
    private static final AtomicLong outgoingCounter = new AtomicLong(0L);
    private static final AtomicLong incomingCounter = new AtomicLong(0L);
    private static final String trafficStatGroup = "server_bytes";
    private static final String incomingStatKey = "server_bytes_in";
    private static final String outgoingStatKey = "server_bytes_out";

    public static void initStatistics() {
        ServerTrafficCounter.addReadBytesStat();
        ServerTrafficCounter.addWrittenBytesStat();
    }

    public static InputStream wrapInputStream(InputStream originalStream) {
        return new InputStreamWrapper(originalStream);
    }

    public static OutputStream wrapOutputStream(OutputStream originalStream) {
        return new OutputStreamWrapper(originalStream);
    }

    public static ReadableByteChannel wrapReadableChannel(ReadableByteChannel originalChannel) {
        return new ReadableByteChannelWrapper(originalChannel);
    }

    public static WritableByteChannel wrapWritableChannel(WritableByteChannel originalChannel) {
        return new WritableByteChannelWrapper(originalChannel);
    }

    public static void incrementIncomingCounter(long delta) {
        incomingCounter.getAndAdd(delta);
    }

    public static void incrementOutgoingCounter(long delta) {
        outgoingCounter.getAndAdd(delta);
    }

    private static void addReadBytesStat() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("server_bytes.stats.incoming.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.rate;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("server_bytes.stats.incoming.description");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("server_bytes.stats.incoming.label");
            }

            @Override
            public double sample() {
                return (double)incomingCounter.getAndSet(0L) / 1024.0;
            }

            @Override
            public boolean isPartialSample() {
                return true;
            }
        };
        StatisticsManager.getInstance().addMultiStatistic(incomingStatKey, trafficStatGroup, statistic);
    }

    private static void addWrittenBytesStat() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("server_bytes.stats.outgoing.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.rate;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("server_bytes.stats.outgoing.description");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("server_bytes.stats.outgoing.label");
            }

            @Override
            public double sample() {
                return (double)outgoingCounter.getAndSet(0L) / 1024.0;
            }

            @Override
            public boolean isPartialSample() {
                return true;
            }
        };
        StatisticsManager.getInstance().addMultiStatistic(outgoingStatKey, trafficStatGroup, statistic);
    }

    private static class WritableByteChannelWrapper
    implements WritableByteChannel {
        private WritableByteChannel originalChannel;

        public WritableByteChannelWrapper(WritableByteChannel originalChannel) {
            this.originalChannel = originalChannel;
        }

        @Override
        public void close() throws IOException {
            this.originalChannel.close();
        }

        @Override
        public boolean isOpen() {
            return this.originalChannel.isOpen();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int bytes = this.originalChannel.write(src);
            ServerTrafficCounter.incrementOutgoingCounter(bytes);
            return bytes;
        }
    }

    private static class ReadableByteChannelWrapper
    implements ReadableByteChannel {
        private ReadableByteChannel originalChannel;

        public ReadableByteChannelWrapper(ReadableByteChannel originalChannel) {
            this.originalChannel = originalChannel;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int bytes = this.originalChannel.read(dst);
            if (bytes > -1) {
                ServerTrafficCounter.incrementIncomingCounter(bytes);
            }
            return bytes;
        }

        @Override
        public void close() throws IOException {
            this.originalChannel.close();
        }

        @Override
        public boolean isOpen() {
            return this.originalChannel.isOpen();
        }
    }

    private static class OutputStreamWrapper
    extends OutputStream {
        private OutputStream originalStream;

        public OutputStreamWrapper(OutputStream originalStream) {
            this.originalStream = originalStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.originalStream.write(b);
            ServerTrafficCounter.incrementOutgoingCounter(1L);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.originalStream.write(b);
            ServerTrafficCounter.incrementOutgoingCounter(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.originalStream.write(b, off, len);
            ServerTrafficCounter.incrementOutgoingCounter(b.length);
        }

        @Override
        public void close() throws IOException {
            this.originalStream.close();
        }

        @Override
        public void flush() throws IOException {
            this.originalStream.flush();
        }
    }

    private static class InputStreamWrapper
    extends InputStream {
        private InputStream originalStream;

        public InputStreamWrapper(InputStream originalStream) {
            this.originalStream = originalStream;
        }

        @Override
        public int read() throws IOException {
            int readByte = this.originalStream.read();
            if (readByte > -1) {
                ServerTrafficCounter.incrementIncomingCounter(1L);
            }
            return readByte;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int bytes = this.originalStream.read(b);
            if (bytes > -1) {
                ServerTrafficCounter.incrementIncomingCounter(bytes);
            }
            return bytes;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytes = this.originalStream.read(b, off, len);
            if (bytes > -1) {
                ServerTrafficCounter.incrementIncomingCounter(bytes);
            }
            return bytes;
        }

        @Override
        public int available() throws IOException {
            return this.originalStream.available();
        }

        @Override
        public void close() throws IOException {
            this.originalStream.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.originalStream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.originalStream.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.originalStream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.originalStream.skip(n);
        }
    }
}

