/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import org.dom4j.Element;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.StreamError;

public class ServerStanzaHandler
extends StanzaHandler {
    private static final Logger Log = LoggerFactory.getLogger(ServerStanzaHandler.class);

    public ServerStanzaHandler(PacketRouter router, Connection connection) {
        super(router, connection);
    }

    @Deprecated
    public ServerStanzaHandler(PacketRouter router, String serverName, Connection connection) {
        super(router, connection);
    }

    @Override
    boolean processUnknowPacket(Element doc) throws UnauthorizedException {
        if ("db".equals(doc.getNamespacePrefix()) && "result".equals(doc.getName())) {
            if (!((LocalIncomingServerSession)this.session).validateSubsequentDomain(doc)) {
                throw new UnauthorizedException("Failed to validate domain when using piggyback.");
            }
            return true;
        }
        if ("db".equals(doc.getNamespacePrefix()) && "verify".equals(doc.getName())) {
            ((LocalIncomingServerSession)this.session).verifyReceivedKey(doc);
            return true;
        }
        return false;
    }

    @Override
    String getNamespace() {
        return "jabber:server";
    }

    @Override
    boolean validateHost() {
        return true;
    }

    @Override
    boolean validateJIDs() {
        return false;
    }

    @Override
    boolean createSession(String namespace, String serverName, XmlPullParser xpp, Connection connection) throws XmlPullParserException {
        return false;
    }

    @Override
    void startTLS() throws Exception {
        boolean needed = JiveGlobals.getBooleanProperty("xmpp.server.certificate.verify", true) && JiveGlobals.getBooleanProperty("xmpp.server.certificate.verify.chain", true) && !JiveGlobals.getBooleanProperty("xmpp.server.certificate.accept-selfsigned", false);
        this.connection.startTLS(false);
    }

    @Override
    protected void processIQ(IQ packet) throws UnauthorizedException {
        this.packetReceived((Packet)packet);
        super.processIQ(packet);
    }

    @Override
    protected void processPresence(Presence packet) throws UnauthorizedException {
        this.packetReceived((Packet)packet);
        super.processPresence(packet);
    }

    @Override
    protected void processMessage(Message packet) throws UnauthorizedException {
        this.packetReceived((Packet)packet);
        super.processMessage(packet);
    }

    private void packetReceived(Packet packet) throws UnauthorizedException {
        if (packet.getTo() == null || packet.getFrom() == null) {
            Log.debug("ServerStanzaHandler: Closing IncomingServerSession due to packet with no TO or FROM: " + packet.toXML());
            StreamError error = new StreamError(StreamError.Condition.improper_addressing);
            this.connection.deliverRawText(error.toXML());
            throw new UnauthorizedException("Packet with no TO or FROM attributes");
        }
        if (!((LocalIncomingServerSession)this.session).isValidDomain(packet.getFrom().getDomain())) {
            Log.debug("ServerStanzaHandler: Closing IncomingServerSession due to packet with invalid domain: " + packet.toXML());
            StreamError error = new StreamError(StreamError.Condition.invalid_from);
            this.connection.deliverRawText(error.toXML());
            throw new UnauthorizedException("Packet with no TO or FROM attributes");
        }
    }
}

