/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.XMPPServerInfo;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.keystore.CertificateStoreManager;
import org.jivesoftware.openfire.keystore.TrustStore;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.net.XMPPCallbackHandler;
import org.jivesoftware.openfire.sasl.Failure;
import org.jivesoftware.openfire.sasl.JiveSharedSecretSaslServer;
import org.jivesoftware.openfire.sasl.SaslFailureException;
import org.jivesoftware.openfire.sasl.SaslProvider;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.IncomingServerSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.CertificateManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLAuthentication {
    private static final Logger Log = LoggerFactory.getLogger(SASLAuthentication.class);
    private static final Pattern BASE64_ENCODED = Pattern.compile("^(=|([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==))$");
    private static final String SASL_NAMESPACE = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static Set<String> mechanisms = new HashSet<String>();

    public static String getSASLMechanisms(LocalSession session) {
        if (session instanceof ClientSession) {
            return SASLAuthentication.getSASLMechanismsElement((ClientSession)((Object)session)).asXML();
        }
        if (session instanceof LocalIncomingServerSession) {
            return SASLAuthentication.getSASLMechanismsElement((LocalIncomingServerSession)session).asXML();
        }
        Log.debug("Unable to determine SASL mechanisms that are applicable to session '{}'. Unrecognized session type.", (Object)session);
        return "";
    }

    public static Element getSASLMechanismsElement(ClientSession session) {
        Element result = DocumentHelper.createElement((QName)new QName("mechanisms", new Namespace("", SASL_NAMESPACE)));
        for (String mech : SASLAuthentication.getSupportedMechanisms()) {
            if (mech.equals("EXTERNAL")) {
                boolean trustedCert = false;
                if (session.isSecure()) {
                    Connection connection = ((LocalClientSession)session).getConnection();
                    TrustStore trustStore = connection.getConfiguration().getTrustStore();
                    trustedCert = trustStore.isTrusted(connection.getPeerCertificates());
                }
                if (!trustedCert) continue;
            }
            Element mechanism = result.addElement("mechanism");
            mechanism.setText(mech);
        }
        return result;
    }

    public static Element getSASLMechanismsElement(LocalIncomingServerSession session) {
        Element result = DocumentHelper.createElement((QName)new QName("mechanisms", new Namespace("", SASL_NAMESPACE)));
        if (session.isSecure()) {
            boolean haveTrustedCertificate;
            Connection connection = session.getConnection();
            TrustStore trustStore = connection.getConfiguration().getTrustStore();
            X509Certificate trusted = trustStore.getEndEntityCertificate(session.getConnection().getPeerCertificates());
            boolean bl = haveTrustedCertificate = trusted != null;
            if (trusted != null && session.getDefaultIdentity() != null) {
                haveTrustedCertificate = SASLAuthentication.verifyCertificate(trusted, session.getDefaultIdentity());
            }
            if (haveTrustedCertificate) {
                Element mechanism = result.addElement("mechanism");
                mechanism.setText("EXTERNAL");
            }
        }
        return result;
    }

    public static Status handle(LocalSession session, Element doc) {
        try {
            if (!doc.getNamespaceURI().equals(SASL_NAMESPACE)) {
                throw new IllegalStateException("Unexpected data received while negotiating SASL authentication. Name of the offending root element: " + doc.getName() + " Namespace: " + doc.getNamespaceURI());
            }
            switch (ElementType.valueOfCaseInsensitive(doc.getName())) {
                case ABORT: {
                    throw new SaslFailureException(Failure.ABORTED);
                }
                case AUTH: {
                    if (doc.attributeValue("mechanism") == null) {
                        throw new SaslFailureException(Failure.INVALID_MECHANISM, "Peer did not specify a mechanism.");
                    }
                    String mechanismName = doc.attributeValue("mechanism").toUpperCase();
                    if (!mechanisms.contains(mechanismName)) {
                        throw new SaslFailureException(Failure.INVALID_MECHANISM, "The configuration of Openfire does not contain or allow the mechanism.");
                    }
                    XMPPServerInfo serverInfo = XMPPServer.getInstance().getServerInfo();
                    String serverName = mechanismName.equals("DIGEST-MD5") ? serverInfo.getXMPPDomain() : serverInfo.getHostname();
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put(LocalSession.class.getCanonicalName(), session);
                    props.put("javax.security.sasl.policy.noanonymous", Boolean.toString(!JiveGlobals.getBooleanProperty("xmpp.auth.anonymous")));
                    props.put("com.sun.security.sasl.digest.realm", serverInfo.getXMPPDomain());
                    SaslServer saslServer = Sasl.createSaslServer(mechanismName, "xmpp", serverName, props, new XMPPCallbackHandler());
                    if (saslServer == null) {
                        throw new SaslFailureException(Failure.INVALID_MECHANISM, "There is no provider that can provide a SASL server for the desired mechanism and properties.");
                    }
                    session.setSessionData("SaslServer", saslServer);
                    if (mechanismName.equals("DIGEST-MD5")) {
                        doc.setText("");
                    }
                }
                case RESPONSE: {
                    boolean verify;
                    byte[] decoded;
                    SaslServer saslServer = (SaslServer)session.getSessionData("SaslServer");
                    if (saslServer == null) {
                        throw new IllegalStateException("A SaslServer instance was not initialized and/or stored on the session.");
                    }
                    String encoded = doc.getTextTrim();
                    if (encoded == null || encoded.isEmpty() || encoded.equals("=")) {
                        decoded = new byte[]{};
                    } else {
                        if (!BASE64_ENCODED.matcher(encoded).matches()) {
                            throw new SaslFailureException(Failure.INCORRECT_ENCODING);
                        }
                        decoded = StringUtils.decodeBase64(encoded);
                    }
                    byte[] challenge = saslServer.evaluateResponse(decoded);
                    if (!saslServer.isComplete()) {
                        SASLAuthentication.sendChallenge(session, challenge);
                        return Status.needResponse;
                    }
                    if (session instanceof IncomingServerSession && (verify = JiveGlobals.getBooleanProperty("xmpp.server.certificate.verify", true))) {
                        if (SASLAuthentication.verifyCertificates(session.getConnection().getPeerCertificates(), saslServer.getAuthorizationID(), true)) {
                            ((LocalIncomingServerSession)session).tlsAuth();
                        } else {
                            throw new SaslFailureException(Failure.NOT_AUTHORIZED, "Server-to-Server certificate verification failed.");
                        }
                    }
                    SASLAuthentication.authenticationSuccessful(session, saslServer.getAuthorizationID(), challenge);
                    session.removeSessionData("SaslServer");
                    return Status.authenticated;
                }
            }
            throw new IllegalStateException("Unexpected data received while negotiating SASL authentication. Name of the offending root element: " + doc.getName() + " Namespace: " + doc.getNamespaceURI());
        }
        catch (SaslException ex) {
            Log.debug("SASL negotiation failed for session: {}", (Object)session, (Object)ex);
            Failure failure = ex instanceof SaslFailureException && ((SaslFailureException)ex).getFailure() != null ? ((SaslFailureException)ex).getFailure() : Failure.NOT_AUTHORIZED;
            SASLAuthentication.authenticationFailed(session, failure);
            session.removeSessionData("SaslServer");
            return Status.failed;
        }
        catch (Exception ex) {
            Log.warn("An unexpected exception occurred during SASL negotiation. Affected session: {}", (Object)session, (Object)ex);
            SASLAuthentication.authenticationFailed(session, Failure.NOT_AUTHORIZED);
            session.removeSessionData("SaslServer");
            return Status.failed;
        }
    }

    public static boolean verifyCertificate(X509Certificate trustedCert, String hostname) {
        for (String identity : CertificateManager.getServerIdentities(trustedCert)) {
            if ((!identity.startsWith("*.") || !hostname.endsWith(identity.replace("*.", ".")) && !hostname.equals(identity.replace("*.", ""))) && !hostname.equals(identity)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyCertificates(Certificate[] chain, String hostname, boolean isS2S) {
        ConnectionType connectionType;
        CertificateStoreManager certificateStoreManager = XMPPServer.getInstance().getCertificateStoreManager();
        TrustStore trustStore = certificateStoreManager.getTrustStore(connectionType = isS2S ? ConnectionType.SOCKET_S2S : ConnectionType.SOCKET_C2S);
        X509Certificate trusted = trustStore.getEndEntityCertificate(chain);
        if (trusted != null) {
            return SASLAuthentication.verifyCertificate(trusted, hostname);
        }
        return false;
    }

    private static void sendElement(Session session, String element, byte[] data) {
        StringBuilder reply = new StringBuilder(250);
        reply.append("<");
        reply.append(element);
        reply.append(" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\"");
        if (data != null) {
            reply.append(">");
            String data_b64 = StringUtils.encodeBase64(data).trim();
            if ("".equals(data_b64)) {
                data_b64 = "=";
            }
            reply.append(data_b64);
            reply.append("</");
            reply.append(element);
            reply.append(">");
        } else {
            reply.append("/>");
        }
        session.deliverRawText(reply.toString());
    }

    private static void sendChallenge(Session session, byte[] challenge) {
        SASLAuthentication.sendElement(session, "challenge", challenge);
    }

    private static void authenticationSuccessful(LocalSession session, String username, byte[] successData) {
        if (username != null && LockOutManager.getInstance().isAccountDisabled(username)) {
            LockOutManager.getInstance().recordFailedLogin(username);
            SASLAuthentication.authenticationFailed(session, Failure.ACCOUNT_DISABLED);
            return;
        }
        SASLAuthentication.sendElement(session, "success", successData);
        if (session instanceof ClientSession) {
            ((LocalClientSession)session).setAuthToken(new AuthToken(username));
        } else if (session instanceof IncomingServerSession) {
            String hostname = username;
            ((LocalIncomingServerSession)session).addValidatedDomain(hostname);
            Log.info("Inbound Server {} authenticated (via TLS)", (Object)username);
        }
    }

    private static void authenticationFailed(LocalSession session, Failure failure) {
        StringBuilder reply = new StringBuilder(80);
        reply.append("<failure xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\"><");
        reply.append(failure.toString());
        reply.append("/></failure>");
        session.deliverRawText(reply.toString());
        Integer retries = (Integer)session.getSessionData("authRetries");
        retries = retries == null ? Integer.valueOf(1) : Integer.valueOf(retries + 1);
        session.setSessionData("authRetries", retries);
        if (retries >= JiveGlobals.getIntProperty("xmpp.auth.retries", 3)) {
            session.close();
        }
    }

    public static void addSupportedMechanism(String mechanismName) {
        if (mechanismName == null || mechanismName.isEmpty()) {
            throw new IllegalArgumentException("Argument 'mechanism' must cannot be null or an empty string.");
        }
        mechanisms.add(mechanismName.toUpperCase());
        Log.info("Support added for the '{}' SASL mechanism.", (Object)mechanismName.toUpperCase());
    }

    public static void removeSupportedMechanism(String mechanismName) {
        if (mechanismName == null || mechanismName.isEmpty()) {
            throw new IllegalArgumentException("Argument 'mechanism' must cannot be null or an empty string.");
        }
        if (mechanisms.remove(mechanismName.toUpperCase())) {
            Log.info("Support removed for the '{}' SASL mechanism.", (Object)mechanismName.toUpperCase());
        }
    }

    public static Set<String> getSupportedMechanisms() {
        Set<String> implementedMechanisms = SASLAuthentication.getImplementedMechanisms();
        HashSet<String> answer = new HashSet<String>(mechanisms);
        Iterator it = answer.iterator();
        while (it.hasNext()) {
            String mechanism = (String)it.next();
            if (!implementedMechanisms.contains(mechanism)) {
                Log.trace("Cannot support '{}' as there's no implementation available.", (Object)mechanism);
                it.remove();
                continue;
            }
            switch (mechanism) {
                case "CRAM-MD5": 
                case "DIGEST-MD5": {
                    if (AuthFactory.supportsPasswordRetrieval()) break;
                    Log.trace("Cannot support '{}' as the AuthFactory that's in use does not support password retrieval.", (Object)mechanism);
                    it.remove();
                    break;
                }
                case "SCRAM-SHA-1": {
                    if (AuthFactory.supportsScram()) break;
                    Log.trace("Cannot support '{}' as the AuthFactory that's in use does not support SCRAM.", (Object)mechanism);
                    it.remove();
                    break;
                }
                case "ANONYMOUS": {
                    if (JiveGlobals.getBooleanProperty("xmpp.auth.anonymous")) break;
                    Log.trace("Cannot support '{}' as it has been disabled by configuration.", (Object)mechanism);
                    it.remove();
                    break;
                }
                case "JIVE-SHAREDSECRET": {
                    if (JiveSharedSecretSaslServer.isSharedSecretAllowed()) break;
                    Log.trace("Cannot support '{}' as it has been disabled by configuration.", (Object)mechanism);
                    it.remove();
                    break;
                }
                case "GSSAPI": {
                    String gssapiConfig = JiveGlobals.getProperty("sasl.gssapi.config");
                    if (gssapiConfig != null) {
                        System.setProperty("java.security.krb5.debug", JiveGlobals.getProperty("sasl.gssapi.debug", "false"));
                        System.setProperty("java.security.auth.login.config", gssapiConfig);
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", JiveGlobals.getProperty("sasl.gssapi.useSubjectCredsOnly", "false"));
                        break;
                    }
                    Log.trace("Cannot support '{}' as the 'sasl.gssapi.config' property has not been defined.", (Object)mechanism);
                    it.remove();
                }
            }
        }
        return answer;
    }

    public static Set<String> getImplementedMechanisms() {
        HashSet<String> result = new HashSet<String>();
        Enumeration<SaslServerFactory> saslServerFactories = Sasl.getSaslServerFactories();
        while (saslServerFactories.hasMoreElements()) {
            SaslServerFactory saslServerFactory = saslServerFactories.nextElement();
            Collections.addAll(result, saslServerFactory.getMechanismNames(null));
        }
        return result;
    }

    public static List<String> getEnabledMechanisms() {
        return JiveGlobals.getListProperty("sasl.mechs", Arrays.asList("ANONYMOUS", "PLAIN", "DIGEST-MD5", "CRAM-MD5", "SCRAM-SHA-1", "JIVE-SHAREDSECRET", "GSSAPI", "EXTERNAL"));
    }

    public static void setEnabledMechanisms(List<String> mechanisms) {
        JiveGlobals.setProperty("sasl.mechs", mechanisms);
        SASLAuthentication.initMechanisms();
    }

    private static void initMechanisms() {
        List<String> propertyValues = SASLAuthentication.getEnabledMechanisms();
        mechanisms = new HashSet<String>();
        for (String propertyValue : propertyValues) {
            try {
                SASLAuthentication.addSupportedMechanism(propertyValue);
            }
            catch (Exception ex) {
                Log.warn("An exception occurred while trying to add support for SASL Mechanism '{}':", (Object)propertyValue, (Object)ex);
            }
        }
    }

    static {
        Security.addProvider(new SaslProvider());
        JiveGlobals.migrateProperty("sasl.mechs");
        JiveGlobals.migrateProperty("sasl.gssapi.debug");
        JiveGlobals.migrateProperty("sasl.gssapi.config");
        JiveGlobals.migrateProperty("sasl.gssapi.useSubjectCredsOnly");
        SASLAuthentication.initMechanisms();
        PropertyEventDispatcher.addListener(new PropertyEventListener(){

            @Override
            public void propertySet(String property, Map<String, Object> params) {
                if ("sasl.mechs".equals(property)) {
                    SASLAuthentication.initMechanisms();
                }
            }

            @Override
            public void propertyDeleted(String property, Map<String, Object> params) {
                if ("sasl.mechs".equals(property)) {
                    SASLAuthentication.initMechanisms();
                }
            }

            @Override
            public void xmlPropertySet(String property, Map<String, Object> params) {
            }

            @Override
            public void xmlPropertyDeleted(String property, Map<String, Object> params) {
            }
        });
    }

    public static enum Status {
        needResponse,
        failed,
        authenticated;

    }

    public static enum ElementType {
        ABORT,
        AUTH,
        RESPONSE,
        CHALLENGE,
        FAILURE,
        UNDEF;


        public static ElementType valueOfCaseInsensitive(String name) {
            if (name == null || name.isEmpty()) {
                return UNDEF;
            }
            try {
                return ElementType.valueOf(name.toUpperCase());
            }
            catch (Throwable t) {
                return UNDEF;
            }
        }
    }
}

