/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPChecker
extends PKIXCertPathChecker {
    private static final Logger Log = LoggerFactory.getLogger(OCSPChecker.class);
    private static String ocspServerUrl = JiveGlobals.getProperty("ocsp.responderURL");
    private static String ocspServerSubject = JiveGlobals.getProperty("ocsp.responderCertSubjectName");
    private static final boolean dump = true;
    private int certIndex;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;

    OCSPChecker(CertPath certPath, PKIXParameters pkixParams) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pkixParams;
        List<? extends Certificate> tmp = this.cp.getCertificates();
        this.certs = tmp.toArray(new X509Certificate[tmp.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.certIndex = this.certs.length - 1;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        Log.debug("OCSPChecker: check called");
        InputStream in = null;
        OutputStream out = null;
        try {
            URL url;
            X509Certificate responderCert = null;
            boolean haveResponderCert = true;
            X500Principal responderSubjectName = null;
            boolean haveIssuerCert = false;
            if (ocspServerSubject != null) {
                haveResponderCert = false;
                responderSubjectName = new X500Principal(ocspServerSubject);
            }
            X509Certificate issuerCert = null;
            X509Certificate currCert = (X509Certificate)cert;
            if (this.certIndex != 0) {
                issuerCert = this.certs[this.certIndex];
                haveIssuerCert = true;
                if (haveResponderCert) {
                    responderCert = this.certs[this.certIndex];
                }
            }
            if (!haveIssuerCert || !haveResponderCert) {
                Iterator<TrustAnchor> anchors;
                if (!haveResponderCert) {
                    Log.debug("OCSPChecker: Looking for responder's certificate");
                }
                if (!haveIssuerCert) {
                    Log.debug("OCSPChecker: Looking for issuer's certificate");
                }
                if (!(anchors = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                    throw new CertPathValidatorException("Must specify at least one trust anchor");
                }
                X500Principal certIssuerName = currCert.getIssuerX500Principal();
                while (!(!anchors.hasNext() || haveIssuerCert && haveResponderCert)) {
                    TrustAnchor anchor = anchors.next();
                    X509Certificate anchorCert = anchor.getTrustedCert();
                    X500Principal anchorSubjectName = anchorCert.getSubjectX500Principal();
                    if (!haveIssuerCert && certIssuerName.equals(anchorSubjectName)) {
                        issuerCert = anchorCert;
                        haveIssuerCert = true;
                        if (haveResponderCert && responderCert == null) {
                            responderCert = anchorCert;
                            Log.debug("OCSPChecker: Responder's certificate = issuer certificate");
                        }
                    }
                    if (haveResponderCert || responderSubjectName == null || !responderSubjectName.equals(anchorSubjectName)) continue;
                    responderCert = anchorCert;
                    haveResponderCert = true;
                }
                if (issuerCert == null) {
                    throw new CertPathValidatorException("No trusted certificate for " + currCert.getIssuerDN());
                }
                if (!haveResponderCert) {
                    Log.debug("OCSPChecker: Searching cert stores for responder's certificate");
                    if (responderSubjectName != null) {
                        X509CertSelector filter = new X509CertSelector();
                        filter.setSubject(responderSubjectName.getName());
                        List<CertStore> certStores = this.pkixParams.getCertStores();
                        for (CertStore certStore : certStores) {
                            Iterator<? extends Certificate> i = certStore.getCertificates(filter).iterator();
                            if (!i.hasNext()) continue;
                            responderCert = (X509Certificate)i.next();
                            haveResponderCert = true;
                            break;
                        }
                    }
                }
            }
            if (!haveResponderCert) {
                throw new CertPathValidatorException("Cannot find the responder's certificate.");
            }
            OCSPReqBuilder gen = new OCSPReqBuilder();
            CertificateID certID = new CertificateID(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(CertificateID.HASH_SHA1), new X509CertificateHolder(issuerCert.getEncoded()), currCert.getSerialNumber());
            gen.addRequest(certID);
            OCSPReq ocspRequest = gen.build();
            if (ocspServerUrl != null) {
                try {
                    url = new URL(ocspServerUrl);
                }
                catch (MalformedURLException e) {
                    throw new CertPathValidatorException(e);
                }
            } else {
                throw new CertPathValidatorException("Must set OCSP Server URL");
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            Log.debug("OCSPChecker: connecting to OCSP service at: " + url);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            byte[] bytes = ocspRequest.getEncoded();
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (con.getResponseCode() != 200) {
                Log.debug("OCSPChecker: Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            in = con.getInputStream();
            OCSPResp ocspResponse = new OCSPResp(in);
            BigInteger serialNumber = currCert.getSerialNumber();
            BasicOCSPResp brep = (BasicOCSPResp)ocspResponse.getResponseObject();
            try {
                if (!brep.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(responderCert.getPublicKey()))) {
                    throw new CertPathValidatorException("OCSP response is not verified");
                }
            }
            catch (Exception e) {
                throw new CertPathValidatorException("OCSP response could not be verified (" + e.getMessage() + ")", null, this.cp, this.certIndex);
            }
            SingleResp[] singleResp = brep.getResponses();
            boolean foundResponse = false;
            for (SingleResp resp : singleResp) {
                CertificateID respCertID = resp.getCertID();
                if (!respCertID.equals((Object)certID)) continue;
                CertificateStatus status = resp.getCertStatus();
                if (status == CertificateStatus.GOOD) {
                    Log.debug("OCSPChecker: Status of certificate (with serial number " + serialNumber.toString() + ") is: good");
                    foundResponse = true;
                    break;
                }
                if (status instanceof RevokedStatus) {
                    Log.debug("OCSPChecker: Status of certificate (with serial number " + serialNumber.toString() + ") is: revoked");
                    throw new CertPathValidatorException("Certificate has been revoked", null, this.cp, this.certIndex);
                }
                if (status instanceof UnknownStatus) {
                    Log.debug("OCSPChecker: Status of certificate (with serial number " + serialNumber.toString() + ") is: unknown");
                    throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.certIndex);
                }
                Log.debug("Status of certificate (with serial number " + serialNumber.toString() + ") is: not recognized");
                throw new CertPathValidatorException("Unknown OCSP response for certificate", null, this.cp, this.certIndex);
            }
            if (!foundResponse) {
                throw new CertPathValidatorException("No certificates in the OCSP response match the certificate supplied in the OCSP request.");
            }
        }
        catch (CertPathValidatorException cpve) {
            throw cpve;
        }
        catch (Exception e) {
            throw new CertPathValidatorException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    throw new CertPathValidatorException(ioe);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    throw new CertPathValidatorException(ioe);
                }
            }
        }
    }
}

