/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import org.dom4j.Element;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.multiplex.MultiplexerPacketHandler;
import org.jivesoftware.openfire.multiplex.Route;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.session.LocalConnectionMultiplexerSession;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class MultiplexerStanzaHandler
extends StanzaHandler {
    private MultiplexerPacketHandler packetHandler;

    public MultiplexerStanzaHandler(PacketRouter router, Connection connection) {
        super(router, connection);
    }

    @Deprecated
    public MultiplexerStanzaHandler(PacketRouter router, String serverName, Connection connection) {
        super(router, serverName, connection);
    }

    @Override
    protected void processIQ(IQ packet) {
        if (this.session.getStatus() != 3) {
            IQ reply = new IQ();
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setID(packet.getID());
            reply.setTo(packet.getFrom());
            reply.setFrom(packet.getTo());
            reply.setError(PacketError.Condition.not_authorized);
            this.session.process((Packet)reply);
            return;
        }
        this.packetHandler.handle((Packet)packet);
    }

    @Override
    protected void processMessage(Message packet) throws UnauthorizedException {
        throw new UnauthorizedException("Message packets are not supported. Original packets should be wrapped by route packets.");
    }

    @Override
    protected void processPresence(Presence packet) throws UnauthorizedException {
        throw new UnauthorizedException("Message packets are not supported. Original packets should be wrapped by route packets.");
    }

    private void processRoute(Route packet) {
        if (this.session.getStatus() != 3) {
            Route reply = new Route(packet.getStreamID());
            reply.setID(packet.getID());
            reply.setTo(packet.getFrom());
            reply.setFrom(packet.getTo());
            reply.setError(PacketError.Condition.not_authorized);
            this.session.process(reply);
            return;
        }
        this.packetHandler.route(packet);
    }

    @Override
    boolean processUnknowPacket(Element doc) {
        String tag = doc.getName();
        if ("route".equals(tag)) {
            this.processRoute(new Route(doc));
            return true;
        }
        if ("handshake".equals(tag)) {
            if (!((LocalConnectionMultiplexerSession)this.session).authenticate(doc.getStringValue())) {
                this.session.close();
            }
            return true;
        }
        if ("error".equals(tag) && "stream".equals(doc.getNamespacePrefix())) {
            this.session.close();
            return true;
        }
        return false;
    }

    @Override
    String getNamespace() {
        return "jabber:connectionmanager";
    }

    @Override
    boolean validateHost() {
        return false;
    }

    @Override
    boolean validateJIDs() {
        return false;
    }

    @Override
    boolean createSession(String namespace, String serverName, XmlPullParser xpp, Connection connection) throws XmlPullParserException {
        if (this.getNamespace().equals(namespace)) {
            this.session = LocalConnectionMultiplexerSession.createSession(serverName, xpp, connection);
            if (this.session != null) {
                this.packetHandler = new MultiplexerPacketHandler(this.session.getAddress().getDomain());
            }
            return true;
        }
        return false;
    }

    @Override
    void startTLS() throws Exception {
        this.connection.startTLS(false);
    }
}

