/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import com.jcraft.jzlib.ZInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.AsynchronousCloseException;
import org.dom4j.Element;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.net.SocketReader;
import org.jivesoftware.openfire.net.SocketReadingMode;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

class BlockingReadingMode
extends SocketReadingMode {
    private static final Logger Log = LoggerFactory.getLogger(BlockingReadingMode.class);

    public BlockingReadingMode(Socket socket, SocketReader socketReader) {
        super(socket, socketReader);
    }

    @Override
    public void run() {
        try {
            this.socketReader.reader.getXPPParser().setInput(new InputStreamReader(ServerTrafficCounter.wrapInputStream(this.socket.getInputStream()), CHARSET));
            try {
                this.socketReader.createSession();
            }
            catch (IOException e) {
                Log.debug("Error creating session", (Throwable)e);
                throw e;
            }
            if (this.socketReader.session != null) {
                this.readStream();
            }
        }
        catch (EOFException e) {
        }
        catch (SocketException e) {
        }
        catch (AsynchronousCloseException e) {
        }
        catch (XmlPullParserException e) {
        }
        catch (Exception e) {
            if (this.socketReader.session != null) {
                Log.warn(LocaleUtils.getLocalizedString("admin.error.stream") + ". Session: " + this.socketReader.session, (Throwable)e);
            }
        }
        finally {
            if (this.socketReader.session != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Logging off " + this.socketReader.session.getAddress() + " on " + this.socketReader.connection);
                }
                try {
                    this.socketReader.session.close();
                }
                catch (Exception e) {
                    Log.warn(LocaleUtils.getLocalizedString("admin.error.connection") + this.socket.toString());
                }
            } else {
                this.socketReader.connection.close();
                Log.debug(LocaleUtils.getLocalizedString("admin.error.connection") + this.socket.toString());
            }
            this.socketReader.shutdown();
        }
    }

    private void readStream() throws Exception {
        this.socketReader.open = true;
        while (this.socketReader.open) {
            Element doc = this.socketReader.reader.parseDocument().getRootElement();
            if (doc == null) {
                return;
            }
            String tag = doc.getName();
            if ("starttls".equals(tag)) {
                if (this.negotiateTLS()) {
                    this.tlsNegotiated();
                    continue;
                }
                this.socketReader.open = false;
                this.socketReader.session = null;
                continue;
            }
            if ("auth".equals(tag)) {
                if (this.authenticateClient(doc)) {
                    this.saslSuccessful();
                    continue;
                }
                if (!this.socketReader.connection.isClosed()) continue;
                this.socketReader.open = false;
                this.socketReader.session = null;
                continue;
            }
            if ("compress".equals(tag)) {
                if (!this.compressClient(doc)) continue;
                this.compressionSuccessful();
                continue;
            }
            this.socketReader.process(doc);
        }
    }

    @Override
    protected void tlsNegotiated() throws XmlPullParserException, IOException {
        MXParser xpp = this.socketReader.reader.getXPPParser();
        xpp.setInput(new InputStreamReader(this.socketReader.connection.getTLSStreamHandler().getInputStream(), CHARSET));
        int eventType = xpp.getEventType();
        while (eventType != 2) {
            eventType = xpp.next();
        }
        super.tlsNegotiated();
    }

    @Override
    protected void saslSuccessful() throws XmlPullParserException, IOException {
        MXParser xpp = this.socketReader.reader.getXPPParser();
        xpp.resetInput();
        int eventType = xpp.getEventType();
        while (eventType != 2) {
            eventType = xpp.next();
        }
        super.saslSuccessful();
    }

    @Override
    protected boolean compressClient(Element doc) throws XmlPullParserException, IOException {
        boolean answer = super.compressClient(doc);
        if (answer) {
            MXParser xpp = this.socketReader.reader.getXPPParser();
            if (this.socketReader.connection.getTLSStreamHandler() == null) {
                ZInputStream in = new ZInputStream(ServerTrafficCounter.wrapInputStream(this.socket.getInputStream()));
                in.setFlushMode(1);
                xpp.setInput(new InputStreamReader((InputStream)in, CHARSET));
            } else {
                ZInputStream in = new ZInputStream(this.socketReader.connection.getTLSStreamHandler().getInputStream());
                in.setFlushMode(1);
                xpp.setInput(new InputStreamReader((InputStream)in, CHARSET));
            }
        }
        return answer;
    }

    @Override
    protected void compressionSuccessful() throws XmlPullParserException, IOException {
        MXParser xpp = this.socketReader.reader.getXPPParser();
        int eventType = xpp.getEventType();
        while (eventType != 2) {
            eventType = xpp.next();
        }
        super.compressionSuccessful();
    }
}

