/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCUser;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class RemoteMUCUser
implements MUCUser {
    private JID realjid;
    private LocalMUCRoom room;

    public RemoteMUCUser(JID realjid, LocalMUCRoom room) {
        this.realjid = realjid;
        this.room = room;
    }

    @Override
    public JID getAddress() {
        return this.realjid;
    }

    @Override
    public void process(Packet packet) throws UnauthorizedException, PacketException {
        if (packet instanceof IQ) {
            throw new UnsupportedOperationException("Cannot process IQ packets of remote users: " + packet);
        }
        if (packet instanceof Message) {
            throw new UnsupportedOperationException("Cannot process Message packets of remote users: " + packet);
        }
        if (packet instanceof Presence) {
            this.process((Presence)packet);
        }
    }

    @Override
    private void process(Presence presence) {
        if (presence.getType() == Presence.Type.unavailable) {
            MUCRole mucRole = this.room.getOccupantByFullJID(this.realjid);
            if (mucRole != null) {
                this.room.leaveRoom(mucRole);
            }
        } else {
            throw new UnsupportedOperationException("Cannot process Presence packets of remote users: " + presence);
        }
    }
}

