/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.spi.ConversationLogEntry;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.muc.spi.MUCServiceProperties;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class MUCPersistenceManager {
    private static final Logger Log = LoggerFactory.getLogger(MUCPersistenceManager.class);
    private static final String MUC_HISTORY_RELOAD_LIMIT = "xmpp.muc.history.reload.limit";
    private static final String GET_RESERVED_NAME = "SELECT nickname FROM ofMucMember WHERE roomID=? AND jid=?";
    private static final String LOAD_ROOM = "SELECT roomID, creationDate, modificationDate, naturalName, description, lockedDate, emptyDate, canChangeSubject, maxUsers, publicRoom, moderated, membersOnly, canInvite, roomPassword, canDiscoverJID, logEnabled, subject, rolesToBroadcast, useReservedNick, canChangeNick, canRegister, allowpm FROM ofMucRoom WHERE serviceID=? AND name=?";
    private static final String LOAD_AFFILIATIONS = "SELECT jid, affiliation FROM ofMucAffiliation WHERE roomID=?";
    private static final String LOAD_MEMBERS = "SELECT jid, nickname FROM ofMucMember WHERE roomID=?";
    private static final String LOAD_HISTORY = "SELECT sender, nickname, logTime, subject, body, stanza FROM ofMucConversationLog WHERE logTime>? AND roomID=? AND (nickname IS NOT NULL OR subject IS NOT NULL) ORDER BY logTime";
    private static final String LOAD_ALL_ROOMS = "SELECT roomID, creationDate, modificationDate, name, naturalName, description, lockedDate, emptyDate, canChangeSubject, maxUsers, publicRoom, moderated, membersOnly, canInvite, roomPassword, canDiscoverJID, logEnabled, subject, rolesToBroadcast, useReservedNick, canChangeNick, canRegister, allowpm FROM ofMucRoom WHERE serviceID=? AND (emptyDate IS NULL or emptyDate > ?)";
    private static final String LOAD_ALL_AFFILIATIONS = "SELECT ofMucAffiliation.roomID,ofMucAffiliation.jid,ofMucAffiliation.affiliation FROM ofMucAffiliation,ofMucRoom WHERE ofMucAffiliation.roomID = ofMucRoom.roomID AND ofMucRoom.serviceID=?";
    private static final String LOAD_ALL_MEMBERS = "SELECT ofMucMember.roomID,ofMucMember.jid,ofMucMember.nickname FROM ofMucMember,ofMucRoom WHERE ofMucMember.roomID = ofMucRoom.roomID AND ofMucRoom.serviceID=?";
    private static final String LOAD_ALL_HISTORY = "SELECT ofMucConversationLog.roomID, ofMucConversationLog.sender, ofMucConversationLog.nickname, ofMucConversationLog.logTime, ofMucConversationLog.subject, ofMucConversationLog.body, ofMucConversationLog.stanza FROM ofMucConversationLog, ofMucRoom WHERE ofMucConversationLog.roomID = ofMucRoom.roomID AND ofMucRoom.serviceID=? AND ofMucConversationLog.logTime>? AND (ofMucConversationLog.nickname IS NOT NULL OR ofMucConversationLog.subject IS NOT NULL) ORDER BY ofMucConversationLog.logTime";
    private static final String UPDATE_ROOM = "UPDATE ofMucRoom SET modificationDate=?, naturalName=?, description=?, canChangeSubject=?, maxUsers=?, publicRoom=?, moderated=?, membersOnly=?, canInvite=?, roomPassword=?, canDiscoverJID=?, logEnabled=?, rolesToBroadcast=?, useReservedNick=?, canChangeNick=?, canRegister=?, allowpm=? WHERE roomID=?";
    private static final String ADD_ROOM = "INSERT INTO ofMucRoom (serviceID, roomID, creationDate, modificationDate, name, naturalName, description, lockedDate, emptyDate, canChangeSubject, maxUsers, publicRoom, moderated, membersOnly, canInvite, roomPassword, canDiscoverJID, logEnabled, subject, rolesToBroadcast, useReservedNick, canChangeNick, canRegister, allowpm) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_SUBJECT = "UPDATE ofMucRoom SET subject=? WHERE roomID=?";
    private static final String UPDATE_LOCK = "UPDATE ofMucRoom SET lockedDate=? WHERE roomID=?";
    private static final String UPDATE_EMPTYDATE = "UPDATE ofMucRoom SET emptyDate=? WHERE roomID=?";
    private static final String DELETE_ROOM = "DELETE FROM ofMucRoom WHERE roomID=?";
    private static final String DELETE_AFFILIATIONS = "DELETE FROM ofMucAffiliation WHERE roomID=?";
    private static final String DELETE_MEMBERS = "DELETE FROM ofMucMember WHERE roomID=?";
    private static final String ADD_MEMBER = "INSERT INTO ofMucMember (roomID,jid,nickname) VALUES (?,?,?)";
    private static final String UPDATE_MEMBER = "UPDATE ofMucMember SET nickname=? WHERE roomID=? AND jid=?";
    private static final String DELETE_MEMBER = "DELETE FROM ofMucMember WHERE roomID=? AND jid=?";
    private static final String ADD_AFFILIATION = "INSERT INTO ofMucAffiliation (roomID,jid,affiliation) VALUES (?,?,?)";
    private static final String UPDATE_AFFILIATION = "UPDATE ofMucAffiliation SET affiliation=? WHERE roomID=? AND jid=?";
    private static final String DELETE_AFFILIATION = "DELETE FROM ofMucAffiliation WHERE roomID=? AND jid=?";
    private static final String DELETE_USER_MEMBER = "DELETE FROM ofMucMember WHERE jid=?";
    private static final String DELETE_USER_MUCAFFILIATION = "DELETE FROM ofMucAffiliation WHERE jid=?";
    private static final String ADD_CONVERSATION_LOG = "INSERT INTO ofMucConversationLog (roomID,messageID,sender,nickname,logTime,subject,body,stanza) SELECT ?,COUNT(*),?,?,?,?,?,? FROM ofMucConversationLog";
    private static ConcurrentHashMap<String, MUCServiceProperties> propertyMaps = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReservedNickname(MUCRoom room, String bareJID) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String answer = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_RESERVED_NAME);
            pstmt.setLong(1, room.getID());
            pstmt.setString(2, bareJID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                answer = rs.getString(1);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromDB(LocalMUCRoom room) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block29: {
            con = null;
            pstmt = null;
            rs = null;
            try {
                Long serviceID = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServiceID(room.getMUCService().getServiceName());
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_ROOM);
                pstmt.setLong(1, serviceID);
                pstmt.setString(2, room.getName());
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException("Room " + room.getName() + " was not found in the database.");
                }
                room.setID(rs.getLong(1));
                room.setCreationDate(new Date(Long.parseLong(rs.getString(2).trim())));
                room.setModificationDate(new Date(Long.parseLong(rs.getString(3).trim())));
                room.setNaturalLanguageName(rs.getString(4));
                room.setDescription(rs.getString(5));
                room.setLockedDate(new Date(Long.parseLong(rs.getString(6).trim())));
                if (rs.getString(7) != null) {
                    room.setEmptyDate(new Date(Long.parseLong(rs.getString(7).trim())));
                } else {
                    room.setEmptyDate(null);
                }
                room.setCanOccupantsChangeSubject(rs.getInt(8) == 1);
                room.setMaxUsers(rs.getInt(9));
                room.setPublicRoom(rs.getInt(10) == 1);
                room.setModerated(rs.getInt(11) == 1);
                room.setMembersOnly(rs.getInt(12) == 1);
                room.setCanOccupantsInvite(rs.getInt(13) == 1);
                room.setPassword(rs.getString(14));
                room.setCanAnyoneDiscoverJID(rs.getInt(15) == 1);
                room.setLogEnabled(rs.getInt(16) == 1);
                room.setSubject(rs.getString(17));
                ArrayList<String> rolesToBroadcast = new ArrayList<String>();
                String roles = StringUtils.zeroPadString(Integer.toBinaryString(rs.getInt(18)), 3);
                if (roles.charAt(0) == '1') {
                    rolesToBroadcast.add("moderator");
                }
                if (roles.charAt(1) == '1') {
                    rolesToBroadcast.add("participant");
                }
                if (roles.charAt(2) == '1') {
                    rolesToBroadcast.add("visitor");
                }
                room.setRolesToBroadcastPresence(rolesToBroadcast);
                room.setLoginRestrictedToNickname(rs.getInt(19) == 1);
                room.setChangeNickname(rs.getInt(20) == 1);
                room.setRegistrationEnabled(rs.getInt(21) == 1);
                switch (rs.getInt(22)) {
                    default: {
                        room.setCanSendPrivateMessage("anyone");
                        break;
                    }
                    case 1: {
                        room.setCanSendPrivateMessage("participants");
                        break;
                    }
                    case 2: {
                        room.setCanSendPrivateMessage("moderators");
                        break;
                    }
                    case 3: {
                        room.setCanSendPrivateMessage("none");
                    }
                }
                room.setPersistent(true);
                DbConnectionManager.fastcloseStmt(rs, pstmt);
                if (room.isLogEnabled()) {
                    pstmt = con.prepareStatement(LOAD_HISTORY);
                    int reloadLimitDays = JiveGlobals.getIntProperty(MUC_HISTORY_RELOAD_LIMIT, 2);
                    long from = System.currentTimeMillis() - BigInteger.valueOf(86400000L).multiply(BigInteger.valueOf(reloadLimitDays)).longValue();
                    pstmt.setString(1, StringUtils.dateToMillis(new Date(from)));
                    pstmt.setLong(2, room.getID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String senderJID = rs.getString(1);
                        String nickname = rs.getString(2);
                        Date sentDate = new Date(Long.parseLong(rs.getString(3).trim()));
                        String subject = rs.getString(4);
                        String body = rs.getString(5);
                        String stanza = rs.getString(6);
                        room.getRoomHistory().addOldMessage(senderJID, nickname, sentDate, subject, body, stanza);
                    }
                }
                DbConnectionManager.fastcloseStmt(rs, pstmt);
                if (!room.getRoomHistory().hasChangedSubject() && room.getSubject() != null && room.getSubject().length() > 0) {
                    room.getRoomHistory().addOldMessage(room.getRole().getRoleAddress().toString(), null, room.getModificationDate(), room.getSubject(), null, null);
                }
                pstmt = con.prepareStatement(LOAD_AFFILIATIONS);
                pstmt.setLong(1, room.getID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    JID affiliationJID = GroupJID.fromString(rs.getString(1));
                    MUCRole.Affiliation affiliation = MUCRole.Affiliation.valueOf(rs.getInt(2));
                    try {
                        switch (affiliation) {
                            case owner: {
                                room.addOwner(affiliationJID, room.getRole());
                                break;
                            }
                            case admin: {
                                room.addAdmin(affiliationJID, room.getRole());
                                break;
                            }
                            case outcast: {
                                room.addOutcast(affiliationJID, null, room.getRole());
                                break;
                            }
                            default: {
                                Log.error("Unkown affiliation value " + (Object)((Object)affiliation) + " for user " + affiliationJID.toBareJID() + " in persistent room " + room.getID());
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                }
                DbConnectionManager.fastcloseStmt(rs, pstmt);
                pstmt = con.prepareStatement(LOAD_MEMBERS);
                pstmt.setLong(1, room.getID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    try {
                        room.addMember(new JID(rs.getString(1)), rs.getString(2), room.getRole());
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                }
                room.setSavedToDB(true);
                if (room.getEmptyDate() != null) break block29;
                room.setEmptyDate(new Date());
            }
            catch (SQLException sqle) {
                try {
                    Log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToDB(LocalMUCRoom room) {
        PreparedStatement pstmt;
        Connection con;
        block29: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                if (room.wasSavedToDB()) {
                    pstmt = con.prepareStatement(UPDATE_ROOM);
                    pstmt.setString(1, StringUtils.dateToMillis(room.getModificationDate()));
                    pstmt.setString(2, room.getNaturalLanguageName());
                    pstmt.setString(3, room.getDescription());
                    pstmt.setInt(4, room.canOccupantsChangeSubject() ? 1 : 0);
                    pstmt.setInt(5, room.getMaxUsers());
                    pstmt.setInt(6, room.isPublicRoom() ? 1 : 0);
                    pstmt.setInt(7, room.isModerated() ? 1 : 0);
                    pstmt.setInt(8, room.isMembersOnly() ? 1 : 0);
                    pstmt.setInt(9, room.canOccupantsInvite() ? 1 : 0);
                    pstmt.setString(10, room.getPassword());
                    pstmt.setInt(11, room.canAnyoneDiscoverJID() ? 1 : 0);
                    pstmt.setInt(12, room.isLogEnabled() ? 1 : 0);
                    pstmt.setInt(13, MUCPersistenceManager.marshallRolesToBroadcast(room));
                    pstmt.setInt(14, room.isLoginRestrictedToNickname() ? 1 : 0);
                    pstmt.setInt(15, room.canChangeNickname() ? 1 : 0);
                    pstmt.setInt(16, room.isRegistrationEnabled() ? 1 : 0);
                    switch (room.canSendPrivateMessage()) {
                        default: {
                            pstmt.setInt(17, 0);
                            break;
                        }
                        case "participants": {
                            pstmt.setInt(17, 1);
                            break;
                        }
                        case "moderators": {
                            pstmt.setInt(17, 2);
                            break;
                        }
                        case "none": {
                            pstmt.setInt(17, 3);
                        }
                    }
                    pstmt.setLong(18, room.getID());
                    pstmt.executeUpdate();
                    break block29;
                }
                pstmt = con.prepareStatement(ADD_ROOM);
                pstmt.setLong(1, XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServiceID(room.getMUCService().getServiceName()));
                pstmt.setLong(2, room.getID());
                pstmt.setString(3, StringUtils.dateToMillis(room.getCreationDate()));
                pstmt.setString(4, StringUtils.dateToMillis(room.getModificationDate()));
                pstmt.setString(5, room.getName());
                pstmt.setString(6, room.getNaturalLanguageName());
                pstmt.setString(7, room.getDescription());
                pstmt.setString(8, StringUtils.dateToMillis(room.getLockedDate()));
                Date emptyDate = room.getEmptyDate();
                if (emptyDate == null) {
                    pstmt.setString(9, null);
                } else {
                    pstmt.setString(9, StringUtils.dateToMillis(emptyDate));
                }
                pstmt.setInt(10, room.canOccupantsChangeSubject() ? 1 : 0);
                pstmt.setInt(11, room.getMaxUsers());
                pstmt.setInt(12, room.isPublicRoom() ? 1 : 0);
                pstmt.setInt(13, room.isModerated() ? 1 : 0);
                pstmt.setInt(14, room.isMembersOnly() ? 1 : 0);
                pstmt.setInt(15, room.canOccupantsInvite() ? 1 : 0);
                pstmt.setString(16, room.getPassword());
                pstmt.setInt(17, room.canAnyoneDiscoverJID() ? 1 : 0);
                pstmt.setInt(18, room.isLogEnabled() ? 1 : 0);
                pstmt.setString(19, room.getSubject());
                pstmt.setInt(20, MUCPersistenceManager.marshallRolesToBroadcast(room));
                pstmt.setInt(21, room.isLoginRestrictedToNickname() ? 1 : 0);
                pstmt.setInt(22, room.canChangeNickname() ? 1 : 0);
                pstmt.setInt(23, room.isRegistrationEnabled() ? 1 : 0);
                switch (room.canSendPrivateMessage()) {
                    default: {
                        pstmt.setInt(24, 0);
                        break;
                    }
                    case "participants": {
                        pstmt.setInt(24, 1);
                        break;
                    }
                    case "moderators": {
                        pstmt.setInt(24, 2);
                        break;
                    }
                    case "none": {
                        pstmt.setInt(24, 3);
                    }
                }
                pstmt.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    Log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromDB(MUCRoom room) {
        if (!room.isPersistent() || !room.wasSavedToDB()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(DELETE_AFFILIATIONS);
            pstmt.setLong(1, room.getID());
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_MEMBERS);
            pstmt.setLong(1, room.getID());
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_ROOM);
            pstmt.setLong(1, room.getID());
            pstmt.executeUpdate();
            room.setSavedToDB(false);
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
                abortTransaction = true;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement(pstmt);
            DbConnectionManager.closeTransactionConnection(con, abortTransaction);
        }
        DbConnectionManager.closeStatement(pstmt);
        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
    }

    public static Collection<LocalMUCRoom> loadRoomsFromDB(MultiUserChatService chatserver, Date emptyDate, PacketRouter packetRouter) {
        Map<Long, LocalMUCRoom> rooms;
        Long serviceID = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServiceID(chatserver.getServiceName());
        try {
            rooms = MUCPersistenceManager.loadRooms(serviceID, emptyDate, chatserver, packetRouter);
            MUCPersistenceManager.loadHistory(serviceID, rooms);
            MUCPersistenceManager.loadAffiliations(serviceID, rooms);
            MUCPersistenceManager.loadMembers(serviceID, rooms);
        }
        catch (SQLException sqle) {
            Log.error("A database error prevented MUC rooms to be loaded from the database.", (Throwable)sqle);
            return Collections.emptyList();
        }
        for (MUCRoom mUCRoom : rooms.values()) {
            mUCRoom.setSavedToDB(true);
            if (mUCRoom.getEmptyDate() != null) continue;
            mUCRoom.setEmptyDate(new Date());
        }
        return rooms.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, LocalMUCRoom> loadRooms(Long serviceID, Date emptyDate, MultiUserChatService chatserver, PacketRouter packetRouter) throws SQLException {
        HashMap<Long, LocalMUCRoom> rooms = new HashMap<Long, LocalMUCRoom>();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbConnectionManager.getConnection();
            statement = connection.prepareStatement(LOAD_ALL_ROOMS);
            statement.setLong(1, serviceID);
            statement.setString(2, StringUtils.dateToMillis(emptyDate));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                try {
                    LocalMUCRoom room = new LocalMUCRoom(chatserver, resultSet.getString(4), packetRouter);
                    room.setID(resultSet.getLong(1));
                    room.setCreationDate(new Date(Long.parseLong(resultSet.getString(2).trim())));
                    room.setModificationDate(new Date(Long.parseLong(resultSet.getString(3).trim())));
                    room.setNaturalLanguageName(resultSet.getString(5));
                    room.setDescription(resultSet.getString(6));
                    room.setLockedDate(new Date(Long.parseLong(resultSet.getString(7).trim())));
                    if (resultSet.getString(8) != null) {
                        room.setEmptyDate(new Date(Long.parseLong(resultSet.getString(8).trim())));
                    } else {
                        room.setEmptyDate(null);
                    }
                    room.setCanOccupantsChangeSubject(resultSet.getInt(9) == 1);
                    room.setMaxUsers(resultSet.getInt(10));
                    room.setPublicRoom(resultSet.getInt(11) == 1);
                    room.setModerated(resultSet.getInt(12) == 1);
                    room.setMembersOnly(resultSet.getInt(13) == 1);
                    room.setCanOccupantsInvite(resultSet.getInt(14) == 1);
                    room.setPassword(resultSet.getString(15));
                    room.setCanAnyoneDiscoverJID(resultSet.getInt(16) == 1);
                    room.setLogEnabled(resultSet.getInt(17) == 1);
                    room.setSubject(resultSet.getString(18));
                    ArrayList<String> rolesToBroadcast = new ArrayList<String>();
                    String roles = StringUtils.zeroPadString(Integer.toBinaryString(resultSet.getInt(19)), 3);
                    if (roles.charAt(0) == '1') {
                        rolesToBroadcast.add("moderator");
                    }
                    if (roles.charAt(1) == '1') {
                        rolesToBroadcast.add("participant");
                    }
                    if (roles.charAt(2) == '1') {
                        rolesToBroadcast.add("visitor");
                    }
                    room.setRolesToBroadcastPresence(rolesToBroadcast);
                    room.setLoginRestrictedToNickname(resultSet.getInt(20) == 1);
                    room.setChangeNickname(resultSet.getInt(21) == 1);
                    room.setRegistrationEnabled(resultSet.getInt(22) == 1);
                    switch (resultSet.getInt(23)) {
                        default: {
                            room.setCanSendPrivateMessage("anyone");
                            break;
                        }
                        case 1: {
                            room.setCanSendPrivateMessage("participants");
                            break;
                        }
                        case 2: {
                            room.setCanSendPrivateMessage("moderators");
                            break;
                        }
                        case 3: {
                            room.setCanSendPrivateMessage("none");
                        }
                    }
                    room.setPersistent(true);
                    rooms.put(room.getID(), room);
                }
                catch (SQLException e) {
                    Log.error("A database exception prevented one particular MUC room to be loaded from the database.", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DbConnectionManager.closeConnection(resultSet, statement, connection);
            throw throwable;
        }
        DbConnectionManager.closeConnection(resultSet, statement, connection);
        return rooms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadHistory(Long serviceID, Map<Long, LocalMUCRoom> rooms) throws SQLException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbConnectionManager.getConnection();
            statement = connection.prepareStatement(LOAD_ALL_HISTORY);
            long from = 0L;
            String reloadLimit = JiveGlobals.getProperty(MUC_HISTORY_RELOAD_LIMIT);
            if (reloadLimit != null) {
                int reloadLimitDays = JiveGlobals.getIntProperty(MUC_HISTORY_RELOAD_LIMIT, 2);
                Log.warn("MUC history reload limit set to " + reloadLimitDays + " days");
                from = System.currentTimeMillis() - BigInteger.valueOf(86400000L).multiply(BigInteger.valueOf(reloadLimitDays)).longValue();
            }
            statement.setLong(1, serviceID);
            statement.setString(2, StringUtils.dateToMillis(new Date(from)));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                try {
                    LocalMUCRoom room = rooms.get(resultSet.getLong(1));
                    if (room == null || !room.isLogEnabled()) continue;
                    String senderJID = resultSet.getString(2);
                    String nickname = resultSet.getString(3);
                    Date sentDate = new Date(Long.parseLong(resultSet.getString(4).trim()));
                    String subject = resultSet.getString(5);
                    String body = resultSet.getString(6);
                    String stanza = resultSet.getString(7);
                    room.getRoomHistory().addOldMessage(senderJID, nickname, sentDate, subject, body, stanza);
                }
                catch (SQLException e) {
                    Log.warn("A database exception prevented the history for one particular MUC room to be loaded from the database.", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DbConnectionManager.closeConnection(resultSet, statement, connection);
            throw throwable;
        }
        DbConnectionManager.closeConnection(resultSet, statement, connection);
        for (MUCRoom mUCRoom : rooms.values()) {
            if (mUCRoom.getRoomHistory().hasChangedSubject() || mUCRoom.getSubject() == null || mUCRoom.getSubject().length() <= 0) continue;
            mUCRoom.getRoomHistory().addOldMessage(mUCRoom.getRole().getRoleAddress().toString(), null, mUCRoom.getModificationDate(), mUCRoom.getSubject(), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAffiliations(Long serviceID, Map<Long, LocalMUCRoom> rooms) throws SQLException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbConnectionManager.getConnection();
            statement = connection.prepareStatement(LOAD_ALL_AFFILIATIONS);
            statement.setLong(1, serviceID);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                try {
                    JID affiliationJID;
                    long roomID = resultSet.getLong(1);
                    LocalMUCRoom room = rooms.get(roomID);
                    if (room == null) continue;
                    MUCRole.Affiliation affiliation = MUCRole.Affiliation.valueOf(resultSet.getInt(3));
                    String jidValue = resultSet.getString(2);
                    try {
                        affiliationJID = GroupJID.fromString(jidValue);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.warn("An illegal JID ({}) was found in the database, while trying to load all affiliations for room {}. The JID is ignored.", new Object[]{jidValue, roomID});
                        continue;
                    }
                    try {
                        switch (affiliation) {
                            case owner: {
                                room.addOwner(affiliationJID, room.getRole());
                                break;
                            }
                            case admin: {
                                room.addAdmin(affiliationJID, room.getRole());
                                break;
                            }
                            case outcast: {
                                room.addOutcast(affiliationJID, null, room.getRole());
                                break;
                            }
                            default: {
                                Log.error("Unknown affiliation value " + (Object)((Object)affiliation) + " for user " + affiliationJID + " in persistent room " + room.getID());
                                break;
                            }
                        }
                    }
                    catch (ConflictException | ForbiddenException | NotAllowedException e) {
                        Log.warn("An exception prevented affiliations to be added to the room with id " + roomID, (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    Log.error("A database exception prevented affiliations for one particular MUC room to be loaded from the database.", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DbConnectionManager.closeConnection(resultSet, statement, connection);
            throw throwable;
        }
        DbConnectionManager.closeConnection(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMembers(Long serviceID, Map<Long, LocalMUCRoom> rooms) throws SQLException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        JID affiliationJID = null;
        try {
            connection = DbConnectionManager.getConnection();
            statement = connection.prepareStatement(LOAD_ALL_MEMBERS);
            statement.setLong(1, serviceID);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                try {
                    LocalMUCRoom room = rooms.get(resultSet.getLong(1));
                    if (room == null) continue;
                    try {
                        affiliationJID = GroupJID.fromString(resultSet.getString(2));
                        room.addMember(affiliationJID, resultSet.getString(3), room.getRole());
                    }
                    catch (ConflictException | ForbiddenException e) {
                        Log.warn("Unable to add member to room.", (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    Log.error("A database exception prevented members for one particular MUC room to be loaded from the database.", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DbConnectionManager.closeConnection(resultSet, statement, connection);
            throw throwable;
        }
        DbConnectionManager.closeConnection(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRoomSubject(MUCRoom room) {
        if (!room.isPersistent() || !room.wasSavedToDB()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_SUBJECT);
            pstmt.setString(1, room.getSubject());
            pstmt.setLong(2, room.getID());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRoomLock(LocalMUCRoom room) {
        if (!room.isPersistent() || !room.wasSavedToDB()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_LOCK);
            pstmt.setString(1, StringUtils.dateToMillis(room.getLockedDate()));
            pstmt.setLong(2, room.getID());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRoomEmptyDate(MUCRoom room) {
        if (!room.isPersistent() || !room.wasSavedToDB()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_EMPTYDATE);
            Date emptyDate = room.getEmptyDate();
            if (emptyDate == null) {
                pstmt.setString(1, null);
            } else {
                pstmt.setString(1, StringUtils.dateToMillis(emptyDate));
            }
            pstmt.setLong(2, room.getID());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAffiliationToDB(MUCRoom room, JID jid, String nickname, MUCRole.Affiliation newAffiliation, MUCRole.Affiliation oldAffiliation) {
        block25: {
            String affiliationJid;
            block30: {
                block29: {
                    block28: {
                        block26: {
                            block27: {
                                affiliationJid = jid.toBareJID();
                                if (!room.isPersistent() || !room.wasSavedToDB()) {
                                    return;
                                }
                                if (MUCRole.Affiliation.none != oldAffiliation) break block26;
                                if (MUCRole.Affiliation.member != newAffiliation) break block27;
                                Connection con = null;
                                PreparedStatement pstmt = null;
                                try {
                                    con = DbConnectionManager.getConnection();
                                    pstmt = con.prepareStatement(ADD_MEMBER);
                                    pstmt.setLong(1, room.getID());
                                    pstmt.setString(2, affiliationJid);
                                    pstmt.setString(3, nickname);
                                    pstmt.executeUpdate();
                                }
                                catch (SQLException sqle) {
                                    try {
                                        Log.error(sqle.getMessage(), (Throwable)sqle);
                                    }
                                    catch (Throwable throwable) {
                                        DbConnectionManager.closeConnection(pstmt, con);
                                        throw throwable;
                                    }
                                    DbConnectionManager.closeConnection(pstmt, con);
                                    break block25;
                                }
                                DbConnectionManager.closeConnection(pstmt, con);
                                break block25;
                            }
                            Connection con = null;
                            PreparedStatement pstmt = null;
                            try {
                                con = DbConnectionManager.getConnection();
                                pstmt = con.prepareStatement(ADD_AFFILIATION);
                                pstmt.setLong(1, room.getID());
                                pstmt.setString(2, affiliationJid);
                                pstmt.setInt(3, newAffiliation.getValue());
                                pstmt.executeUpdate();
                            }
                            catch (SQLException sqle) {
                                try {
                                    Log.error(sqle.getMessage(), (Throwable)sqle);
                                }
                                catch (Throwable throwable) {
                                    DbConnectionManager.closeConnection(pstmt, con);
                                    throw throwable;
                                }
                                DbConnectionManager.closeConnection(pstmt, con);
                                break block25;
                            }
                            DbConnectionManager.closeConnection(pstmt, con);
                            break block25;
                        }
                        if (MUCRole.Affiliation.member != newAffiliation || MUCRole.Affiliation.member != oldAffiliation) break block28;
                        Connection con = null;
                        PreparedStatement pstmt = null;
                        try {
                            con = DbConnectionManager.getConnection();
                            pstmt = con.prepareStatement(UPDATE_MEMBER);
                            pstmt.setString(1, nickname);
                            pstmt.setLong(2, room.getID());
                            pstmt.setString(3, affiliationJid);
                            pstmt.executeUpdate();
                        }
                        catch (SQLException sqle) {
                            try {
                                Log.error(sqle.getMessage(), (Throwable)sqle);
                            }
                            catch (Throwable throwable) {
                                DbConnectionManager.closeConnection(pstmt, con);
                                throw throwable;
                            }
                            DbConnectionManager.closeConnection(pstmt, con);
                            break block25;
                        }
                        DbConnectionManager.closeConnection(pstmt, con);
                        break block25;
                    }
                    if (MUCRole.Affiliation.member != newAffiliation) break block29;
                    Connection con = null;
                    PreparedStatement pstmt = null;
                    boolean abortTransaction = false;
                    try {
                        con = DbConnectionManager.getTransactionConnection();
                        pstmt = con.prepareStatement(DELETE_AFFILIATION);
                        pstmt.setLong(1, room.getID());
                        pstmt.setString(2, affiliationJid);
                        pstmt.executeUpdate();
                        DbConnectionManager.fastcloseStmt(pstmt);
                        pstmt = con.prepareStatement(ADD_MEMBER);
                        pstmt.setLong(1, room.getID());
                        pstmt.setString(2, affiliationJid);
                        pstmt.setString(3, nickname);
                        pstmt.executeUpdate();
                    }
                    catch (SQLException sqle) {
                        try {
                            Log.error(sqle.getMessage(), (Throwable)sqle);
                            abortTransaction = true;
                        }
                        catch (Throwable throwable) {
                            DbConnectionManager.closeStatement(pstmt);
                            DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                            throw throwable;
                        }
                        DbConnectionManager.closeStatement(pstmt);
                        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                        break block25;
                    }
                    DbConnectionManager.closeStatement(pstmt);
                    DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                    break block25;
                }
                if (MUCRole.Affiliation.member != oldAffiliation) break block30;
                Connection con = null;
                PreparedStatement pstmt = null;
                boolean abortTransaction = false;
                try {
                    con = DbConnectionManager.getTransactionConnection();
                    pstmt = con.prepareStatement(DELETE_MEMBER);
                    pstmt.setLong(1, room.getID());
                    pstmt.setString(2, affiliationJid);
                    pstmt.executeUpdate();
                    DbConnectionManager.fastcloseStmt(pstmt);
                    pstmt = con.prepareStatement(ADD_AFFILIATION);
                    pstmt.setLong(1, room.getID());
                    pstmt.setString(2, affiliationJid);
                    pstmt.setInt(3, newAffiliation.getValue());
                    pstmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    try {
                        Log.error(sqle.getMessage(), (Throwable)sqle);
                        abortTransaction = true;
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeStatement(pstmt);
                        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                        throw throwable;
                    }
                    DbConnectionManager.closeStatement(pstmt);
                    DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                    break block25;
                }
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                break block25;
            }
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(UPDATE_AFFILIATION);
                pstmt.setInt(1, newAffiliation.getValue());
                pstmt.setLong(2, room.getID());
                pstmt.setString(3, affiliationJid);
                pstmt.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    Log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(pstmt, con);
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAffiliationFromDB(MUCRoom room, JID jid, MUCRole.Affiliation oldAffiliation) {
        block8: {
            String affiliationJID;
            block9: {
                affiliationJID = jid.toBareJID();
                if (!room.isPersistent() || !room.wasSavedToDB()) break block8;
                if (MUCRole.Affiliation.member != oldAffiliation) break block9;
                Connection con = null;
                PreparedStatement pstmt = null;
                try {
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement(DELETE_MEMBER);
                    pstmt.setLong(1, room.getID());
                    pstmt.setString(2, affiliationJID);
                    pstmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    try {
                        Log.error(sqle.getMessage(), (Throwable)sqle);
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(pstmt, con);
                        throw throwable;
                    }
                    DbConnectionManager.closeConnection(pstmt, con);
                    break block8;
                }
                DbConnectionManager.closeConnection(pstmt, con);
                break block8;
            }
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(DELETE_AFFILIATION);
                pstmt.setLong(1, room.getID());
                pstmt.setString(2, affiliationJID);
                pstmt.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    Log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(pstmt, con);
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAffiliationFromDB(JID affiliationJID) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_USER_MEMBER);
            pstmt.setString(1, affiliationJID.toBareJID());
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_USER_MUCAFFILIATION);
            pstmt.setString(1, affiliationJID.toBareJID());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveConversationLogEntry(ConversationLogEntry entry) {
        boolean bl;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(ADD_CONVERSATION_LOG);
            pstmt.setLong(1, entry.getRoomID());
            pstmt.setString(2, entry.getSender().toString());
            pstmt.setString(3, entry.getNickname());
            pstmt.setString(4, StringUtils.dateToMillis(entry.getDate()));
            pstmt.setString(5, entry.getSubject());
            pstmt.setString(6, entry.getBody());
            pstmt.setString(7, entry.getStanza());
            pstmt.executeUpdate();
            bl = true;
        }
        catch (SQLException sqle) {
            boolean bl2;
            try {
                Log.error("Error saving conversation log entry", (Throwable)sqle);
                bl2 = false;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
            return bl2;
        }
        DbConnectionManager.closeConnection(pstmt, con);
        return bl;
    }

    private static int marshallRolesToBroadcast(MUCRoom room) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(room.canBroadcastPresence("moderator") ? "1" : "0");
        buffer.append(room.canBroadcastPresence("participant") ? "1" : "0");
        buffer.append(room.canBroadcastPresence("visitor") ? "1" : "0");
        return Integer.parseInt(buffer.toString(), 2);
    }

    public static String getProperty(String subdomain, String name) {
        MUCServiceProperties newProps = new MUCServiceProperties(subdomain);
        MUCServiceProperties oldProps = propertyMaps.putIfAbsent(subdomain, newProps);
        if (oldProps != null) {
            return oldProps.get(name);
        }
        return newProps.get(name);
    }

    public static String getProperty(String subdomain, String name, String defaultValue) {
        String value = MUCPersistenceManager.getProperty(subdomain, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static int getIntProperty(String subdomain, String name, int defaultValue) {
        String value = MUCPersistenceManager.getProperty(subdomain, name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongProperty(String subdomain, String name, long defaultValue) {
        String value = MUCPersistenceManager.getProperty(subdomain, name);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(String subdomain, String name) {
        return Boolean.valueOf(MUCPersistenceManager.getProperty(subdomain, name));
    }

    public static boolean getBooleanProperty(String subdomain, String name, boolean defaultValue) {
        String value = MUCPersistenceManager.getProperty(subdomain, name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    public static List<String> getPropertyNames(String subdomain, String parent) {
        MUCServiceProperties properties = new MUCServiceProperties(subdomain);
        MUCServiceProperties oldProps = propertyMaps.putIfAbsent(subdomain, properties);
        if (oldProps != null) {
            properties = oldProps;
        }
        return new ArrayList<String>(properties.getChildrenNames(parent));
    }

    public static List<String> getProperties(String subdomain, String parent) {
        MUCServiceProperties properties = new MUCServiceProperties(subdomain);
        MUCServiceProperties oldProps = propertyMaps.putIfAbsent(subdomain, properties);
        if (oldProps != null) {
            properties = oldProps;
        }
        Collection<String> propertyNames = properties.getChildrenNames(parent);
        ArrayList<String> values = new ArrayList<String>();
        for (String propertyName : propertyNames) {
            String value = MUCPersistenceManager.getProperty(subdomain, propertyName);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static List<String> getPropertyNames(String subdomain) {
        MUCServiceProperties properties = new MUCServiceProperties(subdomain);
        MUCServiceProperties oldProps = propertyMaps.putIfAbsent(subdomain, properties);
        if (oldProps != null) {
            properties = oldProps;
        }
        return new ArrayList<String>(properties.getPropertyNames());
    }

    public static void setProperty(String subdomain, String name, String value) {
        MUCServiceProperties properties = propertyMaps.get(subdomain);
        if (properties == null) {
            properties = new MUCServiceProperties(subdomain);
        }
        properties.put(name, value);
        propertyMaps.put(subdomain, properties);
    }

    public static void setLocalProperty(String subdomain, String name, String value) {
        MUCServiceProperties properties = propertyMaps.get(subdomain);
        if (properties == null) {
            properties = new MUCServiceProperties(subdomain);
        }
        properties.localPut(name, value);
        propertyMaps.put(subdomain, properties);
    }

    public static void setProperties(String subdomain, Map<String, String> propertyMap) {
        MUCServiceProperties properties = propertyMaps.get(subdomain);
        if (properties == null) {
            properties = new MUCServiceProperties(subdomain);
        }
        properties.putAll((Map<? extends String, ? extends String>)propertyMap);
        propertyMaps.put(subdomain, properties);
    }

    public static void deleteProperty(String subdomain, String name) {
        MUCServiceProperties properties = propertyMaps.get(subdomain);
        if (properties == null) {
            properties = new MUCServiceProperties(subdomain);
        }
        properties.remove(name);
        propertyMaps.put(subdomain, properties);
    }

    public static void deleteLocalProperty(String subdomain, String name) {
        MUCServiceProperties properties = propertyMaps.get(subdomain);
        if (properties == null) {
            properties = new MUCServiceProperties(subdomain);
        }
        properties.localRemove(name);
        propertyMaps.put(subdomain, properties);
    }

    public static void refreshProperties(String subdomain) {
        propertyMaps.replace(subdomain, new MUCServiceProperties(subdomain));
    }
}

