/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.muc.spi.LocalMUCUser;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.ElementUtil;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class LocalMUCRole
implements MUCRole {
    private LocalMUCRoom room;
    private LocalMUCUser user;
    private String nick;
    private Presence presence;
    private MultiUserChatService server;
    private MUCRole.Role role;
    private MUCRole.Affiliation affiliation;
    private boolean voiceOnly = false;
    private PacketRouter router;
    private JID rJID;
    private Element extendedInformation;
    private ClientSession session;

    public LocalMUCRole(MultiUserChatService chatserver, LocalMUCRoom chatroom, String nickname, MUCRole.Role role, MUCRole.Affiliation affiliation, LocalMUCUser chatuser, Presence presence, PacketRouter packetRouter) {
        this.room = chatroom;
        this.nick = nickname;
        this.user = chatuser;
        this.server = chatserver;
        this.router = packetRouter;
        this.role = role;
        this.affiliation = affiliation;
        this.session = XMPPServer.getInstance().getSessionManager().getSession(presence.getFrom());
        this.extendedInformation = DocumentHelper.createElement((QName)QName.get((String)"x", (String)"http://jabber.org/protocol/muc#user"));
        this.calculateExtendedInformation();
        this.rJID = new JID(this.room.getName(), this.server.getServiceDomain(), this.nick);
        this.setPresence(presence);
        Element element = presence.getElement().element(QName.get((String)"x", (String)"http://jivesoftware.org/protocol/muc"));
        if (element != null) {
            this.voiceOnly = element.element("deaf-occupant") != null;
        }
        this.user.addRole(this.room.getName(), this);
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public void setPresence(Presence newPresence) {
        Element element = newPresence.getElement().element(QName.get((String)"x", (String)"http://jabber.org/protocol/muc"));
        if (element != null) {
            newPresence.getElement().remove(element);
        }
        this.presence = newPresence;
        this.presence.setFrom(this.getRoleAddress());
        this.updatePresence();
    }

    @Override
    public void setRole(MUCRole.Role newRole) throws NotAllowedException {
        if ((MUCRole.Affiliation.owner == this.affiliation || MUCRole.Affiliation.admin == this.affiliation) && MUCRole.Role.moderator != newRole) {
            throw new NotAllowedException();
        }
        if (MUCRole.Role.moderator == this.role && MUCRole.Role.none == newRole && MUCRole.Affiliation.none != this.affiliation) {
            throw new NotAllowedException();
        }
        this.role = newRole;
        if (MUCRole.Role.none == this.role) {
            this.presence.setType(Presence.Type.unavailable);
            this.presence.setStatus(null);
        }
        this.calculateExtendedInformation();
    }

    @Override
    public MUCRole.Role getRole() {
        return this.role;
    }

    @Override
    public void setAffiliation(MUCRole.Affiliation newAffiliation) throws NotAllowedException {
        if ((MUCRole.Affiliation.owner == this.affiliation || MUCRole.Affiliation.admin == this.affiliation) && MUCRole.Affiliation.outcast == newAffiliation) {
            throw new NotAllowedException();
        }
        this.affiliation = newAffiliation;
        this.calculateExtendedInformation();
    }

    @Override
    public MUCRole.Affiliation getAffiliation() {
        return this.affiliation;
    }

    @Override
    public String getNickname() {
        return this.nick;
    }

    @Override
    public void changeNickname(String nickname) {
        this.nick = nickname;
        this.setRoleAddress(new JID(this.room.getName(), this.server.getServiceDomain(), this.nick));
    }

    @Override
    public void destroy() {
        this.user.removeRole(this.room.getName());
    }

    @Override
    public MUCRoom getChatRoom() {
        return this.room;
    }

    @Override
    public JID getRoleAddress() {
        return this.rJID;
    }

    @Override
    public JID getUserAddress() {
        return this.user.getAddress();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public NodeID getNodeID() {
        return XMPPServer.getInstance().getNodeID();
    }

    private void setRoleAddress(JID jid) {
        this.rJID = jid;
        this.presence.setFrom(jid);
    }

    @Override
    public boolean isVoiceOnly() {
        return this.voiceOnly;
    }

    @Override
    public void send(Packet packet) {
        if (packet == null) {
            return;
        }
        packet.setTo(this.user.getAddress());
        if (this.session != null && this.session.getStatus() == 3) {
            this.session.process(packet);
        } else {
            this.router.route(packet);
        }
    }

    private void calculateExtendedInformation() {
        ElementUtil.setProperty(this.extendedInformation, "x.item:jid", this.user.getAddress().toString());
        ElementUtil.setProperty(this.extendedInformation, "x.item:affiliation", this.affiliation.toString());
        ElementUtil.setProperty(this.extendedInformation, "x.item:role", this.role.toString());
        this.updatePresence();
    }

    private void updatePresence() {
        if (this.extendedInformation != null && this.presence != null) {
            Element mucUser = this.presence.getElement().element(QName.get((String)"x", (String)"http://jabber.org/protocol/muc#user"));
            if (mucUser != null) {
                this.presence.getElement().remove(mucUser);
            }
            Element exi = this.extendedInformation.createCopy();
            this.presence.getElement().add(exi);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nick == null ? 0 : this.nick.hashCode());
        result = 31 * result + (this.rJID == null ? 0 : this.rJID.hashCode());
        result = 31 * result + (this.room == null ? 0 : this.room.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalMUCRole other = (LocalMUCRole)obj;
        if (this.nick == null ? other.nick != null : !this.nick.equals(other.nick)) {
            return false;
        }
        if (this.rJID == null ? other.rJID != null : !this.rJID.equals((Object)other.rJID)) {
            return false;
        }
        if (this.room == null ? other.room != null : !this.room.equals(other.room)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

