/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.ArrayList;
import java.util.Date;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.muc.CannotBeInvitedException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.NotAcceptableException;
import org.jivesoftware.openfire.muc.cluster.RoomUpdatedEvent;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.openfire.muc.spi.MultiUserChatServiceImpl;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class IQOwnerHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQOwnerHandler.class);
    private final LocalMUCRoom room;
    private final PacketRouter router;
    private DataForm configurationForm;
    private Element probeResult;
    private final boolean skipInvite;

    public IQOwnerHandler(LocalMUCRoom chatroom, PacketRouter packetRouter) {
        this.room = chatroom;
        this.router = packetRouter;
        this.skipInvite = JiveGlobals.getBooleanProperty("xmpp.muc.skipInvite", false);
        this.init();
    }

    public void handleIQ(IQ packet, MUCRole role) throws ForbiddenException, ConflictException, CannotBeInvitedException, NotAcceptableException {
        if (MUCRole.Affiliation.owner != role.getAffiliation()) {
            throw new ForbiddenException();
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element element = packet.getChildElement();
        Element formElement = element.element(QName.get((String)"x", (String)"jabber:x:data"));
        if (formElement != null) {
            this.handleDataFormElement(role, formElement);
        } else {
            Element destroyElement = element.element("destroy");
            if (destroyElement != null) {
                if (((MultiUserChatServiceImpl)this.room.getMUCService()).getMUCDelegate() != null && !((MultiUserChatServiceImpl)this.room.getMUCService()).getMUCDelegate().destroyingRoom(this.room.getName(), role.getUserAddress())) {
                    throw new ForbiddenException();
                }
                JID alternateJID = null;
                String jid = destroyElement.attributeValue("jid");
                if (jid != null) {
                    alternateJID = new JID(jid);
                }
                this.room.destroyRoom(alternateJID, destroyElement.elementTextTrim("reason"));
            } else if (!element.elementIterator().hasNext()) {
                this.refreshConfigurationFormValues();
                reply.setChildElement(this.probeResult.createCopy());
            } else {
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.bad_request);
            }
        }
        if (reply.getTo() != null) {
            this.router.route(reply);
        }
    }

    private void handleDataFormElement(MUCRole senderRole, Element formElement) throws ForbiddenException, ConflictException, NotAcceptableException {
        DataForm completedForm = new DataForm(formElement);
        switch (completedForm.getType()) {
            case cancel: {
                if (!this.room.isLocked()) break;
                this.room.destroyRoom(null, null);
                break;
            }
            case submit: {
                if (!completedForm.getFields().isEmpty()) {
                    this.processConfigurationForm(completedForm, senderRole);
                }
                if (this.room.isLocked() && !this.room.isManuallyLocked()) {
                    this.room.unlock(senderRole);
                }
                if (this.room.isDestroyed) break;
                CacheFactory.doClusterTask(new RoomUpdatedEvent(this.room));
                break;
            }
            default: {
                Log.warn("cannot handle data form element: " + formElement.asXML());
            }
        }
    }

    private void processConfigurationForm(DataForm completedForm, MUCRole senderRole) throws ForbiddenException, ConflictException, NotAcceptableException {
        String value;
        String booleanValue;
        String value2;
        FormField field = completedForm.getField("muc#roomconfig_roomadmins");
        boolean adminsSent = field != null;
        ArrayList<JID> admins = new ArrayList<JID>();
        if (field != null) {
            for (String value3 : field.getValues()) {
                if (value3 == null || value3.trim().length() == 0) continue;
                admins.add(GroupJID.fromString(value3.trim()).asBareJID());
            }
        }
        boolean ownersSent = (field = completedForm.getField("muc#roomconfig_roomowners")) != null;
        ArrayList<JID> owners = new ArrayList<JID>();
        if (field != null) {
            for (String value22 : field.getValues()) {
                if (value22 == null || value22.trim().length() == 0) continue;
                owners.add(GroupJID.fromString(value22.trim()).asBareJID());
            }
        }
        if (ownersSent && owners.isEmpty()) {
            throw new ConflictException();
        }
        ArrayList<Presence> presences = new ArrayList<Presence>(admins.size() + owners.size());
        field = completedForm.getField("muc#roomconfig_roomname");
        if (field != null) {
            value2 = field.getFirstValue();
            this.room.setNaturalLanguageName(value2 != null ? value2 : " ");
        }
        if ((field = completedForm.getField("muc#roomconfig_roomdesc")) != null) {
            value2 = field.getFirstValue();
            this.room.setDescription(value2 != null ? value2 : " ");
        }
        if ((field = completedForm.getField("muc#roomconfig_changesubject")) != null) {
            value2 = field.getFirstValue();
            booleanValue = value2 != null ? value2 : "1";
            this.room.setCanOccupantsChangeSubject("1".equals(booleanValue));
        }
        if ((field = completedForm.getField("muc#roomconfig_maxusers")) != null) {
            value2 = field.getFirstValue();
            this.room.setMaxUsers(value2 != null ? Integer.parseInt(value2) : 30);
        }
        if ((field = completedForm.getField("muc#roomconfig_presencebroadcast")) != null) {
            ArrayList<String> values = new ArrayList<String>(field.getValues());
            this.room.setRolesToBroadcastPresence(values);
        }
        if ((field = completedForm.getField("muc#roomconfig_publicroom")) != null) {
            value2 = field.getFirstValue();
            booleanValue = value2 != null ? value2 : "1";
            this.room.setPublicRoom("1".equals(booleanValue));
        }
        if ((field = completedForm.getField("muc#roomconfig_persistentroom")) != null) {
            value2 = field.getFirstValue();
            booleanValue = value2 != null ? value2 : "1";
            boolean isPersistent = "1".equals(booleanValue);
            if (this.room.isPersistent() && !isPersistent) {
                MUCPersistenceManager.deleteFromDB(this.room);
            }
            this.room.setPersistent(isPersistent);
        }
        if ((field = completedForm.getField("muc#roomconfig_moderatedroom")) != null) {
            value2 = field.getFirstValue();
            booleanValue = value2 != null ? value2 : "1";
            this.room.setModerated("1".equals(booleanValue));
        }
        if ((field = completedForm.getField("muc#roomconfig_membersonly")) != null) {
            value2 = field.getFirstValue();
            booleanValue = value2 != null ? value2 : "1";
            presences.addAll(this.room.setMembersOnly("1".equals(booleanValue)));
        }
        if ((field = completedForm.getField("muc#roomconfig_allowinvites")) != null) {
            value2 = field.getFirstValue();
            booleanValue = value2 != null ? value2 : "1";
            this.room.setCanOccupantsInvite("1".equals(booleanValue));
        }
        boolean passwordProtectionChanged = false;
        boolean passwordChanged = false;
        boolean updatedIsPasswordProtected = false;
        String updatedPassword = null;
        field = completedForm.getField("muc#roomconfig_passwordprotectedroom");
        if (field != null) {
            passwordProtectionChanged = true;
            value = field.getFirstValue();
            booleanValue = value != null ? value : "1";
            updatedIsPasswordProtected = "1".equals(booleanValue);
        }
        if ((field = completedForm.getField("muc#roomconfig_roomsecret")) != null) {
            passwordChanged = true;
            updatedPassword = completedForm.getField("muc#roomconfig_roomsecret").getFirstValue();
            if (updatedPassword != null && updatedPassword.isEmpty()) {
                updatedPassword = null;
            }
        }
        if (passwordProtectionChanged) {
            if (!updatedIsPasswordProtected) {
                this.room.setPassword(null);
            } else {
                if (updatedPassword == null && this.room.getPassword() == null) {
                    throw new NotAcceptableException("Room is made password-protected, but is missing a password.");
                }
                if (updatedPassword != null) {
                    this.room.setPassword(updatedPassword);
                }
            }
        } else if (passwordChanged) {
            this.room.setPassword(updatedPassword);
        }
        field = completedForm.getField("muc#roomconfig_whois");
        if (field != null) {
            value = field.getFirstValue();
            booleanValue = value != null ? value : "1";
            this.room.setCanAnyoneDiscoverJID("anyone".equals(booleanValue));
        }
        if ((field = completedForm.getField("muc#roomconfig_allowpm")) != null) {
            value = field.getFirstValue();
            this.room.setCanSendPrivateMessage(value);
        }
        if ((field = completedForm.getField("muc#roomconfig_enablelogging")) != null) {
            value = field.getFirstValue();
            booleanValue = value != null ? value : "1";
            this.room.setLogEnabled("1".equals(booleanValue));
        }
        if ((field = completedForm.getField("x-muc#roomconfig_reservednick")) != null) {
            value = field.getFirstValue();
            booleanValue = value != null ? value : "1";
            this.room.setLoginRestrictedToNickname("1".equals(booleanValue));
        }
        if ((field = completedForm.getField("x-muc#roomconfig_canchangenick")) != null) {
            value = field.getFirstValue();
            booleanValue = value != null ? value : "1";
            this.room.setChangeNickname("1".equals(booleanValue));
        }
        if ((field = completedForm.getField("x-muc#roomconfig_registration")) != null) {
            value = field.getFirstValue();
            booleanValue = value != null ? value : "1";
            this.room.setRegistrationEnabled("1".equals(booleanValue));
        }
        this.room.setModificationDate(new Date());
        if (this.room.isPersistent()) {
            this.room.saveToDB();
        }
        presences.addAll(this.room.addOwners(owners, senderRole));
        presences.addAll(this.room.addAdmins(admins, senderRole));
        if (ownersSent) {
            ArrayList<JID> ownersToRemove = new ArrayList<JID>(this.room.owners);
            ownersToRemove.removeAll(admins);
            ownersToRemove.removeAll(owners);
            for (JID jid : ownersToRemove) {
                if (GroupJID.isGroup(jid)) continue;
                presences.addAll(this.room.addMember(jid, null, senderRole));
            }
        }
        if (adminsSent) {
            ArrayList<JID> adminsToRemove = new ArrayList<JID>(this.room.admins);
            adminsToRemove.removeAll(admins);
            adminsToRemove.removeAll(owners);
            for (JID jid : adminsToRemove) {
                if (GroupJID.isGroup(jid)) continue;
                presences.addAll(this.room.addMember(jid, null, senderRole));
            }
        }
        if (!this.room.isPersistent() && this.room.getOccupantsCount() == 0) {
            this.room.destroyRoom(null, null);
        }
        for (Object e : presences) {
            this.room.send((Packet)((Presence)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfigurationFormValues() {
        this.room.lock.readLock().lock();
        try {
            Group group;
            FormField field = this.configurationForm.getField("muc#roomconfig_roomname");
            field.clearValues();
            field.addValue((Object)this.room.getNaturalLanguageName());
            field = this.configurationForm.getField("muc#roomconfig_roomdesc");
            field.clearValues();
            field.addValue((Object)this.room.getDescription());
            field = this.configurationForm.getField("muc#roomconfig_changesubject");
            field.clearValues();
            field.addValue((Object)(this.room.canOccupantsChangeSubject() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_maxusers");
            field.clearValues();
            field.addValue((Object)Integer.toString(this.room.getMaxUsers()));
            field = this.configurationForm.getField("muc#roomconfig_presencebroadcast");
            field.clearValues();
            for (String roleToBroadcast : this.room.getRolesToBroadcastPresence()) {
                field.addValue((Object)roleToBroadcast);
            }
            field = this.configurationForm.getField("muc#roomconfig_publicroom");
            field.clearValues();
            field.addValue((Object)(this.room.isPublicRoom() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_persistentroom");
            field.clearValues();
            field.addValue((Object)(this.room.isPersistent() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_moderatedroom");
            field.clearValues();
            field.addValue((Object)(this.room.isModerated() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_membersonly");
            field.clearValues();
            field.addValue((Object)(this.room.isMembersOnly() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_allowinvites");
            field.clearValues();
            field.addValue((Object)(this.room.canOccupantsInvite() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_passwordprotectedroom");
            field.clearValues();
            field.addValue((Object)(this.room.isPasswordProtected() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_roomsecret");
            field.clearValues();
            field.addValue((Object)this.room.getPassword());
            field = this.configurationForm.getField("muc#roomconfig_whois");
            field.clearValues();
            field.addValue((Object)(this.room.canAnyoneDiscoverJID() ? "anyone" : "moderators"));
            field = this.configurationForm.getField("muc#roomconfig_allowpm");
            field.clearValues();
            field.addValue((Object)this.room.canSendPrivateMessage());
            field = this.configurationForm.getField("muc#roomconfig_enablelogging");
            field.clearValues();
            field.addValue((Object)(this.room.isLogEnabled() ? "1" : "0"));
            field = this.configurationForm.getField("x-muc#roomconfig_reservednick");
            field.clearValues();
            field.addValue((Object)(this.room.isLoginRestrictedToNickname() ? "1" : "0"));
            field = this.configurationForm.getField("x-muc#roomconfig_canchangenick");
            field.clearValues();
            field.addValue((Object)(this.room.canChangeNickname() ? "1" : "0"));
            field = this.configurationForm.getField("x-muc#roomconfig_registration");
            field.clearValues();
            field.addValue((Object)(this.room.isRegistrationEnabled() ? "1" : "0"));
            field = this.configurationForm.getField("muc#roomconfig_roomadmins");
            field.clearValues();
            for (JID jid : this.room.getAdmins()) {
                if (GroupJID.isGroup(jid)) {
                    try {
                        group = GroupManager.getInstance().getGroup(jid);
                        for (JID groupMember : group.getAll()) {
                            field.addValue((Object)groupMember);
                        }
                        continue;
                    }
                    catch (GroupNotFoundException gnfe) {
                        Log.warn("Invalid group JID in the member list: " + jid);
                        continue;
                    }
                }
                field.addValue((Object)jid.toString());
            }
            field = this.configurationForm.getField("muc#roomconfig_roomowners");
            field.clearValues();
            for (JID jid : this.room.getOwners()) {
                if (GroupJID.isGroup(jid)) {
                    try {
                        group = GroupManager.getInstance().getGroup(jid);
                        for (JID groupMember : group.getAll()) {
                            field.addValue((Object)groupMember);
                        }
                        continue;
                    }
                    catch (GroupNotFoundException gnfe) {
                        Log.warn("Invalid group JID in the member list: " + jid);
                        continue;
                    }
                }
                field.addValue((Object)jid.toString());
            }
            this.probeResult.remove(this.probeResult.element(QName.get((String)"x", (String)"jabber:x:data")));
            this.probeResult.add(this.configurationForm.getElement());
        }
        finally {
            this.room.lock.readLock().unlock();
        }
    }

    private void init() {
        Element element = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"http://jabber.org/protocol/muc#owner"));
        this.configurationForm = new DataForm(DataForm.Type.form);
        this.configurationForm.setTitle(LocaleUtils.getLocalizedString("muc.form.conf.title"));
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.room.getName());
        this.configurationForm.addInstruction(LocaleUtils.getLocalizedString("muc.form.conf.instruction", params));
        this.configurationForm.addField("FORM_TYPE", null, FormField.Type.hidden).addValue((Object)"http://jabber.org/protocol/muc#roomconfig");
        this.configurationForm.addField("muc#roomconfig_roomname", LocaleUtils.getLocalizedString("muc.form.conf.owner_roomname"), FormField.Type.text_single);
        this.configurationForm.addField("muc#roomconfig_roomdesc", LocaleUtils.getLocalizedString("muc.form.conf.owner_roomdesc"), FormField.Type.text_single);
        this.configurationForm.addField("muc#roomconfig_changesubject", LocaleUtils.getLocalizedString("muc.form.conf.owner_changesubject"), FormField.Type.boolean_type);
        FormField maxUsers = this.configurationForm.addField("muc#roomconfig_maxusers", LocaleUtils.getLocalizedString("muc.form.conf.owner_maxusers"), FormField.Type.list_single);
        maxUsers.addOption("10", "10");
        maxUsers.addOption("20", "20");
        maxUsers.addOption("30", "30");
        maxUsers.addOption("40", "40");
        maxUsers.addOption("50", "50");
        maxUsers.addOption(LocaleUtils.getLocalizedString("muc.form.conf.none"), "0");
        FormField broadcast = this.configurationForm.addField("muc#roomconfig_presencebroadcast", LocaleUtils.getLocalizedString("muc.form.conf.owner_presencebroadcast"), FormField.Type.list_multi);
        broadcast.addOption(LocaleUtils.getLocalizedString("muc.form.conf.moderator"), "moderator");
        broadcast.addOption(LocaleUtils.getLocalizedString("muc.form.conf.participant"), "participant");
        broadcast.addOption(LocaleUtils.getLocalizedString("muc.form.conf.visitor"), "visitor");
        this.configurationForm.addField("muc#roomconfig_publicroom", LocaleUtils.getLocalizedString("muc.form.conf.owner_publicroom"), FormField.Type.boolean_type);
        this.configurationForm.addField("muc#roomconfig_persistentroom", LocaleUtils.getLocalizedString("muc.form.conf.owner_persistentroom"), FormField.Type.boolean_type);
        this.configurationForm.addField("muc#roomconfig_moderatedroom", LocaleUtils.getLocalizedString("muc.form.conf.owner_moderatedroom"), FormField.Type.boolean_type);
        this.configurationForm.addField("muc#roomconfig_membersonly", LocaleUtils.getLocalizedString("muc.form.conf.owner_membersonly"), FormField.Type.boolean_type);
        this.configurationForm.addField(null, null, FormField.Type.fixed).addValue((Object)LocaleUtils.getLocalizedString("muc.form.conf.allowinvitesfixed"));
        this.configurationForm.addField("muc#roomconfig_allowinvites", LocaleUtils.getLocalizedString("muc.form.conf.owner_allowinvites"), FormField.Type.boolean_type);
        this.configurationForm.addField("muc#roomconfig_passwordprotectedroom", LocaleUtils.getLocalizedString("muc.form.conf.owner_passwordprotectedroom"), FormField.Type.boolean_type);
        this.configurationForm.addField(null, null, FormField.Type.fixed).addValue((Object)LocaleUtils.getLocalizedString("muc.form.conf.roomsecretfixed"));
        this.configurationForm.addField("muc#roomconfig_roomsecret", LocaleUtils.getLocalizedString("muc.form.conf.owner_roomsecret"), FormField.Type.text_private);
        FormField whois = this.configurationForm.addField("muc#roomconfig_whois", LocaleUtils.getLocalizedString("muc.form.conf.owner_whois"), FormField.Type.list_single);
        whois.addOption(LocaleUtils.getLocalizedString("muc.form.conf.moderator"), "moderators");
        whois.addOption(LocaleUtils.getLocalizedString("muc.form.conf.anyone"), "anyone");
        FormField allowpm = this.configurationForm.addField("muc#roomconfig_allowpm", LocaleUtils.getLocalizedString("muc.form.conf.owner_allowpm"), FormField.Type.list_single);
        allowpm.addOption(LocaleUtils.getLocalizedString("muc.form.conf.anyone"), "anyone");
        allowpm.addOption(LocaleUtils.getLocalizedString("muc.form.conf.moderator"), "moderators");
        allowpm.addOption(LocaleUtils.getLocalizedString("muc.form.conf.participant"), "participants");
        allowpm.addOption(LocaleUtils.getLocalizedString("muc.form.conf.none"), "none");
        this.configurationForm.addField("muc#roomconfig_enablelogging", LocaleUtils.getLocalizedString("muc.form.conf.owner_enablelogging"), FormField.Type.boolean_type);
        this.configurationForm.addField("x-muc#roomconfig_reservednick", LocaleUtils.getLocalizedString("muc.form.conf.owner_reservednick"), FormField.Type.boolean_type);
        this.configurationForm.addField("x-muc#roomconfig_canchangenick", LocaleUtils.getLocalizedString("muc.form.conf.owner_canchangenick"), FormField.Type.boolean_type);
        this.configurationForm.addField(null, null, FormField.Type.fixed).addValue((Object)LocaleUtils.getLocalizedString("muc.form.conf.owner_registration"));
        this.configurationForm.addField("x-muc#roomconfig_registration", LocaleUtils.getLocalizedString("muc.form.conf.owner_registration"), FormField.Type.boolean_type);
        this.configurationForm.addField(null, null, FormField.Type.fixed).addValue((Object)LocaleUtils.getLocalizedString("muc.form.conf.roomadminsfixed"));
        this.configurationForm.addField("muc#roomconfig_roomadmins", LocaleUtils.getLocalizedString("muc.form.conf.owner_roomadmins"), FormField.Type.jid_multi);
        this.configurationForm.addField(null, null, FormField.Type.fixed).addValue((Object)LocaleUtils.getLocalizedString("muc.form.conf.roomownersfixed"));
        this.configurationForm.addField("muc#roomconfig_roomowners", LocaleUtils.getLocalizedString("muc.form.conf.owner_roomowners"), FormField.Type.jid_multi);
        this.probeResult = element;
        this.probeResult.add(this.configurationForm.getElement());
    }
}

