/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.cluster.MUCRoomTask;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.Presence;

public class UpdateOccupant
extends MUCRoomTask<Void> {
    private Presence presence;
    private String nickname;
    private int role;
    private int affiliation;

    public UpdateOccupant() {
    }

    public UpdateOccupant(LocalMUCRoom room, MUCRole role) {
        super(room);
        this.presence = role.getPresence();
        this.nickname = role.getNickname();
        this.role = role.getRole().ordinal();
        this.affiliation = role.getAffiliation().ordinal();
    }

    public Presence getPresence() {
        return this.presence;
    }

    public String getNickname() {
        return this.nickname;
    }

    public MUCRole.Role getRole() {
        return MUCRole.Role.values()[this.role];
    }

    public MUCRole.Affiliation getAffiliation() {
        return MUCRole.Affiliation.values()[this.affiliation];
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                UpdateOccupant.this.getRoom().occupantUpdated(UpdateOccupant.this);
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((DefaultElement)this.presence.getElement()));
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.nickname);
        ExternalizableUtil.getInstance().writeInt(out, this.role);
        ExternalizableUtil.getInstance().writeInt(out, this.affiliation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Element packetElement = (Element)ExternalizableUtil.getInstance().readSerializable(in);
        this.presence = new Presence(packetElement, true);
        this.nickname = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.role = ExternalizableUtil.getInstance().readInt(in);
        this.affiliation = ExternalizableUtil.getInstance().readInt(in);
    }
}

