/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.openfire.muc.spi.MultiUserChatServiceImpl;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUpdatedEvent
implements ClusterTask<Void> {
    private static final Logger Log = LoggerFactory.getLogger(ServiceUpdatedEvent.class);
    private String subdomain;

    public ServiceUpdatedEvent() {
    }

    public ServiceUpdatedEvent(String subdomain) {
        this.subdomain = subdomain;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        MultiUserChatService service = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(this.subdomain);
        if (service != null) {
            if (service instanceof MultiUserChatServiceImpl) {
                MUCPersistenceManager.refreshProperties(this.subdomain);
                ((MultiUserChatServiceImpl)service).initializeSettings();
            }
        } else {
            Log.warn("ServiceUpdatedEvent: Received update for service we are not running: " + this.subdomain);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.subdomain);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.subdomain = ExternalizableUtil.getInstance().readSafeUTF(in);
    }
}

