/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.database.JiveID;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.muc.CannotBeInvitedException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.HistoryRequest;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoomHistory;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAcceptableException;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.RegistrationRequiredException;
import org.jivesoftware.openfire.muc.RoomLockedException;
import org.jivesoftware.openfire.muc.ServiceUnavailableException;
import org.jivesoftware.openfire.muc.spi.IQAdminHandler;
import org.jivesoftware.openfire.muc.spi.IQOwnerHandler;
import org.jivesoftware.openfire.muc.spi.LocalMUCRole;
import org.jivesoftware.openfire.muc.spi.LocalMUCUser;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.NotFoundException;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.resultsetmanagement.Result;

@JiveID(value=23)
public interface MUCRoom
extends Externalizable,
Result {
    public String getName();

    public JID getJID();

    public long getID();

    public void setID(long var1);

    public MultiUserChatService getMUCService();

    public void setMUCService(MultiUserChatService var1);

    public Date getCreationDate();

    public void setCreationDate(Date var1);

    public Date getModificationDate();

    public void setModificationDate(Date var1);

    public void setEmptyDate(Date var1);

    public Date getEmptyDate();

    public MUCRole getRole();

    public MUCRole getOccupant(String var1) throws UserNotFoundException;

    public List<MUCRole> getOccupantsByNickname(String var1) throws UserNotFoundException;

    public List<MUCRole> getOccupantsByBareJID(JID var1) throws UserNotFoundException;

    public MUCRole getOccupantByFullJID(JID var1);

    public Collection<MUCRole> getOccupants();

    public int getOccupantsCount();

    public boolean hasOccupant(String var1);

    public String getReservedNickname(JID var1);

    public MUCRole.Affiliation getAffiliation(JID var1);

    public LocalMUCRole joinRoom(String var1, String var2, HistoryRequest var3, LocalMUCUser var4, Presence var5) throws UnauthorizedException, UserAlreadyExistsException, RoomLockedException, ForbiddenException, RegistrationRequiredException, ConflictException, ServiceUnavailableException, NotAcceptableException;

    public void leaveRoom(MUCRole var1);

    public void destroyRoom(JID var1, String var2);

    public Presence createPresence(Presence.Type var1) throws UnauthorizedException;

    public void serverBroadcast(String var1);

    public long getChatLength();

    public void addFirstOwner(JID var1);

    public List<Presence> addOwner(JID var1, MUCRole var2) throws ForbiddenException;

    public List<Presence> addOwners(List<JID> var1, MUCRole var2) throws ForbiddenException;

    public List<Presence> addAdmins(List<JID> var1, MUCRole var2) throws ForbiddenException, ConflictException;

    public List<Presence> addAdmin(JID var1, MUCRole var2) throws ForbiddenException, ConflictException;

    public List<Presence> addMember(JID var1, String var2, MUCRole var3) throws ForbiddenException, ConflictException;

    public List<Presence> addOutcast(JID var1, String var2, MUCRole var3) throws NotAllowedException, ForbiddenException, ConflictException;

    public List<Presence> addNone(JID var1, MUCRole var2) throws ForbiddenException, ConflictException;

    public Presence addModerator(JID var1, MUCRole var2) throws ForbiddenException;

    public Presence addParticipant(JID var1, String var2, MUCRole var3) throws NotAllowedException, ForbiddenException;

    public Presence addVisitor(JID var1, MUCRole var2) throws NotAllowedException, ForbiddenException;

    public boolean isLocked();

    public boolean isManuallyLocked();

    public void presenceUpdated(MUCRole var1, Presence var2);

    public void nicknameChanged(MUCRole var1, Presence var2, String var3, String var4);

    public void changeSubject(Message var1, MUCRole var2) throws ForbiddenException;

    public String getSubject();

    public void setSubject(String var1);

    public void sendPublicMessage(Message var1, MUCRole var2) throws ForbiddenException;

    public void sendPrivatePacket(Packet var1, MUCRole var2) throws NotFoundException, ForbiddenException;

    public Presence kickOccupant(JID var1, JID var2, String var3, String var4) throws NotAllowedException;

    public IQOwnerHandler getIQOwnerHandler();

    public IQAdminHandler getIQAdminHandler();

    public MUCRoomHistory getRoomHistory();

    public Collection<JID> getOwners();

    public Collection<JID> getAdmins();

    public Collection<JID> getMembers();

    public Collection<JID> getOutcasts();

    public Collection<MUCRole> getModerators();

    public Collection<MUCRole> getParticipants();

    public boolean canAnyoneDiscoverJID();

    public void setCanAnyoneDiscoverJID(boolean var1);

    public String canSendPrivateMessage();

    public void setCanSendPrivateMessage(String var1);

    public boolean canOccupantsChangeSubject();

    public void setCanOccupantsChangeSubject(boolean var1);

    public boolean canOccupantsInvite();

    public void setCanOccupantsInvite(boolean var1);

    public String getNaturalLanguageName();

    public void setNaturalLanguageName(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public boolean isMembersOnly();

    public List<Presence> setMembersOnly(boolean var1);

    public boolean isLogEnabled();

    public void setLogEnabled(boolean var1);

    public boolean isLoginRestrictedToNickname();

    public void setLoginRestrictedToNickname(boolean var1);

    public boolean canChangeNickname();

    public void setChangeNickname(boolean var1);

    public boolean isRegistrationEnabled();

    public void setRegistrationEnabled(boolean var1);

    public int getMaxUsers();

    public void setMaxUsers(int var1);

    public boolean isModerated();

    public void setModerated(boolean var1);

    public boolean isPasswordProtected();

    public String getPassword();

    public void setPassword(String var1);

    public boolean isPersistent();

    public void setPersistent(boolean var1);

    public boolean wasSavedToDB();

    public void setSavedToDB(boolean var1);

    public void saveToDB();

    public boolean isPublicRoom();

    public void setPublicRoom(boolean var1);

    public List<String> getRolesToBroadcastPresence();

    public void setRolesToBroadcastPresence(List<String> var1);

    public boolean canBroadcastPresence(String var1);

    public void lock(MUCRole var1) throws ForbiddenException;

    public void unlock(MUCRole var1) throws ForbiddenException;

    public void sendInvitation(JID var1, String var2, MUCRole var3, List<Element> var4) throws ForbiddenException, CannotBeInvitedException;

    public void sendInvitationRejection(JID var1, String var2, JID var3);

    public void send(Packet var1);
}

